/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.eas.base.multiapprove.client.AbstractPostActivityParticipantUI;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PostActivityParticipantUI
extends AbstractPostActivityParticipantUI {
    private static final String RESULT_KEY = "result";
    private static boolean returnValue;
    private static final Logger logger;
    private ResourceBundleHelper msgHelper = new ResourceBundleHelper("com.kingdee.eas.base.multiapprove.client.DesignatePerformer2Resource");
    private boolean hasNoPartipants;
    ArrayList persons;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ActivityInstInfo actInst = (ActivityInstInfo)this.getUIContext().get("actInst");
        ProcessDef processDef = (ProcessDef)this.getUIContext().get("processDef");
        this.tabMain.checkParsed();
        this.tabMain.getStyleAttributes().setLocked(true);
        this.persons = PostParticipantUtil.findPostParticipants((ActivityInstInfo)actInst, (ProcessDef)processDef);
        this.persons = this.reGetParticipantList(this.persons);
        this.hasNoPartipants = false;
        for (int i = 0; i < this.persons.size(); ++i) {
            Map item = (Map)this.persons.get(i);
            if (!PostActivityParticipantUI.addPersonToTable(this.tabMain, item)) continue;
            this.hasNoPartipants = true;
        }
    }

    private List<String> getActDefIds(ArrayList persons) {
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Object obj : persons) {
            String id = (String)((Map)obj).get("activityID");
            if (!set.add(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private ArrayList orderList(List<String> orderIds, ArrayList arr) {
        ArrayList temp = new ArrayList();
        for (String id : orderIds) {
            for (Object obj : arr) {
                String s = (String)((Map)obj).get("activityID");
                if (!id.equals(s)) continue;
                temp.add(obj);
            }
        }
        return temp;
    }

    public ArrayList reGetParticipantList(ArrayList persons) throws IOException, ClassNotFoundException, BOSException, SQLException {
        String s;
        Object o = this.getUIContext().get("owner");
        ArrayList array = null;
        List<String> orderIds = null;
        if (o instanceof IUIWindow && (o = ((IUIWindow)o).getUIObject()) instanceof CoreBillEditUI && (s = ((CoreBillEditUI)o).getEditData().getExtendedProperty("DesignateNextActivityPerformerWhenSubmit")) != null && s.length() > 0) {
            byte[] fieldValueByteArray = StringUtils.hexFromString((String)s);
            ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Map perMap = (Map)ois.readObject();
            Iterator it = perMap.keySet().iterator();
            orderIds = this.getActDefIds(persons);
            array = persons;
            while (it.hasNext()) {
                String key = (String)it.next();
                ArrayList personIds = (ArrayList)perMap.get(key);
                if (personIds == null || personIds.size() == 0) continue;
                String actDefId = key.substring(key.indexOf(64) + 1);
                Object[] objects = this.removeOriginalPersons(actDefId, array);
                String actName = (String)objects[0];
                array = (ArrayList)objects[1];
                if (personIds == null || personIds.size() <= 0) continue;
                ArrayList newPersons = this.getNewPersons(personIds, actName, actDefId);
                array.addAll(newPersons);
            }
        }
        if (array != null) {
            array = this.orderList(orderIds, array);
            return array;
        }
        return persons;
    }

    private Object[] removeOriginalPersons(String actDefId, ArrayList persons) {
        String actName = null;
        ArrayList<HashMap> newPersons = new ArrayList<HashMap>();
        for (HashMap map : persons) {
            if (map.get("activityID") != null && map.get("activityID").equals(actDefId)) {
                actName = (String)map.get("activityName");
                continue;
            }
            newPersons.add(map);
        }
        return new Object[]{actName, newPersons};
    }

    private ArrayList getNewPersons(ArrayList personIds, String actName, String actDefId) throws BOSException, SQLException {
        ArrayList list = PostParticipantUtil.queryPerson((String)"id", (String)"id,number,name,AdminOrgUnit.name,PositionMember.isPrimary,Position.name", (ArrayList)personIds, (String)"com.kingdee.eas.basedata.person.app.F7PersonQuery", (String)"name", null);
        for (HashMap map : list) {
            map.put("activityName", actName);
            map.put("activityID", actDefId);
        }
        return list;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private static boolean addPersonToTable(KDTable tbl, Map item) {
        IRow newRow = tbl.addRow();
        newRow.setUserObject((Object)item);
        newRow.getCell("activityName").setValue(item.get("activityName"));
        newRow.getCell("personNumber").setValue(item.get("number"));
        newRow.getCell("personName").setValue(item.get("name"));
        newRow.getCell("personPosition").setValue(item.get("Position.name"));
        newRow.getCell("personOrg").setValue(item.get("AdminOrgUnit.name"));
        return !item.containsKey("name");
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        int r;
        super.btnOK_actionPerformed(e);
        if (this.hasNoPartipants && (r = MsgBox.showConfirm2((String)this.msgHelper.getString("NoParticipants"))) == 2) {
            return;
        }
        returnValue = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        returnValue = false;
        this.getUIWindow().close();
        super.btnCancel_actionPerformed(e);
    }

    public static boolean check(IUIWindow owner, ActivityInstInfo actInst) throws UIException {
        returnValue = false;
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"actInst", (Object)actInst);
        uiContext.put((Object)"owner", (Object)owner);
        String className = PostActivityParticipantUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
        uiWindow.show();
        return returnValue;
    }

    public static boolean check(IUIWindow owner, ProcessDef processDef) throws UIException {
        returnValue = false;
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"processDef", (Object)processDef);
        uiContext.put((Object)"owner", (Object)owner);
        String className = PostActivityParticipantUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
        uiWindow.show();
        return returnValue;
    }

    static {
        logger = CoreUIObject.getLogger(PostActivityParticipantUI.class);
    }
}

