/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.test;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IWfMonitorService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.MultiApproveManageFactory;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class TestMultiApproveManager
extends TestCase {
    protected static final Logger logger = Logger.getLogger(TestMultiApproveManager.class);
    public static final int MAX_RETRY = 50;
    public static final int TIMESPAN = 5000;
    public static final String HOST = "127.0.0.1";
    public static final String URL = "tcp://127.0.0.1";

    public void init() throws BOSLoginException {
        int LOOP_SIZE = 100;
        String userName = "lily31";
        IEnactmentService service = null;
        IWfMonitorService monitorService = null;
        ILoginModule login = null;
        try {
            ORMRPCServiceLocator.setCurrentServiceURL((String)URL);
            login = LoginModuleFactory.getRemoteInstance();
            String ais = "EAS50";
            String solution = "eas";
            LoginContext ctx = new LoginContext(userName, "", solution, ais, new Locale("l2"));
            ctx.put("dbType", (Object)"MS_SQL_Server");
            login.login(ctx);
            service = EnactmentServiceFactory.createRemoteEnactService();
            monitorService = (IWfMonitorService)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.bos.workflow.service.ormrpc.WfMonitorService", IWfMonitorService.class);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public void testBatchApprove() throws EASBizException, BOSException, SQLException {
        MetaDataPK assignQeuryPk = new MetaDataPK("com.kingdee.bos.workflow.metas", "Assign");
        IQueryExecutor queryExe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)assignQeuryPk);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("FSTATE", (Object)new Integer(1)));
        fi.getFilterItems().add(new FilterItemInfo("FSTATE", (Object)new Integer(2)));
        fi.getFilterItems().add(new FilterItemInfo("FBIZFUNCTION", (Object)"com.kingdee.eas.base.multiapprove.client"));
        fi.setMaskString("(#0 or #1) and #3");
        ev.setFilter(fi);
        queryExe.setObjectView(ev);
        IRowSet rs = queryExe.executeQuery();
        HashMap<String, String> selectedBillIds = new HashMap<String, String>(5000);
        while (rs.next()) {
            selectedBillIds.put(rs.getString("FBIZOBJID"), rs.getString("FASSIGNID"));
        }
        ApproveResult result = ApproveResult.PASS;
        OptionEnum option = OptionEnum.NULL;
        String content = "Perform test!";
        Map successedIdList = MultiApproveManageFactory.getRemoteInstance().multiApprove(selectedBillIds, result, option, content);
    }
}

