/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.InheritPermFacadeFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserSubOrgUI;
import com.kingdee.eas.base.permission.client.UserSubOrgUI;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeleteUserSubOrgUI
extends AbstractUserSubOrgUI {
    private static final Logger logger = CoreUIObject.getLogger(UserSubOrgUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    public static final String ROLEPK = "ROLEPK";
    private static final String USER_NAME = "userName";
    private static final String USER_NUMBER = "userNumber";
    private static final String USER_ID = "id";
    private static final String ORG_NUMBER = "org.number";
    private static final String ORG_NAME = "org.name";
    public static final String USER_ORGS_MAP = "USER_ORGS_MAP";
    private UserInfo[] users = null;
    private IObjectPK selectedUserPK = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initUserTable();
    }

    private void initUI() {
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnConfirm.setText(EASResource.getString((String)RESOURCE, (String)"del4Log"));
        this.kDLabel1.setText(EASResource.getString((String)RESOURCE, (String)"SelectedUser"));
        this.kDLabel2.setText(EASResource.getString((String)RESOURCE, (String)"SelectedSubOrg"));
        this.setUITitle(EASResource.getString((String)RESOURCE, (String)"DeleteUserRoleForSubOrg"));
    }

    private IObjectPK getSelectedUserPK() {
        if (this.getUsers() == null || this.getUsers().length < 1) {
            return null;
        }
        if (this.selectedUserPK == null) {
            return new ObjectUuidPK(this.getUsers()[0].getId());
        }
        return this.selectedUserPK;
    }

    private String[] getOrgLongNumbers() {
        Collection orgIds = (Collection)this.getUserOrgsMap().get(this.getSelectedUserPK().toString());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(USER_ID, (Object)orgIds, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("longNumber"));
        view.setFilter(filter);
        FullOrgUnitCollection orgCol = null;
        try {
            orgCol = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        String[] longNumbers = new String[orgCol.size()];
        for (int i = 0; i < longNumbers.length; ++i) {
            longNumbers[i] = orgCol.get(i).getLongNumber();
        }
        return longNumbers;
    }

    private void initUserTable() {
        if (this.getUsers() == null) {
            return;
        }
        for (int i = 0; i < this.getUsers().length; ++i) {
            UserInfo user = this.getUsers()[i];
            IRow row = this.kdtUser.addRow();
            row.getCell(USER_NAME).setValue((Object)user.getName());
            row.getCell(USER_NUMBER).setValue((Object)user.getNumber());
            row.getCell(USER_ID).setValue((Object)user.getId());
        }
        this.kdtUser.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                DeleteUserSubOrgUI.this.kdtUser_activeCellChanged(e);
            }
        });
    }

    protected void kdtUser_activeCellChanged(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtUser.getRow(rowIndex);
        if (rowIndex >= 0 && row != null) {
            this.selectedUserPK = new ObjectStringPK(row.getCell(USER_ID).getValue().toString());
            try {
                this.mainQuery = new EntityViewInfo();
                this.mainQuery.setFilter(this.getDefaultFilterForQuery());
                this.execQuery();
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo defaultFilter = super.getDefaultFilterForQuery();
        IObjectPK userPK = this.getSelectedUserPK();
        FilterInfo filter = new FilterInfo();
        FilterInfo orgFilter = new FilterInfo();
        String[] longNumbers = this.getOrgLongNumbers();
        for (int i = 0; i < longNumbers.length; ++i) {
            FilterItemInfo subFilterItem = new FilterItemInfo("org.longNumber", (Object)(longNumbers[i] + "!%"), CompareType.LIKE);
            FilterInfo longNumberFilter = new FilterInfo();
            longNumberFilter.getFilterItems().add(subFilterItem);
            try {
                orgFilter.mergeFilter(longNumberFilter, "or");
                continue;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        FilterItemInfo userFilterItem = new FilterItemInfo("user.id", (Object)userPK);
        FilterItemInfo typeFilterItem = new FilterItemInfo("type", (Object)String.valueOf(10));
        filter.getFilterItems().add(typeFilterItem);
        filter.getFilterItems().add(userFilterItem);
        try {
            filter.mergeFilter(orgFilter, "and");
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        if (defaultFilter == null || defaultFilter.getFilterItems().size() == 0) {
            return filter;
        }
        try {
            defaultFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return defaultFilter;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (e.getClickCount() == 1 && rowIndex < 0) {
            super.tblMain_tableClicked(e);
        }
    }

    private Map getUserOrgsMap() {
        return (Map)this.getUIContext().get(USER_ORGS_MAP);
    }

    private UserInfo[] getUsers() {
        if (this.users == null) {
            Map userOrgsMap = this.getUserOrgsMap();
            FilterInfo filter = new FilterInfo();
            HashSet<String> userIds = new HashSet<String>();
            Iterator userItr = userOrgsMap.keySet().iterator();
            while (userItr.hasNext()) {
                userIds.add(userItr.next().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo(USER_ID, userIds, CompareType.INCLUDE));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            UserCollection userCol = null;
            try {
                userCol = UserFactory.getRemoteInstance().getUserCollection(view);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.users = new UserInfo[userCol.size()];
            for (int i = 0; i < this.users.length; ++i) {
                this.users[i] = userCol.get(i);
            }
        }
        return this.users;
    }

    private IObjectPK getRolePK() {
        return (IObjectPK)this.getUIContext().get(ROLEPK);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getKeyFieldName() {
        return "org.id";
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> userCol = new HashSet<String>();
        for (int i = 0; i < this.getUsers().length; ++i) {
            userCol.add(this.getUsers()[i].getId().toString());
        }
        InheritPermFacadeFactory.getRemoteInstance().deleteUserSubOrgsRoles(this.getUserOrgsMap(), this.getRolePK());
        this.getUIWindow().close();
    }

    @Override
    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{ORG_NUMBER, ORG_NAME};
        return locateNames;
    }
}

