/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.FingerprintLoginStateEnum;
import com.kingdee.eas.base.permission.FingerprintUserCollection;
import com.kingdee.eas.base.permission.FingerprintUserFactory;
import com.kingdee.eas.base.permission.FingerprintUserInfo;
import com.kingdee.eas.base.permission.IFingerprintUser;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.UserAuthenWayChangeFacadeFactory;
import com.kingdee.eas.base.permission.UserAuthenWayChangeStateEnum;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractFingerprintUserListUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.UITableHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.security.client.FingerprintConfigUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FingerprintUserListUI
extends AbstractFingerprintUserListUI {
    private static final Logger logger = CoreUIObject.getLogger(FingerprintUserListUI.class);
    private static String FINGERPRINT_INDEX_NAME = "fingerprintState";
    private static String USER_LOGIN_AUTHOR_WAY_INDEX_NAME = "user.loginAuthorWay";
    private static String ID_INDEX_NAME = "id";
    private static String USER_ID_NAME = "user.id";
    private IFingerprintUser iFingerprintUser = null;
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";

    public FingerprintUserListUI() throws Exception {
        this.initButton();
    }

    private void initButton() {
        this.btnStartFinger.setIcon(EASResource.getIcon((String)"imgLight_green"));
        this.btnStartFinger.setVisible(true);
        this.btnStartFinger.setEnabled(true);
    }

    private FilterInfo getRangeUser() throws EASBizException, BOSException, UuidException, ParserException {
        UserListUIHelper helper = new UserListUIHelper();
        return helper.getCurrentRangeUserMayBeAdmin();
    }

    private EntityViewInfo getMaySelectUser() throws Exception {
        FilterInfo filterInfo = this.getRangeUser();
        FilterInfo notSelectUserFilterInfo = this.getNotIncludeUser();
        if (notSelectUserFilterInfo != null) {
            filterInfo.mergeFilter(notSelectUserFilterInfo, "AND");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private List getAlreadUserId() throws Exception {
        ArrayList retList = new ArrayList();
        FingerprintUserCollection fingerprintCol = this.getFingerprintUser().getFingerprintUserCollection("select id, user.id");
        if (fingerprintCol == null || fingerprintCol.isEmpty()) {
            return retList;
        }
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)fingerprintCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                FingerprintUserInfo dynamicCardUserInfo = (FingerprintUserInfo)obj;
                if (dynamicCardUserInfo.getUser() != null && dynamicCardUserInfo.getUser().getId() != null) {
                    return dynamicCardUserInfo.getUser().getId().toString();
                }
                return null;
            }
        });
    }

    private FilterInfo getNotIncludeUser() throws Exception {
        List alreadlyUserIdList = this.getAlreadUserId();
        if (alreadlyUserIdList == null || alreadlyUserIdList.isEmpty()) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(alreadlyUserIdList, false), CompareType.NOTINCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("id ", (Object)"00000000-0000-0000-0000-00000000000113B7DE7F", CompareType.NOTEQUALS));
        return filterInfo;
    }

    @Override
    public void actionSelectUser_actionPerformed(ActionEvent e) throws Exception {
        KDCommonPromptDialog dlg = this.getUserDialog();
        dlg.show();
        if (!dlg.isCanceled()) {
            Object obj = dlg.getData();
            if (obj != null && obj instanceof Object[]) {
                Object[] objAry = (Object[])obj;
                FingerprintUserCollection dynamicUserMapCol = new FingerprintUserCollection();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < objAry.length; ++i) {
                    FingerprintUserInfo fingerprintUserInfo = new FingerprintUserInfo();
                    UserInfo userInfo = (UserInfo)objAry[i];
                    fingerprintUserInfo.setUser(userInfo);
                    fingerprintUserInfo.setFingerprintState(FingerprintLoginStateEnum.init);
                    dynamicUserMapCol.add(fingerprintUserInfo);
                    sb.append(userInfo.getNumber()).append("\uff1b");
                }
                sb.deleteCharAt(sb.length() - 1);
                IObjectPK logPK = LogUtil.beginLog(null, (String)"addnewMany", (BOSObjectType)new BOSObjectType("2CC61BB4"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"ADDNEW_USER_FINGER_AUTHEN") + "\u201c" + sb.toString() + "\u201d"), (String)"finger_chose_user");
                this.getFingerprintUser().addnewMany(dynamicUserMapCol);
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
            this.refreshList();
        }
    }

    private KDCommonPromptDialog getUserDialog() throws Exception {
        IUIWindow win = this.getUIWindow();
        UserPromptBox dlg = new UserPromptBox(win.getUIObject());
        dlg.setEnabledMultiSelection(true);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
        dlg.setQueryInfo(queryPK);
        dlg.setHasCUDefaultFilter(false);
        EntityViewInfo entityViewInfo = this.getMaySelectUser();
        dlg.setEntityViewInfo(entityViewInfo);
        return dlg;
    }

    @Override
    public void actionCancelUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String promptStr = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                BizEnumValueInfo dynamicState = (BizEnumValueInfo)this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, FINGERPRINT_INDEX_NAME));
                BizEnumValueInfo loginAuthorWay = (BizEnumValueInfo)this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, USER_LOGIN_AUTHOR_WAY_INDEX_NAME));
                if (0 == loginAuthorWay.getInt()) {
                    arrayList.add(this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, ID_INDEX_NAME)));
                    sb.append(this.tblMain.getValueAt(j, UITools.getColumnIndexByName(this.tblMain, "user.number"))).append(",");
                    continue;
                }
                if (promptStr != null) continue;
                promptStr = EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionUsbKeyResource", (String)"ONLY_NORMAL_USER_BE_CANCEL");
            }
        }
        if (arrayList.isEmpty()) {
            logger.info((Object)"no data select , return!");
            if (promptStr != null) {
                MsgBox.showInfo((Component)((Object)this), promptStr);
            }
            return;
        }
        ObjectStringPK[] idPKAry = new ObjectStringPK[arrayList.size()];
        int size2 = arrayList.size();
        for (int i = 0; i < size2; ++i) {
            idPKAry[i] = new ObjectStringPK((String)arrayList.get(i));
        }
        IObjectPK logPK = LogUtil.beginLog(null, (String)"delete", (BOSObjectType)new BOSObjectType("2CC61BB4"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + sb.toString() + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"FINGER_AUTHEN_LIST_DELETE")), (String)"finger_delete_user");
        this.getFingerprintUser().delete((IObjectPK[])idPKAry);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.tblMain.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionExportUser_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        List userId = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, USER_ID_NAME));
        IUser iUser = UserFactory.getRemoteInstance();
        String oql = "select id,name where isDelete=0 and id in (" + ToolUtils.aryToStr(userId, true) + ")";
        UserCollection userCol = iUser.getUserCollection(oql);
        String fileName = this.getFileName();
        if (StringUtils.isEmpty((String)fileName)) {
            return;
        }
        File file = new File(fileName);
        FileOutputStream fileOut = null;
        OutputStreamWriter fileOutStream = null;
        try {
            fileOut = new FileOutputStream(file);
            fileOutStream = new OutputStreamWriter((OutputStream)fileOut, "UTF-8");
            int size = userCol.size();
            for (int i = 0; i < size; ++i) {
                UserInfo userInfo = userCol.get(i);
                fileOutStream.write(userInfo.getId().toString() + "," + userInfo.getName() + "\r\n");
                if (i % 100 != 0) continue;
                fileOut.flush();
            }
        }
        finally {
            if (fileOutStream != null) {
                try {
                    fileOutStream.close();
                }
                catch (IOException ioException) {
                    logger.error((Object)ioException.getMessage(), (Throwable)ioException);
                    this.handUIException(ioException);
                }
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ioException) {
                    logger.error((Object)ioException.getMessage(), (Throwable)ioException);
                    this.handUIException(ioException);
                }
            }
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
    }

    private String getFileName() {
        KDFileChooser fc = new KDFileChooser(System.getProperty("user.home"));
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        int retVal = fc.showOpenDialog((Component)((Object)this));
        if (retVal == 1) {
            return null;
        }
        return fc.getSelectedFile().getAbsolutePath();
    }

    @Override
    public void actionForbidden_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        this.setFingerprintLoginState(FingerprintLoginStateEnum.forbid);
        this.setUserLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        tableHelper.restoreRow();
    }

    @Override
    public void actionStartUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        this.setUserLoginAuthorWay(LoginAuthorWayEnum.FINGERPRINT);
        this.setFingerprintLoginState(FingerprintLoginStateEnum.started);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        tableHelper.restoreRow();
    }

    private void setFingerprintLoginState(FingerprintLoginStateEnum fingerprintLoginState) throws EASBizException, BOSException, Exception {
        ArrayList idList = this.getSelectedIdValues();
        Object someDataNotRight = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String dynamicCardMapId = (String)idList.get(i);
            FingerprintUserInfo FingerprintUserInfo2 = this.getFingerprintUser().getFingerprintUserInfo("select *,user.number where id='" + dynamicCardMapId + "'");
            FingerprintUserInfo2.setFingerprintState(fingerprintLoginState);
            IObjectPK logPK = null;
            logPK = FingerprintLoginStateEnum.started.equals((Object)fingerprintLoginState) ? LogUtil.beginLog(null, (String)"update", (BOSObjectType)new BOSObjectType("2CC61BB4"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + FingerprintUserInfo2.getUser().getNumber() + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"ENABLE_FINGER_AUTHEN")), (String)"finger_enable_machine") : LogUtil.beginLog(null, (String)"update", (BOSObjectType)new BOSObjectType("2CC61BB4"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + FingerprintUserInfo2.getUser().getNumber() + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"RESTORE_LOGIN_AUTHEN")), (String)"finger_disable_machine");
            this.getFingerprintUser().update((IObjectPK)new ObjectStringPK(dynamicCardMapId), FingerprintUserInfo2);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
    }

    private void unregisterUserCertfication(List userList) throws BOSException, EASBizException {
        UserFactory.getRemoteInstance().setRegisterResult(userList, false);
    }

    private List getSelectUserIDList() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        Iterator it = range.iterator();
        ArrayList<String> userIDList = new ArrayList<String>();
        while (it.hasNext()) {
            KDTSelectBlock block = (KDTSelectBlock)it.next();
            int bottom = block.getBottom();
            for (int index = block.getTop(); index <= bottom; ++index) {
                String userId = (String)this.tblMain.getRow(index).getCell(USER_ID_NAME).getValue();
                if (StringUtils.isEmpty((String)userId)) continue;
                userIDList.add(userId);
            }
        }
        return userIDList;
    }

    private void setUserLoginAuthorWay(LoginAuthorWayEnum loginAuthorWayEnum) throws EASBizException, BOSException {
        List userIdList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, USER_ID_NAME));
        List userNumberList = UITools.getUserIdList(this.tblMain, UITools.getColumnIndexByName(this.tblMain, "user.number"));
        if (userIdList != null && !userIdList.isEmpty()) {
            IUser iUser = UserFactory.getRemoteInstance();
            IObjectPK logPK = null;
            logPK = !LoginAuthorWayEnum.NORMAL.equals((Object)loginAuthorWayEnum) ? LogUtil.beginLog(null, (String)"updateLoginAuthorWay", (BOSObjectType)new BOSObjectType("2CC61BB4"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + ToolUtils.aryToStr(userNumberList.toArray(), true) + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"ENABLE_LOGIN_AUTHEN")), (String)"finger_enable_login") : LogUtil.beginLog(null, (String)"updateLoginAuthorWay", (BOSObjectType)new BOSObjectType("2CC61BB4"), null, (String)(EASResource.getString((String)RESOURCE_NAME, (String)"user") + "\u201c" + ToolUtils.aryToStr(userNumberList.toArray(), true) + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"RESTORE_LOGIN_AUTHEN")), (String)"finger_disable_login");
            iUser.updateLoginAuthorWay(userIdList, loginAuthorWayEnum);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
    }

    @Override
    public void actionRestoreUser_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        if (!MsgBox.isOk((int)MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_NAME, (String)"user_authorway_change_prompt")))) {
            return;
        }
        List fingerPrintAuthenWayUserIDList = this.getSelectFingerprintAuthenWayUserIDList();
        this.unregisterUserCertfication(fingerPrintAuthenWayUserIDList);
        UserAuthenWayChangeFacadeFactory.getRemoteInstance().userAuthenWayChange(fingerPrintAuthenWayUserIDList, 30, UserAuthenWayChangeStateEnum.FingerPrint_RestoreNormalAuthenWay.getAlias());
        this.setUserLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
        tableHelper.restoreRow();
    }

    private List getSelectFingerprintAuthenWayUserIDList() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        Iterator it = range.iterator();
        ArrayList<String> userIDList = new ArrayList<String>();
        while (it.hasNext()) {
            KDTSelectBlock block = (KDTSelectBlock)it.next();
            int bottom = block.getBottom();
            for (int index = block.getTop(); index <= bottom; ++index) {
                int loginAuthenWay;
                String userId = (String)this.tblMain.getRow(index).getCell(USER_ID_NAME).getValue();
                if (StringUtils.isEmpty((String)userId) || (loginAuthenWay = ((BizEnumValueInfo)this.tblMain.getRow(index).getCell(USER_LOGIN_AUTHOR_WAY_INDEX_NAME).getValue()).getInt()) == 0) continue;
                userIDList.add(userId);
            }
        }
        return userIDList;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FingerprintUserFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            FilterInfo filterInfo = new FilterInfo("CU.id IN (" + PermissionRangeHelper.getUserOrgIdRangeSQL(null, ToolUtils.getCurrentUserPK(), null) + ")");
            return filterInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private IFingerprintUser getFingerprintUser() throws Exception {
        if (this.iFingerprintUser == null) {
            this.iFingerprintUser = (IFingerprintUser)this.getBizInterface();
        }
        return this.iFingerprintUser;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"user.number", "user.name"};
        return locateNames;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectUser.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionSelectUser.setEnabled(true);
        this.menuSelect.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnCancelUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.menuCancelUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnExportUser.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnForbidden.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemForbidUsbKey.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemStartLoginAuthorWay.setIcon(EASResource.getIcon((String)"imgTbtn_reappperform"));
        this.btnRestore.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.menuItemRestoreLoginAuthorWay.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
    }

    @Override
    public void actionServerConfig_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FingerprintConfigUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
    }

    @Override
    public void actionStartFinger_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UITableHelper tableHelper = new UITableHelper(this.tblMain);
        tableHelper.recordRow();
        this.setFingerprintLoginState(FingerprintLoginStateEnum.started);
        this.tblMain.refresh();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        tableHelper.restoreRow();
    }
}

