/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.FindedTooMuchRecordsException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.CaOrgRangeInfo;
import com.kingdee.eas.base.permission.CaOrgRangeParam;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IIDSecondAuthorize;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.client.AbstractIDSecondAuthorizeCaOrgEditUI;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.client.BizOrgRangeF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IDSecondAuthorizeCaOrgEditUI
extends AbstractIDSecondAuthorizeCaOrgEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IDSecondAuthorizeCaOrgEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    private Map authTypes = null;
    private Map permItemList = null;
    private String PERMITEMS_LIST = "permItems";
    private KDTreeNode currentNode = null;
    private String CURRENT_NODE = "currentNode";
    private static String PERMITEMALIAS_CELLNAME = "permItemAlias";
    private static String PERMITEM_CELLNAME = "permItem";
    private static String Org_CELLNAME = "id";
    private UserInfo userInfo = null;
    private String selectedOrgIdSQL = null;
    private Set selectedOrgs = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
    }

    private void initContext() {
        this.permItemList = (Map)this.getUIContext().get(this.PERMITEMS_LIST);
        if (this.permItemList == null) {
            this.permItemList = new HashMap();
        }
        this.currentNode = (KDTreeNode)this.getUIContext().get(this.CURRENT_NODE);
        if (this.currentNode == null) {
            this.currentNode = new KDTreeNode((Object)"EAS");
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.getAuthTypeMap();
        this.initLeftTable(this.currentNode);
        this.initRightTable();
    }

    private void getAuthTypeMap() throws BOSException {
        this.authTypes = IDSecondAuthorizeFactory.getRemoteInstance().getAuthorizeMap();
        if (this.authTypes == null) {
            this.authTypes = new HashMap();
        }
    }

    private void initLeftTable(KDTreeNode root) {
        if (root == null) {
            return;
        }
        this.bindPermItem2Table(root);
        if (!root.isLeaf()) {
            Enumeration permItemEnum = root.children();
            while (permItemEnum.hasMoreElements()) {
                KDTreeNode node = (KDTreeNode)permItemEnum.nextElement();
                this.initLeftTable(node);
            }
        }
    }

    private void bindPermItem2Table(KDTreeNode node) {
        if (!this.permItemList.containsKey(node)) {
            return;
        }
        List leafs = (List)this.permItemList.get(node);
        for (PermItemInfo permItem : leafs) {
            AuthorizeTypeEnum type = AuthorizeTypeEnum.noAuthor;
            if (this.authTypes.get(permItem.getId().toString()) != null) {
                type = (AuthorizeTypeEnum)((Object)this.authTypes.get(permItem.getId().toString()));
            }
            if (type.getName().indexOf("caAuth") == -1) continue;
            IRow row = this.authWayTable.addRow();
            row.getCell(PERMITEMALIAS_CELLNAME).setValue((Object)permItem.getAlias());
            row.getCell(PERMITEM_CELLNAME).setValue((Object)permItem);
            String description = PermissionCommonUtil.getAuthorizeDiscription(type, true);
            row.getCell("authWay").setValue((Object)description);
            row.getStyleAttributes().setLocked(true);
        }
    }

    private void initRightTable() throws Exception {
        String permItem = null;
        permItem = StringUtils.isEmpty((String)this.selectedOrgIdSQL) ? this.getFirstPermItem().getId().toString() : this.getSelectPermItem().getId().toString();
        this.selectedOrgIdSQL = "select forgid from t_pm_caorgrange where fPermItem = '" + permItem + "'";
        try {
            this.selectedOrgs = new HashSet();
            Map result = NewOrgF7FacadeFactory.getRemoteInstance().getOrgInfosByQuerySQL(this.selectedOrgIdSQL);
            if (result != null && result.size() > 0) {
                this.selectedOrgs.addAll(result.values());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        this.fillDataToSelectTable();
    }

    protected void fillDataToSelectTable() throws BOSException {
        this.tblMainSelected.removeRows();
        for (CoreBaseInfo info : this.selectedOrgs) {
            String[] cellValues = this.getTableCellValues(info);
            this.fullfillRowValue(this.getInsertIndexByInfo(info), cellValues);
        }
    }

    protected String[] getTableCellValues(CoreBaseInfo info) {
        String[] cellValues = new String[6];
        if (info != null && info.getId() != null) {
            cellValues[0] = info.getId().toString();
            FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)info;
            cellValues[1] = unitInfo.getName();
            cellValues[2] = unitInfo.getNumber();
            cellValues[3] = unitInfo.getLongNumber();
            cellValues[4] = unitInfo.getOrgTypeStr();
            cellValues[5] = unitInfo.getCode();
        }
        return cellValues;
    }

    private void fillDataToSelectTable(CoreBaseCollection coll) {
        if (coll != null) {
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                CoreBaseInfo info = coll.get(i);
                this.selectedOrgs.add(info);
                String[] cellValues = this.getTableCellValues(info);
                this.fullfillRowValue(this.getInsertIndexByInfo(info), cellValues);
            }
        }
    }

    protected void fullfillRowValue(int insertPosition, String[] cellValues) {
        if (cellValues != null && cellValues.length == 6) {
            IRow row = null;
            row = -1 == insertPosition ? this.tblMainSelected.addRow() : this.tblMainSelected.addRow(insertPosition);
            row.getCell("id").setValue((Object)cellValues[0]);
            row.getCell("name").setValue((Object)cellValues[1]);
            row.getCell("number").setValue((Object)cellValues[2]);
            row.getCell("longNumber").setValue((Object)cellValues[3]);
            row.getCell("orgTypeStr").setValue((Object)cellValues[4]);
            row.getCell("code").setValue((Object)cellValues[5]);
        }
    }

    private int getInsertIndexByInfo(CoreBaseInfo info) {
        if (info != null && !StringUtils.isEmpty((String)info.getString("longNumber"))) {
            String longNumber;
            int index;
            for (index = 0; index < this.tblMainSelected.getRowCount() && (StringUtils.isEmpty((String)(longNumber = (String)this.tblMainSelected.getRow(index).getCell("longNumber").getValue())) || longNumber.compareTo(info.getString("longNumber")) <= 0); ++index) {
            }
            return index;
        }
        return 0;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        PermItemInfo permItem = this.getSelectPermItem();
        if (permItem.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoSelectPermItemFirst"));
            return;
        }
        FullOrgUnitInfo[] newSelectedOrgs = null;
        BizOrgRangeF7PromptDialog orgF7 = null;
        orgF7 = new BizOrgRangeF7PromptDialog((IUIObject)this, this.getUser());
        StringBuffer selectedOrgSQL = new StringBuffer();
        selectedOrgSQL.append("select forgid from t_pm_caorgrange where fPermItem = '").append(this.getSelectPermItem().getId().toString()).append("'");
        orgF7.setSelectedOrgIdSQL(selectedOrgSQL.toString());
        orgF7.show();
        newSelectedOrgs = PermissionUIHelper.getOrgs(orgF7.getData());
        HashSet<String> newSelectedOrgIdSet = new HashSet<String>();
        if (newSelectedOrgs == null) {
            return;
        }
        for (int i = newSelectedOrgs.length - 1; i >= 0; --i) {
            newSelectedOrgIdSet.add(newSelectedOrgs[i].getId().toString());
        }
        Set oldSelectedOrgs = this.getOldSelectedOrgs();
        Collection deletedOrgs = this.getNotContain(newSelectedOrgIdSet, oldSelectedOrgs);
        Collection addedOrgs = this.getNotContain(oldSelectedOrgs, newSelectedOrgIdSet);
        this.isOutOfOrgRange(deletedOrgs, 2);
        this.isOutOfOrgRange(addedOrgs, 1);
        this.saveOrgRange(this.getOrgRangeParam(deletedOrgs, addedOrgs, null));
        this.initRightTable();
    }

    private UserInfo getUser() {
        IObjectPK userPK = (IObjectPK)this.getUIContext().get("USER.PK");
        if (this.userInfo == null) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("defOrgUnit.*"));
            try {
                this.userInfo = UserFactory.getRemoteInstance().getUserInfo(userPK, selectors);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.userInfo;
    }

    private Set getOldSelectedOrgs() throws Exception {
        IIDSecondAuthorize iIDSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
        Set oldSelectedOrgs = null;
        try {
            oldSelectedOrgs = iIDSecondAuthorize.getOrgIdByPermItemId(this.getSelectPermItem().getId().toString());
        }
        catch (FindedTooMuchRecordsException e1) {
            logger.warn((Object)e1);
        }
        return oldSelectedOrgs;
    }

    private Collection getNotContain(Collection container, Collection containee) {
        ArrayList notContain = new ArrayList();
        for (Object obj : containee) {
            if (container.contains(obj)) continue;
            notContain.add(obj);
        }
        return notContain;
    }

    private void saveOrgRange(CaOrgRangeParam orgRangeParam) throws Exception {
        IIDSecondAuthorize iIDSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
        iIDSecondAuthorize.saveOrgRange(orgRangeParam);
        CacheService.getInstance().discardAll();
    }

    private CaOrgRangeParam getOrgRangeParam(Collection deletedOrgs, Collection addedOrgs, CaOrgRangeInfo changedOrgRange) {
        ObjectUuidPK permItemPK = new ObjectUuidPK(this.getSelectPermItem().getId().toString());
        OrgRangeType orgRangeType = this.getOrgRangeType();
        return new CaOrgRangeParam((IObjectPK)permItemPK, orgRangeType, deletedOrgs, addedOrgs, changedOrgRange);
    }

    private OrgRangeType getOrgRangeType() {
        UserType userType = this.getUser().getType();
        if (Administrator.isAdminType(userType)) {
            return OrgRangeType.BIZ_ORG_TYPE;
        }
        return null;
    }

    @Override
    protected void authWayTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.initRightTable();
    }

    private PermItemInfo getFirstPermItem() {
        PermItemInfo permItem = new PermItemInfo();
        if (this.authWayTable.getRow(0) == null) {
            permItem.setId(BOSUuid.create((String)"1"));
        } else {
            permItem = (PermItemInfo)this.authWayTable.getRow(0).getCell(PERMITEM_CELLNAME).getValue();
        }
        return permItem;
    }

    private PermItemInfo getSelectPermItem() {
        KDTSelectBlock block;
        int rIndex;
        PermItemInfo permItem = new PermItemInfo();
        KDTRange range = this.authWayTable.getSelectManager().toRange();
        if (range.size() > 0 && range.get(0) != null && (rIndex = (block = (KDTSelectBlock)range.get(0)).getBeginRow()) >= 0) {
            permItem = (PermItemInfo)this.authWayTable.getRow(rIndex).getCell(PERMITEM_CELLNAME).getValue();
        }
        return permItem;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        Collection deletedOrgs = this.getSelectOrgList();
        PermItemInfo permItemInfo = this.getSelectPermItem();
        if (permItemInfo.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoSelectFunction"));
            return;
        }
        if (deletedOrgs == null || deletedOrgs.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"infoSelectOrg"));
            return;
        }
        this.isOutOfOrgRange(deletedOrgs, 2);
        HashSet newSelectedOrgIdSet = new HashSet();
        Set oldSelectedOrgs = this.getOldSelectedOrgs();
        Collection addedOrgs = this.getNotContain(oldSelectedOrgs, newSelectedOrgIdSet);
        this.saveOrgRange(this.getOrgRangeParam(deletedOrgs, addedOrgs, null));
        this.initRightTable();
    }

    private Collection getSelectOrgList() throws BOSException, EASBizException {
        ArrayList<Object> orgList = new ArrayList<Object>();
        KDTRange range = this.tblMainSelected.getSelectManager().toRange();
        if (range.size() > 0 && range.get(0) != null) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int endRow = block.getEndRow();
            for (int rIndex = block.getBeginRow(); rIndex <= endRow; ++rIndex) {
                if (rIndex < 0) continue;
                orgList.add(this.tblMainSelected.getRow(rIndex).getCell(Org_CELLNAME).getValue());
            }
        }
        return orgList;
    }

    private boolean isOutOfOrgRange(Collection orgList, int index) throws BOSException, EASBizException {
        IIDSecondAuthorize iIDSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
        IOrgRangeIncludeSubOrg iOrgRangeIncludeSubOrg = OrgRangeIncludeSubOrgFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Collection orgControlUnit = iIDSecondAuthorize.getOrgControlUnit(orgList);
        Set cunrrenOrgControlUnit = iOrgRangeIncludeSubOrg.getOrgIdsByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        if (!cunrrenOrgControlUnit.containsAll(orgControlUnit)) {
            String errorMsg = null;
            switch (index) {
                case 1: {
                    errorMsg = EASResource.getString((String)RESOURCE, (String)"infoAddOrgMsg");
                    break;
                }
                case 2: {
                    errorMsg = EASResource.getString((String)RESOURCE, (String)"infoDeleteOrgMsg");
                    break;
                }
                default: {
                    errorMsg = EASResource.getString((String)RESOURCE, (String)"infoDeleteOrgMsg");
                }
            }
            MsgBox.showError((String)errorMsg);
            SysUtil.abort();
        }
        return true;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }
}

