/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IDSecondAuthorizeCollection;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IDSecondAuthorizeInfo;
import com.kingdee.eas.base.permission.IIDSecondAuthorize;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.client.AbstractIDSecondAuthorizeEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IDSecondAuthorizeEditUI
extends AbstractIDSecondAuthorizeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IDSecondAuthorizeEditUI.class);
    private int DEFAULT_INDEX = 3;
    private List permItemList = null;
    private Map authTypes = null;
    private String currentNodeNamePath = null;
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";
    private String PERM_LIST = "permList";
    private String AUTH_TYPES = "authTypes";
    private static String SELECT_CELLNAME = "select";
    private static String WAYALIAS_CELLNAME = "wayAlias";
    private static String DISCRIPTION_CELLNAME = "discription";
    private static String AUTHWAY_CELLNAME = "authWay";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
    }

    private void initContext() {
        this.permItemList = (List)this.getUIContext().get(this.PERM_LIST);
        if (this.permItemList == null) {
            this.permItemList = new ArrayList();
        }
        this.authTypes = (Map)this.getUIContext().get(this.AUTH_TYPES);
        if (this.authTypes == null) {
            this.authTypes = new HashMap();
        }
        this.currentNodeNamePath = (String)this.getUIContext().get("currentNodeNamePath");
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initTable();
    }

    private void initTable() {
        this.tblAuthWay.removeRows();
        Iterator it = AuthorizeTypeEnum.iterator();
        AuthorizeTypeEnum authorizeType = this.getSelectedAuthorizeType();
        while (it.hasNext()) {
            AuthorizeTypeEnum type = (AuthorizeTypeEnum)((Object)it.next());
            if (type.equals((Object)AuthorizeTypeEnum.dynAndUsb) || type.equals((Object)AuthorizeTypeEnum.usbAndDyn) || type.equals((Object)AuthorizeTypeEnum.caAuthOnlySignature) || !this.isValidAuthorizeType(type)) continue;
            String description = PermissionCommonUtil.getAuthorizeDiscription(type);
            IRow row = this.addRow(type, description);
            if (!type.equals((Object)authorizeType)) continue;
            row.getCell(SELECT_CELLNAME).setValue((Object)Boolean.TRUE);
        }
    }

    private AuthorizeTypeEnum getSelectedAuthorizeType() {
        if (this.permItemList != null && this.permItemList.size() == 1) {
            try {
                IIDSecondAuthorize iIDSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
                AuthorizeTypeEnum authorizeType = iIDSecondAuthorize.getAuthorizeType(((PermItemInfo)this.permItemList.get(0)).getName());
                return authorizeType;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return AuthorizeTypeEnum.noAuthor;
    }

    private boolean isValidAuthorizeType(AuthorizeTypeEnum type) {
        boolean bResult = true;
        if (type.equals((Object)AuthorizeTypeEnum.pwdAuthor) && !PermissionCommonUtil.isPasswordIDAuthorizeEnabled(null)) {
            bResult = false;
        }
        if (type.equals((Object)AuthorizeTypeEnum.caAuthOnlyVerfiy) && !"true".equalsIgnoreCase(PermissionCommonUtil.getPermissionParameter(null, "caAuthOnlyVerifyIDAuthorizeEnabled"))) {
            bResult = false;
        }
        return bResult;
    }

    private IRow addRow(AuthorizeTypeEnum authWay, String authDiscription) {
        IRow row = this.tblAuthWay.addRow();
        row.getCell(SELECT_CELLNAME).setValue((Object)Boolean.FALSE);
        row.getCell(AUTHWAY_CELLNAME).setValue((Object)authWay);
        row.getCell(WAYALIAS_CELLNAME).setValue((Object)authWay.getAlias());
        row.getCell(DISCRIPTION_CELLNAME).setValue((Object)authDiscription);
        row.getStyleAttributes().setLocked(true);
        row.getCell(SELECT_CELLNAME).getStyleAttributes().setLocked(false);
        return row;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kbCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void kbOk_actionPerformed(ActionEvent e) throws Exception {
        this.save();
        this.destroyWindow();
    }

    private void save() {
        try {
            IIDSecondAuthorize iIDSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
            IDSecondAuthorizeCollection[] coll = this.getModifiedPermItems();
            IDSecondAuthorizeInfo info = coll[2].get(0);
            IObjectPK logPK = LogUtil.beginLog(null, (String)"saveAuthorizeResult", (BOSObjectType)new BOSObjectType("950E2203"), null, (String)(" " + EASResource.getString((String)RESOURCE_NAME, (String)"ANSWER") + "\u201c" + info.getPermItem().toString() + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"FUNCTION_SEETING") + " \u201c" + info.getAuthorizeType().toString() + "\u201d" + EASResource.getString((String)RESOURCE_NAME, (String)"SECOND_AUTHEN")), (String)"second_authorize_plan_setting");
            iIDSecondAuthorize.saveAuthorizeResult(coll);
            LogUtil.afterLog(null, (IObjectPK)logPK);
        }
        catch (EASBizException e) {
            logger.error((Object)(PermissionResUtil.getResource("res_88") + (Object)((Object)e)));
        }
        catch (BOSException e) {
            logger.error((Object)(PermissionResUtil.getResource("res_88") + (Object)((Object)e)));
        }
    }

    private IDSecondAuthorizeCollection[] getModifiedPermItems() {
        IDSecondAuthorizeCollection[] results = new IDSecondAuthorizeCollection[]{new IDSecondAuthorizeCollection(), new IDSecondAuthorizeCollection(), new IDSecondAuthorizeCollection()};
        AuthorizeTypeEnum authWay = (AuthorizeTypeEnum)((Object)this.getSelectedRow().getCell(AUTHWAY_CELLNAME).getValue());
        for (PermItemInfo permInfo : this.permItemList) {
            IDSecondAuthorizeInfo authInfo;
            block10: {
                authInfo = new IDSecondAuthorizeInfo();
                String permInfostr = permInfo.getName().toLowerCase();
                if ((permInfostr.endsWith("addnew") || permInfostr.endsWith("view")) && 20 <= authWay.getValue() && authWay.getValue() <= 21) {
                    this.getSelectedRow().getCell("select").setValue((Object)Boolean.FALSE);
                    this.tblAuthWay.getRow(this.DEFAULT_INDEX).getCell("select").setValue((Object)Boolean.TRUE);
                    this.authTypes.put(permInfo.getId().toString(), AuthorizeTypeEnum.noAuthor);
                    authInfo.setAuthorizeType(AuthorizeTypeEnum.noAuthor);
                    MsgBox.showInfo((Component)((Object)this), (String)(permInfo.getAlias() + PermissionResUtil.getResource("res_137")));
                } else if (20 <= authWay.getValue() && authWay.getValue() <= 21) {
                    IFrameHelperFacade iFrameHelperFacade = null;
                    Map signaturConfigMap = null;
                    String bosType = permInfo.get("objecttype") == null ? "" : permInfo.get("objecttype").toString();
                    try {
                        iFrameHelperFacade = FrameHelperFacadeFactory.getRemoteInstance();
                        if (signaturConfigMap == null) {
                            if (iFrameHelperFacade == null) {
                                iFrameHelperFacade = FrameHelperFacadeFactory.getRemoteInstance();
                            }
                            signaturConfigMap = iFrameHelperFacade.getSignatrueConfig();
                        }
                        if (signaturConfigMap != null && !signaturConfigMap.containsKey(bosType)) {
                            this.getSelectedRow().getCell("select").setValue((Object)Boolean.FALSE);
                            this.tblAuthWay.getRow(this.DEFAULT_INDEX).getCell("select").setValue((Object)Boolean.TRUE);
                            this.authTypes.put(permInfo.getId().toString(), AuthorizeTypeEnum.noAuthor);
                            authInfo.setAuthorizeType(AuthorizeTypeEnum.noAuthor);
                            MsgBox.showInfo((Component)((Object)this), (String)(permInfo.getAlias() + PermissionResUtil.getResource("res_138")));
                            break block10;
                        }
                        this.authTypes.put(permInfo.getId().toString(), authWay);
                        authInfo.setAuthorizeType(authWay);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.authTypes.put(permInfo.getId().toString(), authWay);
                    authInfo.setAuthorizeType(authWay);
                }
            }
            authInfo.setPermItem(permInfo);
            authInfo.put("menuNamePath", this.currentNodeNamePath);
            results[2].add(authInfo);
        }
        return results;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private IRow getSelectedRow() {
        int count = this.tblAuthWay.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (!Boolean.TRUE.equals(this.tblAuthWay.getRow(i).getCell("select").getValue())) continue;
            return this.tblAuthWay.getRow(i);
        }
        return this.tblAuthWay.getRow(this.DEFAULT_INDEX);
    }

    @Override
    protected void tblAuthWay_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getRowIndex() >= 0) {
            this.getSelectedRow().getCell("select").setValue((Object)Boolean.FALSE);
            this.tblAuthWay.getRow(e.getRowIndex()).getCell("select").setValue((Object)Boolean.TRUE);
        }
    }
}

