/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.HrxuntUserMappingFactory;
import com.kingdee.eas.base.permission.client.AbstractMappingDataImportUI;
import com.kingdee.eas.base.permission.client.util.HssStyleUtils;
import com.kingdee.eas.base.permission.util.MappingDataImportBean;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellType;

public class MappingDataImportUI
extends AbstractMappingDataImportUI {
    private static final Logger logger = CoreUIObject.getLogger(MappingDataImportUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";
    String path = "";
    private HSSFWorkbook wb = new HSSFWorkbook();
    String RES = "";
    private int headRowNum = 1;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.chkUpdate.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName("MappingDataImport.xls");
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        String expFilePath = fselector.getData().toString();
        try (FileOutputStream out = null;){
            try {
                out = new FileOutputStream(expFilePath);
            }
            catch (FileNotFoundException ex) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"file_not_found"));
                SysUtil.abort();
            }
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFCellStyle nameCellStyle = HssStyleUtils.createNameCellStyle(wb);
            HSSFCellStyle codeCellStyle = HssStyleUtils.createCodeCellStyle(wb);
            HSSFCellStyle titleStyle = HssStyleUtils.createTitleCellStyle(wb);
            HSSFCellStyle cellValueStyle = HssStyleUtils.createValueCellStyle(wb);
            HSSFSheet sheet = wb.createSheet();
            HSSFRow headRow = sheet.createRow(0);
            this.createHeadCell(headRow, codeCellStyle, 0, "openId");
            this.createHeadCell(headRow, codeCellStyle, 1, "cell");
            wb.setSheetName(0, "MappingData");
            wb.write((OutputStream)out);
            out.flush();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"file_export_sucess"));
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"select_file"));
            return;
        }
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (".xls".equals(str)) {
            this.initSheet();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"file_style_error"));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int sheetNum;
        HSSFSheet sheet;
        int rowNum;
        if (this.wb == null) {
            return;
        }
        if (!this.checkFile()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"file_title_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        if ((rowNum = (sheet = this.wb.getSheetAt(sheetNum = this.comboLabel.getSelectedIndex())).getPhysicalNumberOfRows()) <= this.headRowNum) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"file_null"));
            return;
        }
        ArrayList<MappingDataImportBean> listMDI = new ArrayList<MappingDataImportBean>();
        HSSFRow row = null;
        String openIdValue = "";
        String cellValue = "";
        for (int i = 1; i < rowNum; ++i) {
            row = sheet.getRow(i);
            if (row == null || row.getPhysicalNumberOfCells() <= 0) continue;
            openIdValue = ExcelUtil.getCellValue((HSSFCell)row.getCell(0));
            if (StringUtils.isEmpty((String)openIdValue)) {
                MsgBox.showInfo((String)(i + 2 + EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"line_openid")));
                SysUtil.abort();
            }
            openIdValue = openIdValue.trim();
            cellValue = ExcelUtil.getCellValue((HSSFCell)row.getCell(1));
            if (StringUtils.isEmpty((String)cellValue)) {
                MsgBox.showInfo((String)(i + 2 + EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"line_cell_null")));
                SysUtil.abort();
            }
            cellValue = cellValue.trim();
            MappingDataImportBean mdi = new MappingDataImportBean(openIdValue, cellValue);
            listMDI.add(mdi);
        }
        String msg = HrxuntUserMappingFactory.getRemoteInstance().saveOrUpdateData(listMDI);
        this.getUIWindow().close();
        String[] info = msg.split("@");
        StringBuffer infoString = new StringBuffer();
        StringBuffer errorString = new StringBuffer();
        infoString.append("1. ");
        infoString.append(EASResource.getString((String)RESOURCE, (String)"UPDATE_LINE") + "\uff1a");
        infoString.append(info[0]);
        infoString.append("\r\n");
        infoString.append("\r\n");
        infoString.append("2. ");
        infoString.append(EASResource.getString((String)RESOURCE, (String)"ADDNEW_LINE") + "\uff1a");
        infoString.append(info[1]);
        infoString.append("\r\n");
        infoString.append("\r\n");
        infoString.append("3.");
        infoString.append(EASResource.getString((String)RESOURCE, (String)"FAIL_LINE") + "\uff1a");
        infoString.append(info[2]);
        errorString.append(info[3]);
        MsgBox.showDetailAndOK((Component)((Object)this), (String)infoString.toString(), (String)errorString.toString(), (int)1);
    }

    private boolean checkFile() {
        int columns;
        int sheetNum = this.comboLabel.getSelectedIndex();
        if (sheetNum < 0) {
            return false;
        }
        if (this.wb == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        HSSFRow headNumRow = null;
        if (this.wb != null) {
            HSSFSheet sheet = this.wb.getSheetAt(sheetNum);
            int rowNum = sheet.getPhysicalNumberOfRows();
            if (rowNum < 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"file_null"));
                SysUtil.abort();
            }
            headNumRow = sheet.getRow(0);
        }
        if (headNumRow == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.permission.MappingDataImportUIResource", (String)"file_title_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        if ((columns = headNumRow.getPhysicalNumberOfCells()) != 2) {
            return false;
        }
        HSSFCell fCell = headNumRow.getCell(0);
        String value = ExcelUtil.getCellValue((HSSFCell)fCell);
        if (value == null || !value.trim().equals("openId")) {
            return false;
        }
        fCell = headNumRow.getCell(1);
        value = ExcelUtil.getCellValue((HSSFCell)fCell);
        return value != null && value.trim().equals("cell");
    }

    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpdate_actionPerformed(e);
    }

    @Override
    public void actionRefreshSheet_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefreshSheet_actionPerformed(e);
    }

    private void createHeadCell(HSSFRow headRow, HSSFCellStyle cellStyle, int index, String cellValue) {
        HSSFCell cell6 = headRow.createCell((int)((short)index));
        cell6.setCellType(CellType.STRING);
        cell6.setCellValue(cellValue);
        cell6.setCellStyle(cellStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        this.path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(this.path);
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.path);
            POIFSFileSystem pfs = new POIFSFileSystem((InputStream)fileInputStream);
            this.wb = new HSSFWorkbook(pfs);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.handUIException(e);
                }
            }
        }
    }
}

