/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractNewUserOrgViewUI;
import com.kingdee.eas.base.permission.util.PermissionOrgTypeUtils;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class NewUserOrgViewUI
extends AbstractNewUserOrgViewUI {
    private static final Logger logger = CoreUIObject.getLogger(NewUserOrgViewUI.class);
    private static final Color DEFAULT_ORG_COLOR = Color.cyan;
    private KDTDataFillListener kdtfListener = null;

    @Override
    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        IObjectPK userPK = ToolUtils.getCurrentUserPK();
        uiContext.put("userPK", userPK);
        super.onLoad();
        this.btnSetDefaultOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
    }

    @Override
    protected void initTable() {
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.addListener4TblMain();
    }

    private void addListener4TblMain() {
        this.kdtfListener = new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    NewUserOrgViewUI.this.kdtTable_afterTableRequestData(e);
                }
                catch (EASBizException e1) {
                    NewUserOrgViewUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    NewUserOrgViewUI.this.handUIException(e1);
                }
            }
        };
        this.tblMain.addKDTDataFillListener(this.kdtfListener);
    }

    private void removeListener4TblMain() {
        this.tblMain.removeKDTDataFillListener(this.kdtfListener);
    }

    protected void kdtTable_afterTableRequestData(KDTDataRequestEvent e) throws EASBizException, BOSException {
        UserInfo userInfo = ToolUtils.getCurrentUser();
        IRow row = null;
        int rowCount = this.tblMain.getRowCount3();
        if (rowCount > 0) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                String orgId;
                row = this.tblMain.getRow2(i);
                if (row == null || !(orgId = row.getCell(this.getOrgIdColName()).getValue().toString()).equals(userInfo.getDefOrgUnit().getId().toString())) continue;
                row.getStyleAttributes().setBackground(DEFAULT_ORG_COLOR);
                break;
            }
        }
    }

    @Override
    protected void swithToType(OrgRangeType orgRangeType) throws Exception {
        if (orgRangeType.equals((Object)OrgRangeType.BIZ_ORG_TYPE)) {
            this.btnSetDefaultOrg.setVisible(true);
            this.addListener4TblMain();
        } else {
            this.btnSetDefaultOrg.setVisible(false);
            this.removeListener4TblMain();
        }
        super.swithToType(orgRangeType);
    }

    @Override
    public void actionSetDefaultOrg_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UserInfo userInfo = ToolUtils.getCurrentUser();
        String defOrgId = null;
        int[] selectedRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int i = 0;
        if (i < selectedRowIndexes.length) {
            int rowIndex = selectedRowIndexes[i];
            IRow row = this.tblMain.getRow(rowIndex);
            defOrgId = row.getCell(this.getOrgIdColName()).getValue().toString();
        }
        if (defOrgId != null) {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            ObjectUuidPK defOrgPK = new ObjectUuidPK(defOrgId);
            SelectorItemCollection loadItem = new SelectorItemCollection();
            loadItem.add("id");
            loadItem.add("orgTypeStr");
            FullOrgUnitInfo fullOrgInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)defOrgPK, loadItem);
            if (PermissionOrgTypeUtils.isCanBeDefOrg(fullOrgInfo)) {
                userInfo.setDefOrgUnit(fullOrgInfo);
                IUser iUser = UserFactory.getRemoteInstance();
                SelectorItemCollection saveItem = new SelectorItemCollection();
                saveItem.add("defOrgUnit");
                iUser.updatePartial((CoreBaseInfo)userInfo, saveItem);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
                this.refreshList();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.getResource(), (String)"UNION_CANNOT_BE_DEFAULT"));
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }
}

