/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeSolutionCollection;
import com.kingdee.eas.base.permission.OrgRangeSolutionEntryCollection;
import com.kingdee.eas.base.permission.OrgRangeSolutionInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.client.SysContext;
import java.util.ArrayList;
import java.util.List;

public class OrgRangeSolutionUtil {
    protected static UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();

    public static OrgRangeSolutionCollection getOrgRangeSolutionColl(KDBizPromptBox orgRangeSlnF7) {
        OrgRangeSolutionCollection coll = new OrgRangeSolutionCollection();
        orgRangeSlnF7.setDataBySelector();
        Object data = orgRangeSlnF7.getData();
        if (data instanceof OrgRangeSolutionInfo) {
            coll.add((OrgRangeSolutionInfo)data);
        } else if (data instanceof Object[]) {
            Object[] infoArr = (Object[])data;
            for (int i = 0; i < infoArr.length; ++i) {
                if (infoArr[i] == null || !(infoArr[i] instanceof OrgRangeSolutionInfo)) continue;
                coll.add((OrgRangeSolutionInfo)infoArr[i]);
            }
        }
        return coll;
    }

    public static void updateOrgTableList(OrgRangeSolutionCollection coll, KDTable table, EntityViewInfo baseUnitInfoQuery, List targetUsers, OrgRangeType orgRangeType) throws BOSException, ParserException {
        List existIds = OrgRangeSolutionUtil.getExistIds(table);
        List idList = OrgRangeSolutionUtil.getOrgIDListFromSolutionColl(coll);
        idList.addAll(existIds);
        if (baseUnitInfoQuery == null) {
            baseUnitInfoQuery = new EntityViewInfo();
        }
        FilterInfo filterInfo = OrgRangeSolutionUtil.getSelectOrgFilteInfo(ToolUtils.aryToStr(idList, false));
        if (targetUsers != null && targetUsers.size() > 0) {
            filterInfo.mergeFilter(OrgRangeSolutionUtil.buildOrgRangeFileter(targetUsers, orgRangeType), "AND");
        }
        baseUnitInfoQuery.setFilter(filterInfo);
        table.refresh();
    }

    public static void updateOrgTableList(OrgRangeSolutionCollection coll, KDTable table, EntityViewInfo baseUnitInfoQuery) {
        List existIds = OrgRangeSolutionUtil.getExistIds(table);
        List idList = OrgRangeSolutionUtil.getOrgIDListFromSolutionColl(coll);
        idList.addAll(existIds);
        FilterInfo filterInfo = OrgRangeSolutionUtil.getSelectOrgFilteInfo(ToolUtils.aryToStr(idList, false));
        if (baseUnitInfoQuery == null) {
            baseUnitInfoQuery = new EntityViewInfo();
        }
        baseUnitInfoQuery.setFilter(filterInfo);
        table.refresh();
    }

    private static List getExistIds(KDTable table) {
        ArrayList<String> ids = new ArrayList<String>();
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = table.getRow(i);
            ids.add(row.getCell("orgId").getValue().toString());
        }
        return ids;
    }

    private static FilterInfo getSelectOrgFilteInfo(String idStr) {
        FilterInfo myFilterInfo = new FilterInfo();
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INCLUDE));
        return myFilterInfo;
    }

    public static List getOrgIDListFromSolutionColl(OrgRangeSolutionCollection coll) {
        ArrayList<String> idList = new ArrayList<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            OrgRangeSolutionInfo tmpInfo = coll.get(i);
            if (tmpInfo == null) continue;
            OrgRangeSolutionEntryCollection entryColl = tmpInfo.getEntries();
            int entrysize = entryColl.size();
            for (int entryi = 0; entryi < entrysize; ++entryi) {
                if (entryColl == null || entryColl.get(entryi) == null || entryColl.get(entryi).getOrg() == null || entryColl.get(entryi).getOrg().getId() == null) continue;
                idList.add(entryColl.get(entryi).getOrg().getId().toString());
            }
        }
        return idList;
    }

    public static KDBizPromptBox getOrgRangeF7(OrgRangeType type) {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setQueryInfo("com.kingdee.eas.base.permission.app.F7OrgRangeSlnQuery");
        f7.setCommitFormat("$number$");
        EntityViewInfo evInfo = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("orgRangeType", (Object)new Integer(type.getValue())));
        if (!Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()))) {
            fInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        }
        evInfo.setFilter(fInfo);
        f7.setEntityViewInfo(evInfo);
        f7.setEnabledMultiSelection(true);
        f7.setEnableToMaintainBizdata(true);
        return f7;
    }

    public static FilterInfo buildOrgRangeFileter(List targetUsers, OrgRangeType orgRangeType) throws ParserException {
        if (targetUsers == null || targetUsers.size() == 0) {
            return null;
        }
        StringBuffer adminUserPKArySql = new StringBuffer();
        adminUserPKArySql.append("SELECT FOrgID").append(" FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(currentUser.getId()).append("' AND FType = ");
        if (Administrator.isAdminType(currentUser.getType())) {
            adminUserPKArySql.append(10);
        } else {
            adminUserPKArySql.append(30);
        }
        StringBuilder extraFilters = new StringBuilder();
        extraFilters.append("id in (select fid from t_org_baseunit where");
        extraFilters.append("  fid in( select forgid from t_pm_orgrange where fuserid in(").append(ToolUtils.aryToStr(targetUsers)).append(") and ftype = ").append(orgRangeType.getValue()).append(")");
        extraFilters.append("and (fcontrolunitid in (").append(adminUserPKArySql).append(") or (fisunion = 1 and fmaintaincuid in (").append(adminUserPKArySql).append("))))");
        if (OrgRangeType.BIZ_ORG_TYPE == orgRangeType) {
            extraFilters.append(" AND OrgtypeStr NOT IN").append("(").append("';;Admin;',';Admin;',';;ControlUnit;',';ControlUnit;',';;Admin;;ControlUnit;',';;ControlUnit;;Admin;',';Admin;;ControlUnit;',';ControlUnit;;Admin;',';'").append(")");
        }
        FilterInfo filterSql = new FilterInfo(extraFilters.toString());
        return filterSql;
    }
}

