/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractPasswordMaintainUI;
import com.kingdee.eas.base.permission.client.util.VerifyPassword;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import javax.swing.JComponent;

public class PasswordMaintainUI
extends AbstractPasswordMaintainUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private UserInfo userInfo;
    KDInfoTip pdTip = null;

    public PasswordMaintainUI() throws Exception {
        this.initUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.userInfo = this.getBizInterface().getUserInfo(this.getTargetUserPK());
        this.loadFields();
    }

    private void initUI() {
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtNumber.setText(this.userInfo.getNumber());
    }

    private IUser getBizInterface() throws Exception {
        return UserFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        String password = new String(this.pwdPassword.getPassword());
        try {
            password = PermissionCommonUtil.encrypt(this.userInfo.getNumber(), password);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        this.userInfo.setPassword(password);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        try {
            this.verifyInput();
            this.storeFields();
            this.userInfo.remove("orgRange");
            String userNumber = SysContext.getSysContext().getCurrentUserInfo().getNumber();
            IObjectPK logPK = LogUtil.beginLog(null, (String)EASResource.getString((String)RESOURCE, (String)"USER_UPDATE_PWD"), (BOSObjectType)this.userInfo.getBOSType(), null, (String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"logUpdatePassword"), userNumber, this.userInfo.getNumber()), (String)"bs_permission_user_update_password");
            this.getBizInterface().update((IObjectPK)new ObjectUuidPK(this.userInfo.getId()), (IObjectValue)this.userInfo, true);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"changePasswordSucceed"));
            this.getUIWindow().close();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    protected void verifyInput() throws EASBizException {
        VerifyPassword.verifyPassword(this.pwdPassword, this.pwdConfirmPassword);
    }

    private IObjectPK getTargetUserPK() {
        return new ObjectUuidPK(BOSUuid.read((String)((String)this.getUIContext().get("targetID"))));
    }

    @Override
    protected void pwdPassword_focusLost(FocusEvent e) throws Exception {
        if (this.pdTip != null) {
            this.pdTip.setShowing(false);
        }
    }

    @Override
    protected void pwdPassword_focusGained(FocusEvent e) throws Exception {
        if (this.pdTip != null) {
            this.pdTip.setShowing(true);
            return;
        }
        SecurityInfo security = SecurityFactory.getRemoteInstance().getSecurityInfo("where id='" + this.userInfo.getSecurity().getId().toString() + "'");
        this.userInfo.setSecurity(security);
        SecurityValidator securityValidator = new SecurityValidator(this.userInfo);
        String securityPolicy = securityValidator.getSecurityPolicy();
        if (!StringUtils.isEmpty((String)securityPolicy)) {
            this.pdTip = new KDInfoTip((JComponent)this.pwdPassword, securityPolicy);
            this.pdTip.setMaxRenderWidth(250.0f);
            this.pdTip.setShowing(true);
        }
    }
}

