/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.util.LowTimeHelper;
import com.kingdee.eas.base.uiframe.client.ILoginRPCFilter;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.basedata.org.MultiOrgSwitchUtils;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.ClientSysEnvLoader;
import com.kingdee.eas.common.client.ILoginListener;
import com.kingdee.eas.common.client.LoginEvent;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PermissionLoginListener
implements ILoginListener,
ILoginRPCFilter {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static Logger logger = Logger.getLogger((String)PermissionLoginListener.class.getName());

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = UIActionPostman.getInstance(null);
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.base.permission.app.PermissionLoginHandle");
            request.put("username", (Object)SysContext.getSysContext().getUserName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void logined(LoginEvent e) throws BOSException, EASBizException {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserInfo userInfo = this.getUserInfo();
        this.setContext(userInfo);
        this.checkPasswordEffectiveDay(userInfo);
        this.registerListener();
        endTime = lowTimer.msValue();
        logger.debug((Object)("logined  " + (endTime - beginTime)));
    }

    private UserInfo getUserInfo() throws BOSException, EASBizException {
        SysContext sysContext = SysContext.getSysContext();
        UserInfo userInfo = sysContext.getCurrentUserInfo();
        if (userInfo == null) {
            IUser iUser = UserFactory.getRemoteInstance();
            userInfo = iUser.getUser(SysContext.getSysContext().getUserName());
        }
        return userInfo;
    }

    private void registerListener() {
        logger.debug((Object)"..... has register PropertyChangeListener");
        MainFrameCallBack.addPropertyChangeListener((String)"HRSwitchOrg", (PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PermissionHelper.cleanCache();
            }
        });
    }

    private void setContext(UserInfo userInfo) throws EASBizException, BOSException {
        assert (userInfo != null);
        SysContext sysContext = SysContext.getSysContext();
        sysContext.setCurrentUserInfo(userInfo);
        sysContext.setCurrentOrgUnit((OrgUnitInfo)userInfo.getDefOrgUnit());
        if (userInfo.getDefOrgUnit() != null && userInfo.getDefOrgUnit().getId() != null) {
            LowTimer lowTimer = new LowTimer();
            float beginTime = lowTimer.msValue();
            float endTime = lowTimer.msValue();
            try {
                MultiOrgSwitchUtils.switchOrg((String)userInfo.getDefOrgUnit().getId().toString());
            }
            catch (Exception e) {
                logger.error((Object)"111", (Throwable)e);
                if (ExceptionHandler.handleOrgMissingRecord2(null, (Throwable)e)) {
                    throw new AbortException();
                }
                ExceptionHandler.handle((Throwable)e);
            }
            endTime = lowTimer.msValue();
            logger.debug((Object)("switchOrg  " + (endTime - beginTime)));
        }
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
            String clientIP = localhost.getHostAddress();
            String clientName = localhost.getHostName();
            sysContext.setClientIP(clientIP);
            sysContext.setClientName(clientName);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ClientIP", clientIP);
            map.put("ClientName", clientName);
            IContextManager contextManager = ContextManagerFactory.getRemoteInstance();
            contextManager.setContext(map);
        }
        catch (UnknownHostException e) {
            throw new PermissionException(PermissionException.CAN_NOT_FOUNTD_CLIENT_INFO, e);
        }
    }

    private void setContext(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        assert (userInfo != null);
        SysContext sysContext = SysContext.getSysContext();
        sysContext.setCurrentUserInfo(userInfo);
        sysContext.setCurrentOrgUnit((OrgUnitInfo)userInfo.getDefOrgUnit());
        if (userInfo.getDefOrgUnit() != null && userInfo.getDefOrgUnit().getId() != null) {
            LowTimer lowTimer = new LowTimer();
            float beginTime = lowTimer.msValue();
            float endTime = lowTimer.msValue();
            try {
                MultiOrgSwitchUtils.switchOrgForLogin((Context)ctx, (String)userInfo.getDefOrgUnit().getId().toString());
            }
            catch (Exception e) {
                logger.error((Object)"111", (Throwable)e);
                if (ExceptionHandler.handleOrgMissingRecord2(null, (Throwable)e)) {
                    throw new AbortException();
                }
                ExceptionHandler.handle((Throwable)e);
            }
            endTime = lowTimer.msValue();
            logger.debug((Object)("switchOrg  " + (endTime - beginTime)));
        }
    }

    private void checkPasswordEffectiveDay(UserInfo user) {
        if (PermissionCommonUtil.passWillBeExpired(user)) {
            MsgBox.showWarning((String)PermissionCommonUtil.getExpireWarnMsg(user));
        }
    }

    public void beforeAuthenticating(LoginContext loginCtx) throws BOSLoginException {
        ClientSysEnvLoader.initSysEnv();
    }

    public void afterAuthenticated(Context ctx) throws BOSLoginException {
        try {
            UserInfo userInfo = this.getUserInfo();
            this.setContext(ctx, userInfo);
            this.checkPasswordEffectiveDay(userInfo);
            this.registerListener();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    class DeleteDuplicateOrgRangeThread
    implements Runnable {
        DeleteDuplicateOrgRangeThread() {
        }

        @Override
        public void run() {
            LowTimeHelper helper = new LowTimeHelper();
            try {
                IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
                iOrgRange.handleErrorOrgRangeData();
            }
            catch (Exception e) {
                logger.error((Object)("DeleteDuplicateOrgRangeThread:" + e));
                ExceptionHandler.handle((Throwable)e);
            }
            helper.printTime2Last("delete duplicate<<<<<<<<<<<<<<:");
        }
    }
}

