/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.PersonalInfoClearEntryCollection;
import com.kingdee.eas.base.permission.PersonalInfoClearEntryInfo;
import com.kingdee.eas.base.permission.PersonalInfoClearInfo;
import com.kingdee.eas.base.permission.client.PersonalInfoClearEditUI;
import com.kingdee.eas.tools.datatask.client.AbstractPropertySetUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PropertySetUI
extends AbstractPropertySetUI {
    private static final Logger logger = CoreUIObject.getLogger(PropertySetUI.class);
    private PersonalInfoClearInfo info = null;
    private BOSObjectType rootBosType = null;
    private String entityDesc = null;
    private DefaultKingdeeTreeNode rootNode = null;
    public static final String classSeparator = "$";
    private static final String descSeparator = "_";
    PersonalInfoClearEditUI editUI = null;

    public PropertySetUI() throws Exception {
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
    }

    private void initTree() {
        this.treeProp.setModel(null);
        this.rootNode = new DefaultKingdeeTreeNode((Object)this.entityDesc);
        this.treeProp.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.rootNode));
        this.buildTreeNode(this.rootNode, this.rootBosType);
        this.treeProp.setSyncChecked(true);
        this.treeProp.setShowCheckBox(true);
        ((DefaultTreeModel)this.treeProp.getModel()).setAsksAllowsChildren(true);
        this.treeProp.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (node == null) {
                    return;
                }
                EntityObjectInfo tmpInfo = null;
                if (node == PropertySetUI.this.rootNode) {
                    tmpInfo = PropertySetUI.this.getEntityObjectInfo(PropertySetUI.this.rootBosType);
                } else {
                    MyPropertyInfo info = (MyPropertyInfo)node.getUserObject();
                    LinkPropertyInfo tmpLinkInfo = (LinkPropertyInfo)info.getPropertyInfo();
                    tmpInfo = tmpLinkInfo.getRelationship().getSupplierObject();
                    if (!tmpInfo.getName().equals(info.getEntity().getName())) {
                        tmpInfo = tmpLinkInfo.getRelationship().getClientObject();
                    }
                }
                PropertySetUI.this.buildTreeNode(node, tmpInfo);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.info = (PersonalInfoClearInfo)this.getUIContext().get("editData");
        String strBosType = (String)this.getUIContext().get("bostype");
        String bosAlias = (String)this.getUIContext().get("bosAlias");
        this.editUI = (PersonalInfoClearEditUI)((Object)this.getUIContext().get("Owner"));
        this.rootBosType = BOSObjectType.create((String)strBosType);
        this.entityDesc = bosAlias;
        this.initTree();
    }

    private void buildTreeNode(DefaultKingdeeTreeNode parentNode, EntityObjectInfo eoInfo) {
        PropertyCollection coll = eoInfo.getInheritedNoDuplicatedProperties();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo tmp = coll.get(i);
            if (this.isExistSameProp(parentNode, tmp)) continue;
            MyPropertyInfo myInfo = new MyPropertyInfo(tmp);
            DefaultKingdeeTreeNode tmpNode = new DefaultKingdeeTreeNode((Object)myInfo);
            if (tmp.getClass().getName().equals(LinkPropertyInfo.class.getName())) {
                tmpNode.setCheckBoxVisible(false);
                continue;
            }
            tmpNode.setCheckBoxVisible(true);
            tmpNode.setAllowsChildren(false);
            this.treeProp.addNodeInto((MutableTreeNode)tmpNode, (MutableTreeNode)parentNode);
            this.treeProp.scrollPathToVisible(new TreePath(tmpNode.getPath()));
        }
    }

    private boolean isExistSameProp(DefaultKingdeeTreeNode parentNode, PropertyInfo propInfo) {
        int count = parentNode.getChildCount();
        for (int i = 0; i > count; ++i) {
            MyPropertyInfo tmInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            Object o = node.getUserObject();
            if (!(o instanceof MyPropertyInfo) || !(tmInfo = (MyPropertyInfo)o).getPropertyInfo().equals((Object)propInfo)) continue;
            return true;
        }
        return false;
    }

    private void buildTreeNode(DefaultKingdeeTreeNode parentNode, BOSObjectType type) {
        EntityObjectInfo eoInfo = this.getEntityObjectInfo(type);
        Object object = parentNode.getUserObject();
        if (object != null && !(object instanceof MyPropertyInfo)) {
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.setName(object.toString());
            MyPropertyInfo myInfo = new MyPropertyInfo(propertyInfo);
            myInfo.setEntity(eoInfo);
            parentNode.setUserObject((Object)myInfo);
        }
        this.buildTreeNode(parentNode, eoInfo);
    }

    private EntityObjectInfo getEntityObjectInfo(BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        return loader.getEntity(type);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ArrayList result = new ArrayList();
        this.getCheckedLeafNode((DefaultKingdeeTreeNode)this.treeProp.getModel().getRoot(), result);
        PersonalInfoClearEntryCollection entries = this.info.getEntries();
        HashSet<String> existedNumber = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            PersonalInfoClearEntryInfo entry = entries.get(i);
            existedNumber.add(entry.getNumber());
        }
        if (result != null && result.size() > 0) {
            int size = result.size();
            DefaultKingdeeTreeNode tmpNode = null;
            PersonalInfoClearEntryInfo tmpEntryInfo = null;
            for (int i = 0; i < size; ++i) {
                tmpNode = (DefaultKingdeeTreeNode)result.get(i);
                TreeNode[] nodes = tmpNode.getPath();
                int length = nodes.length;
                tmpEntryInfo = new PersonalInfoClearEntryInfo();
                for (int j = 1; j < length; ++j) {
                    DefaultKingdeeTreeNode tmpNode1 = (DefaultKingdeeTreeNode)nodes[j];
                    if (!(tmpNode.getUserObject() instanceof MyPropertyInfo)) continue;
                    MyPropertyInfo tmp1 = (MyPropertyInfo)tmpNode1.getUserObject();
                    PropertyInfo propInfo = tmp1.getPropertyInfo();
                    if (propInfo instanceof OwnPropertyInfo) {
                        OwnPropertyInfo tmpInfo = (OwnPropertyInfo)propInfo;
                        this.fillEntryInfo(tmpEntryInfo, (OwnPropertyInfo)propInfo, null);
                        tmpEntryInfo.setNumber(this.getField(tmpEntryInfo.getNumber()));
                        if (existedNumber.contains(tmpEntryInfo.getNumber())) continue;
                        this.info.getEntries().add(tmpEntryInfo);
                        continue;
                    }
                    if (!(propInfo instanceof LinkPropertyInfo)) continue;
                    this.fillEntryInfo(tmpEntryInfo, (LinkPropertyInfo)propInfo);
                }
            }
        }
        this.getUIWindow().close();
        this.addRows(this.info.getEntries());
    }

    private void addRows(PersonalInfoClearEntryCollection entryCol) {
        this.loadEntry(entryCol);
    }

    protected void loadEntry(PersonalInfoClearEntryCollection entryCol) {
        KDTable entries = this.editUI.entries;
        this.editUI.entries.removeRows();
        if (entryCol == null || entryCol.isEmpty()) {
            return;
        }
        entries.addRows(entryCol.size());
        int selectIndex = 0;
        for (int i = 0; i < entryCol.size(); ++i) {
            this.loadEntry(entries.getRow(i), entryCol.get(i));
        }
        if (entries.getRowCount() > 0 && entries.getSelectManager().getActiveRowIndex() < 0) {
            entries.getSelectManager().select(selectIndex, 0);
        }
    }

    private void loadEntry(IRow row, PersonalInfoClearEntryInfo entryInfo) {
        row.setUserObject((Object)entryInfo);
        row.getCell("name").setValue((Object)entryInfo.getName());
        row.getCell("number").setValue((Object)entryInfo.getNumber());
    }

    private void fillEntryInfo(PersonalInfoClearEntryInfo entryInfo, OwnPropertyInfo ownInfo, Locale locale) {
        if (entryInfo.getNumber() != null) {
            entryInfo.setNumber(entryInfo.getNumber() + descSeparator + ownInfo.getName());
        } else {
            entryInfo.setNumber(ownInfo.getName());
        }
        if (entryInfo.getName() != null) {
            entryInfo.setName(entryInfo.getName() + descSeparator + ownInfo.getAlias());
        } else {
            entryInfo.setName(ownInfo.getAlias());
        }
        if (locale != null) {
            entryInfo.setNumber(entryInfo.getNumber() + descSeparator + locale.toString());
            entryInfo.setName(entryInfo.getName() + descSeparator + locale.toString());
        }
    }

    private void fillEntryInfo(PersonalInfoClearEntryInfo entryInfo, LinkPropertyInfo linkInfo) {
        if (entryInfo.getNumber() != null) {
            entryInfo.setNumber(entryInfo.getNumber() + classSeparator + linkInfo.getName());
        } else {
            entryInfo.setNumber(linkInfo.getName());
        }
        if (entryInfo.getName() != null) {
            entryInfo.setName(entryInfo.getName() + classSeparator + linkInfo.getAlias());
        } else {
            entryInfo.setName(linkInfo.getAlias());
        }
        EntityObjectInfo eoInfo = null;
        eoInfo = this.rootBosType.equals((Object)linkInfo.getRelationship().getClientObject().getType()) ? linkInfo.getRelationship().getSupplierObject() : (!this.rootBosType.equals((Object)linkInfo.getRelationship().getSupplierObject().getType()) ? linkInfo.getRelationship().getSupplierObject() : linkInfo.getRelationship().getClientObject());
    }

    private String getSpecifyNodeDataType(DefaultKingdeeTreeNode node) {
        String dataType = "";
        MyPropertyInfo tmp = (MyPropertyInfo)node.getUserObject();
        PropertyInfo propInfo = tmp.getPropertyInfo();
        if (propInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkInfo = (LinkPropertyInfo)propInfo;
            EntityObjectInfo eoInfo = linkInfo.getRelationship().getSupplierObject();
            dataType = eoInfo.getObjectValueClass();
            return dataType;
        }
        if (propInfo instanceof OwnPropertyInfo) {
            return ((OwnPropertyInfo)propInfo).getDataType().toString();
        }
        return null;
    }

    private void getCheckedLeafNode(DefaultKingdeeTreeNode parentNode, ArrayList result) {
        if (parentNode == null || parentNode.getChildCount() == 0) {
            return;
        }
        int childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (tmpNode.isLeaf() && !tmpNode.getAllowsChildren()) {
                if (!tmpNode.isChecked()) continue;
                result.add(tmpNode);
                continue;
            }
            this.getCheckedLeafNode(tmpNode, result);
        }
    }

    private String getField(String prop) {
        return prop;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private class MyPropertyInfo {
        private PropertyInfo info = null;
        private EntityObjectInfo entity = null;

        public MyPropertyInfo(PropertyInfo info) {
            this.info = info;
        }

        public void setEntity(EntityObjectInfo entity) {
            this.entity = entity;
        }

        public EntityObjectInfo getEntity() {
            return this.entity;
        }

        public String toString() {
            if (this.info.getAlias() != null) {
                return this.info.getAlias().toString();
            }
            return this.info.getName().toString();
        }

        public PropertyInfo getPropertyInfo() {
            return this.info;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof MyPropertyInfo)) {
                return false;
            }
            MyPropertyInfo myInfo = (MyPropertyInfo)o;
            PropertyInfo tmpPropInfo = myInfo.getPropertyInfo();
            if (this == myInfo) {
                return true;
            }
            return this.getPropertyInfo().equals((Object)tmpPropInfo);
        }
    }
}

