/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleDiscreteAccreditUI;
import com.kingdee.eas.base.permission.client.DiscreteAccreditManager;
import com.kingdee.eas.base.permission.client.IDiscreteAccreditProvider;
import com.kingdee.eas.base.permission.client.IDiscreteDataSelector;
import com.kingdee.eas.base.permission.client.PermItemCheckBoxGroup;
import com.kingdee.eas.base.permission.client.discreteImpl.DiscreteViewFactory;
import com.kingdee.eas.base.permission.client.discreteImpl.IDiscreteRoleViewPerm;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoleDiscreteAccreditUI
extends AbstractRoleDiscreteAccreditUI {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    public static final String BOS_OBJECT_TYPE = "bosObjectType";
    public static final String TARGET_ROLE_PK = "targetRolePK";
    private BOSObjectType bizObjectType = null;
    private QueryInfo bizQuery = null;
    private IObjectPK targetRolePK = null;
    private PermItemCheckBoxGroup checkBoxGroup = new PermItemCheckBoxGroup();
    private Set authorizedBizDatas = null;
    private Set accreditBizDatas = null;
    private Map depPermItems = null;
    private Map beenDepPermItems = null;
    private Map addDiscretePerms = new HashMap();
    private Map removeDiscretePerms = new HashMap();
    private Map updateDiscretePerms = new HashMap();
    private IDiscreteAccreditProvider discreteAccreditProvider = null;
    private static final String INDEX_COLUMN_NAME = "index_" + System.currentTimeMillis();
    private int virtualIndex = 0;
    boolean isFiristGetData = true;
    boolean isModify = false;
    private IDiscreteRoleViewPerm viewHelper = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadUIContext();
        this.initUI();
        this.setStatus();
        this.isModify = false;
    }

    private void setStatus() {
        boolean canModify = OprtState.EDIT.equals(this.getOprtState());
        this.actionSubmit.setEnabled(canModify);
        this.actionAddBizData.setVisible(canModify);
        this.actionRemoveBizData.setVisible(canModify);
        this.checkBoxGroup.setAllEnable(false);
    }

    protected void initWorkButton() {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isModify) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.checkBeforeSumbit();
                try {
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return true;
                }
                catch (Exception exc) {
                    this.handUIException(exc);
                    return false;
                }
            }
            return result == 1;
        }
        return super.checkBeforeWindowClosing();
    }

    private void loadUIContext() {
        if (this.getUIContext().get(BOS_OBJECT_TYPE) == null) {
            throw new IllegalArgumentException("discreteAccreditContext can not be NULL.");
        }
        this.bizObjectType = (BOSObjectType)this.getUIContext().get(BOS_OBJECT_TYPE);
        this.viewHelper = DiscreteViewFactory.createRoleViewPerm(this.bizObjectType.toString());
        this.discreteAccreditProvider = DiscreteAccreditManager.getInstace().getProvider(this.bizObjectType);
        this.bizQuery = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.discreteAccreditProvider.getQueryPK());
        this.targetRolePK = (IObjectPK)this.getUIContext().get(TARGET_ROLE_PK);
    }

    private void initUI() throws EASBizException, BOSException {
        this.initBizDataContainer();
        this.initPermItemPanel();
        this.initRoleF7();
    }

    private void initBizDataContainer() {
        JButton btnAddBizData = this.contBizData.add((Action)((Object)this.actionAddBizData));
        JButton btnRemoveBizData = this.contBizData.add((Action)((Object)this.actionRemoveBizData));
        btnAddBizData.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnRemoveBizData.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionAddBizData.setEnabled(false);
        this.actionRemoveBizData.setEnabled(false);
        this.initTable();
    }

    private void initPermItemPanel() throws EASBizException, BOSException {
        this.pnlPermItem.setLayout((LayoutManager)new FlowLayout(3));
        this.loadPermItems();
    }

    private void loadPermItems() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Set permItemNames = (Set)iPermission.getConfigurationInfo().getDiscretEntityPermItems().get(this.bizObjectType.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(permItemNames), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableDataPermission", (Object)new Integer(1)));
        entityViewInfo.setFilter(filterInfo);
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        PermItemCollection permItems = iPermItem.getPermItemCollection(entityViewInfo);
        HashSet setPermItemPK = new HashSet();
        this.viewHelper.loadPermItem(permItems, this.checkBoxGroup, this.pnlPermItem, setPermItemPK);
        this.checkBoxGroup.addAllChangeListener(new CheckBoxChangeListener());
        ObjectUuidPK[] permItemPKs = setPermItemPK.toArray(new ObjectUuidPK[setPermItemPK.size()]);
        this.depPermItems = iPermItem.getDepPermItems((IObjectPK[])permItemPKs);
        this.beenDepPermItems = iPermItem.getBeenDepPermItems((IObjectPK[])permItemPKs);
    }

    protected void checkBoxChanged(ChangeEvent e) {
        this.isModify = true;
        if (this.table.getSelectManager().size() == 0) {
            return;
        }
        this.processDepCheckBox(e);
        try {
            Set bizDataIDs = this.getSelectedBizDataIDs();
            for (BOSUuid bizDataID : bizDataIDs) {
                if (this.getAuthorizedBizDatas().contains(bizDataID)) {
                    if (this.checkBoxGroup.hasSelected()) {
                        this.updateDiscretePerms.put(bizDataID, this.getCurrentDDPs(bizDataID, false));
                        this.removeDiscretePerms.remove(bizDataID);
                        continue;
                    }
                    this.removeDiscretePerms.put(bizDataID, this.getCurrentDDPs(bizDataID, true));
                    this.updateDiscretePerms.remove(bizDataID);
                    continue;
                }
                if (this.checkBoxGroup.hasSelected()) {
                    this.addDiscretePerms.put(bizDataID, this.getCurrentDDPs(bizDataID, false));
                    continue;
                }
                this.addDiscretePerms.remove(bizDataID);
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void processDepCheckBox(ChangeEvent e) {
        block6: {
            PermItemInfo permItemInfo;
            block5: {
                KDCheckBox checkBox = (KDCheckBox)e.getSource();
                permItemInfo = (PermItemInfo)checkBox.getUserObject();
                if (!checkBox.isSelected()) break block5;
                if (!this.depPermItems.containsKey(permItemInfo.getId().toString())) break block6;
                PermItemCollection collection = (PermItemCollection)((Object)this.depPermItems.get(permItemInfo.getId().toString()));
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    Iterator iterator = this.checkBoxGroup.iterator();
                    while (iterator.hasNext()) {
                        KDCheckBox box = (KDCheckBox)iterator.next();
                        PermItemInfo info = (PermItemInfo)box.getUserObject();
                        if (!info.getId().equals((Object)collection.get(i).getId())) continue;
                        box.setSelected(true);
                    }
                }
                break block6;
            }
            if (this.beenDepPermItems.containsKey(permItemInfo.getId().toString())) {
                PermItemCollection collection = (PermItemCollection)((Object)this.beenDepPermItems.get(permItemInfo.getId().toString()));
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    Iterator iterator = this.checkBoxGroup.iterator();
                    while (iterator.hasNext()) {
                        KDCheckBox box = (KDCheckBox)iterator.next();
                        PermItemInfo info = (PermItemInfo)box.getUserObject();
                        if (!info.getId().equals((Object)collection.get(i).getId()) || !box.isSelected()) continue;
                        box.setSelected(false);
                    }
                }
            }
        }
    }

    private void initRoleF7() throws BOSException, EASBizException {
        if (this.targetRolePK != null) {
            IRole iRole = RoleFactory.getRemoteInstance();
            RoleInfo roleInfo = iRole.getRoleInfo(this.targetRolePK);
            this.pmtRole.setData((Object)roleInfo);
            this.pmtRole.setEnabled(false);
        }
    }

    private void initTable() {
        this.contBizData.getContentPane().add((Component)this.table, "Center");
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(10);
        this.table.getDataRequestManager().setDataRequestMode(1);
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                RoleDiscreteAccreditUI.this.requestRowSet(e);
            }
        });
        this.table.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                RoleDiscreteAccreditUI.this.updateIndexColumn();
            }
        });
        this.fillTableHeader();
        this.table.getIndexColumn().getStyleAttributes().setHided(true);
    }

    private void fillTableHeader() {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        String QUERY = "query";
        this.table.setRefresh(false);
        SelectorInfo selector = this.bizQuery.getSelector();
        int size = selector.getFields().size();
        QueryFieldInfo field = null;
        String[] bindContents = new String[size];
        Map exProperties = this.bizQuery.getExtendedProperties();
        for (int i = 0; i < size; ++i) {
            String colFormat;
            IColumn col = this.table.addColumn(i);
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.getStyleAttributes().setHided(!visible);
            Object objectColWidth = exProperties.get("ColWidthInKDTable");
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (!(objColFormat instanceof String) || StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) continue;
            col.getStyleAttributes().setNumberFormat(colFormat);
        }
        this.table.putBindContents("query", bindContents);
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i);
            String displayName = field.getDisplayName();
            row.getCell(i).setValue((Object)displayName);
        }
        IColumn indexCol = this.table.addColumn();
        indexCol.setKey(INDEX_COLUMN_NAME);
        indexCol.getStyleAttributes().setAlignment(Styles.getDefaultSSA());
        indexCol.getStyleAttributes().setBackground(this.table.getIndexColumn().getStyleAttributes().getBackground());
        this.table.setColumnMoveable(true);
        this.table.moveColumn(size, 0);
        this.table.getIndexColumn().getStyleAttributes().setHided(true);
        this.table.setRefresh(true);
    }

    private void updateIndexColumn() {
        int index = 1;
        int size = this.table.getBody().size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.table.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            this.table.getRow(i).getCell(INDEX_COLUMN_NAME).setValue((Object)new Integer(index));
            ++index;
        }
        int length = String.valueOf(size).length();
        length = length == 1 ? 2 : length;
        this.table.getColumn(INDEX_COLUMN_NAME).setWidth(length * 10);
    }

    private boolean needRequestData() {
        return this.pmtRole.getData() != null;
    }

    private void refreshUI() throws EASBizException, BOSException {
        boolean flag = this.getSelectedRolePK() != null;
        this.virtualIndex = 0;
        this.isFiristGetData = true;
        this.table.removeRows(flag);
        this.actionAddBizData.setEnabled(flag);
        this.actionRemoveBizData.setEnabled(flag);
        this.checkBoxGroup.setAllSelected(false);
        this.checkBoxGroup.setAllEnable(false);
        this.authorizedBizDatas = null;
        this.accreditBizDatas = null;
        this.addDiscretePerms.clear();
        this.updateDiscretePerms.clear();
        this.removeDiscretePerms.clear();
        this.isModify = false;
        this.selectDefaultRow(false);
    }

    public void selectDefaultRow(boolean forceFireEvent) throws EASBizException, BOSException {
        if (this.table.getRowCount() > 0) {
            int count = this.table.getBody().size();
            for (int i = 0; i < count; ++i) {
                if (this.table.getRow(i).getStyleAttributes().isHided()) continue;
                this.table.getSelectManager().select(i, 0);
                if (forceFireEvent) {
                    this.cellChanged();
                }
                return;
            }
        }
    }

    private void cellChanged() throws EASBizException, BOSException {
        this.checkBoxGroup.removeAllChangeListener();
        this.checkBoxGroup.setAllSelected(false);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1) {
            IObjectPK bizDataPK = this.getSelectedBizDataPK();
            DiscretePermCollection ddps = this.getDiscretePerms(bizDataPK);
            this.setComponentStatus(bizDataPK);
            int size = ddps.size();
            for (int i = 0; i < size; ++i) {
                DiscretePermInfo info = ddps.get(i);
                PermItemInfo permItemInfo = info.getPermItem();
                if (permItemInfo == null) continue;
                BOSUuid permItemID = permItemInfo.getId();
                this.viewHelper.setCheckBoxState(this.checkBoxGroup, permItemID);
            }
        } else {
            this.checkBoxGroup.setAllEnable(false);
        }
        this.checkBoxGroup.addAllChangeListener(new CheckBoxChangeListener());
    }

    @Override
    protected void table_tableClicked(KDTMouseEvent e) throws Exception {
        Set bizDataIDs;
        super.table_tableClicked(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex != -1 && (bizDataIDs = this.getSelectedBizDataIDs()).size() > 1) {
            this.cellChanged();
        }
    }

    private Set getAccreditBizDatas() throws EASBizException, BOSException {
        if (this.accreditBizDatas == null) {
            IDiscretePermission discretePermission = DiscretePermissionFactory.getRemoteInstance();
            this.accreditBizDatas = discretePermission.getAccreditBizDatas(this.getCurrentUserPK(), this.getCurrentOrgPK(), this.discreteAccreditProvider.getAccreditPermItemName());
        }
        return this.accreditBizDatas;
    }

    private void setComponentStatus(IObjectPK bizDataPK) throws EASBizException, BOSException {
        String accreditPermItemName = this.discreteAccreditProvider.getAccreditPermItemName();
        if (StringUtils.isEmpty((String)accreditPermItemName)) {
            this.checkBoxGroup.setAllEnable(true);
            this.actionRemoveBizData.setEnabled(true);
        } else {
            boolean flag = this.getAccreditBizDatas().contains(bizDataPK.toString());
            this.checkBoxGroup.setAllEnable(flag);
            this.actionRemoveBizData.setEnabled(flag);
        }
    }

    private FilterInfo getBizDataFilter(BOSObjectType objectType, IObjectPK rolePK, boolean isAuthorized) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ConfigurationInfo configurationInfo = iPermission.getConfigurationInfo();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SELECT DISTINCT FBizDataID FROM ").append(configurationInfo.getDiscretEntityTables().get(objectType.toString())).append(" WHERE FRoleID = '").append(rolePK.toString()).append("' ");
        FilterInfo filterInfo = new FilterInfo();
        CompareType compareType = isAuthorized ? CompareType.INNER : CompareType.NOTINNER;
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), compareType));
        return filterInfo;
    }

    private String getBizDataSQL(BOSObjectType objectType, IObjectPK rolePK, boolean isAuthorized) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        ConfigurationInfo configurationInfo = iPermission.getConfigurationInfo();
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SELECT DISTINCT FBizDataID FROM ").append(configurationInfo.getDiscretEntityTables().get(objectType.toString())).append(" WHERE FRoleID = '").append(rolePK.toString()).append("' ");
        return buffer.toString();
    }

    private Set getAuthorizedBizDatas() throws EASBizException, BOSException {
        if (this.authorizedBizDatas == null) {
            IDiscretePermission discretePermission = DiscretePermissionFactory.getRemoteInstance();
            this.authorizedBizDatas = discretePermission.getRoleAuthorizedBizDatas(this.bizObjectType, this.getSelectedRolePK());
        }
        return this.authorizedBizDatas;
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private IObjectPK getSelectedRolePK() {
        if (this.pmtRole.getData() == null) {
            return null;
        }
        return new ObjectUuidPK(((RoleInfo)this.pmtRole.getData()).getId());
    }

    private IObjectPK getSelectedBizDataPK() {
        if (this.table.getSelectManager().size() != 0) {
            int rowIndex = this.table.getSelectManager().getActiveRowIndex();
            BOSUuid bizDataID = BOSUuid.read((String)this.table.getRow(rowIndex).getCell(this.getLogicPKField(this.bizQuery)).getValue().toString());
            return new ObjectUuidPK(bizDataID);
        }
        return null;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK) {
        IQueryExecutor queryExecutor = null;
        queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExecutor.option().isAutoTranslateEnum = true;
        queryExecutor.option().isAutoTranslateBoolean = true;
        queryExecutor.option().isAutoIgnoreZero = true;
        return queryExecutor;
    }

    private String getLogicPKField(QueryInfo queryInfo) {
        assert (this.bizQuery.getQueryPK().getKeyPropertys().size() == 1);
        QueryFieldInfo queryFieldInfo = this.bizQuery.getQueryPK().getKeyPropertys().get(0);
        return (String)queryFieldInfo.get("name");
    }

    private void requestRowSet(RequestRowSetEvent e) {
        if (this.needRequestData()) {
            try {
                int start = (Integer)e.getParam1() - this.virtualIndex;
                int length = (Integer)e.getParam2() - start + 1;
                MetaDataPK queryPK = new MetaDataPK(this.bizQuery.getFullName());
                IQueryExecutor queryExecutor = this.getQueryExecutor((IMetaDataPK)queryPK);
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = this.getBizDataFilter(this.bizObjectType, this.getSelectedRolePK(), true);
                entityViewInfo.setFilter(filterInfo);
                queryExecutor.setObjectView(entityViewInfo);
                IRowSet rowSet = queryExecutor.executeQuery(start, length);
                e.setRowSet(rowSet);
                if (this.isFiristGetData) {
                    this.table.setRowCount(queryExecutor.getQueryKeys(queryExecutor.openQuery()).size() + this.virtualIndex);
                    this.isFiristGetData = false;
                }
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private DiscretePermCollection getDiscretePerms(IObjectPK bizDataPK) throws EASBizException, BOSException {
        BOSUuid id = BOSUuid.read((String)bizDataPK.toString());
        if (this.addDiscretePerms.containsKey(id)) {
            return (DiscretePermCollection)((Object)this.addDiscretePerms.get(id));
        }
        if (this.removeDiscretePerms.containsKey(id)) {
            return (DiscretePermCollection)((Object)this.removeDiscretePerms.get(id));
        }
        if (this.updateDiscretePerms.containsKey(id)) {
            return (DiscretePermCollection)((Object)this.updateDiscretePerms.get(id));
        }
        IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
        DiscretePermCollection ddps = iDiscretePermission.getRoleDiscretePerms(this.bizObjectType, this.getSelectedRolePK(), this.getSelectedBizDataPK());
        return ddps;
    }

    @Override
    protected void table_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.table_activeCellChanged(e);
        this.cellChanged();
    }

    @Override
    protected void table_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.table_tableSelectChanged(e);
        Set bizDataIDs = this.getSelectedBizDataIDs();
        if (bizDataIDs.size() > 1) {
            this.checkBoxGroup.removeAllChangeListener();
            this.checkBoxGroup.setAllSelected(false);
            String accreditPermItemName = this.discreteAccreditProvider.getAccreditPermItemName();
            if (StringUtils.isEmpty((String)accreditPermItemName)) {
                this.checkBoxGroup.setAllEnable(true);
                this.actionRemoveBizData.setEnabled(true);
            } else {
                boolean flag = true;
                for (BOSUuid bizDataID : bizDataIDs) {
                    if (this.getAccreditBizDatas().contains(bizDataID.toString())) continue;
                    flag = false;
                    break;
                }
                this.checkBoxGroup.setAllEnable(flag);
                this.actionRemoveBizData.setEnabled(flag);
            }
            this.checkBoxGroup.addAllChangeListener(new CheckBoxChangeListener());
        }
    }

    private Set getSelectedBizDataIDs() {
        HashSet<BOSUuid> bizDataIDs = new HashSet<BOSUuid>();
        String idField = this.getLogicPKField(this.bizQuery);
        int size = this.table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock selectBlock = this.table.getSelectManager().get(i);
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                String bizDataID = this.table.getRow(j).getCell(idField).getValue().toString();
                bizDataIDs.add(BOSUuid.read((String)bizDataID));
            }
        }
        return bizDataIDs;
    }

    private DiscretePermCollection getCurrentDDPs(BOSUuid bizDataID, boolean isRemoved) {
        DiscretePermCollection ddps = new DiscretePermCollection();
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)this.getSelectedRolePK().toString()));
        Iterator iterator = this.checkBoxGroup.iterator();
        while (iterator.hasNext()) {
            KDCheckBox checkBox = (KDCheckBox)iterator.next();
            if (!checkBox.isSelected() && !isRemoved) continue;
            PermItemInfo permItemInfo = (PermItemInfo)checkBox.getUserObject();
            DiscretePermInfo discretePermInfo = new DiscretePermInfo();
            discretePermInfo.setRole(roleInfo);
            discretePermInfo.setBizDataID(bizDataID);
            discretePermInfo.setPermItemInfo(permItemInfo);
            ddps.add(discretePermInfo);
        }
        return ddps;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkBeforeSumbit();
        if (PermissionHelper.isAuthenticateAdminEnabled() && this.isModify && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ROLE_WILL_NEED_AUTHEN"), this.getSelectedRole()))) == 2) {
            SysUtil.abort();
        }
        if (this.hasUnnecessaryBizData()) {
            int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"hasUnnecessaryBizData"));
            if (MsgBox.isYes((int)isYes)) {
                LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
                dialog.setLongTimeTask(new ILongTimeTask(){

                    @Override
                    public Object exec() throws Exception {
                        RoleDiscreteAccreditUI.this.save();
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                        MsgBox.showInfo((Component)((Object)RoleDiscreteAccreditUI.this), (String)EASResource.getString((String)RoleDiscreteAccreditUI.RESOURCE, (String)"accreditPermSucceed"));
                        RoleDiscreteAccreditUI.this.refreshUI();
                    }
                });
                dialog.show();
            }
        } else {
            LongTimeDialog dialog = new LongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            dialog.setLongTimeTask(new ILongTimeTask(){

                @Override
                public Object exec() throws Exception {
                    RoleDiscreteAccreditUI.this.save();
                    return "";
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((Component)((Object)RoleDiscreteAccreditUI.this), (String)EASResource.getString((String)RoleDiscreteAccreditUI.RESOURCE, (String)"accreditPermSucceed"));
                    RoleDiscreteAccreditUI.this.refreshUI();
                }
            });
            dialog.show();
        }
    }

    private void save() throws EASBizException, BOSException {
        IDiscretePermission iDiscretePermission = DiscretePermissionFactory.getRemoteInstance();
        DiscretePermCollection[] ddps = this.getDPResult();
        Map uiMap = this.getUIContext();
        DiscretePermCollection[] res = this.viewHelper.filterDiscretePermCol(ddps, uiMap);
        iDiscretePermission.saveDiscretePerms(this.bizObjectType, res);
        CacheUtil.clearBizCache(this.bizObjectType);
    }

    private String getSelectedRole() {
        if (this.pmtRole.getData() == null) {
            return null;
        }
        return ((RoleInfo)this.pmtRole.getData()).getNumber();
    }

    private DiscretePermCollection[] getDPResult() {
        DiscretePermCollection[] ddps = new DiscretePermCollection[]{new DiscretePermCollection(), new DiscretePermCollection(), new DiscretePermCollection(), new DiscretePermCollection()};
        for (DiscretePermCollection item : this.addDiscretePerms.values()) {
            ddps[0].addCollection(item);
        }
        for (DiscretePermCollection item : this.removeDiscretePerms.values()) {
            ddps[1].addCollection(item);
        }
        for (DiscretePermCollection item : this.updateDiscretePerms.values()) {
            ddps[2].addCollection(item);
        }
        if (this.table.getRowCount() > 0) {
            DiscretePermInfo discretePermInfo = new DiscretePermInfo();
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)this.getSelectedRolePK().toString()));
            discretePermInfo.setRole(roleInfo);
            ddps[3].add(discretePermInfo);
        }
        return ddps;
    }

    @Override
    protected void pmtRole_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtRole_dataChanged(e);
        this.refreshUI();
    }

    private void checkBeforeSumbit() {
        if (this.getSelectedRolePK() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"roleIsNotSelected"));
            this.abort();
        }
        if (this.isBadSelected()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"discreteDataSelectAlert"));
            this.abort();
        }
    }

    private boolean isBadSelected() {
        String idField = this.getLogicPKField(this.bizQuery);
        for (int i = 0; i < this.virtualIndex; ++i) {
            String bizDataID;
            if (this.table.getRow(i).getStyleAttributes().isHided() || !this.addDiscretePerms.containsKey(BOSUuid.read((String)(bizDataID = this.table.getRow(i).getCell(idField).getValue().toString())))) continue;
            return false;
        }
        return this.virtualIndex != 0;
    }

    private boolean hasUnnecessaryBizData() {
        String idField = this.getLogicPKField(this.bizQuery);
        for (int i = 0; i < this.virtualIndex; ++i) {
            String bizDataID = this.table.getRow(i).getCell(idField).getValue().toString();
            if (this.addDiscretePerms.containsKey(BOSUuid.read((String)bizDataID))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionAddBizData_actionPerformed(ActionEvent e) throws Exception {
        Object data;
        super.actionAddBizData_actionPerformed(e);
        IDiscreteDataSelector dlg = this.getBizDataDialog();
        if (dlg instanceof KDCommonPromptDialog) {
            ((KDCommonPromptDialog)dlg).setHasHideQuichFilterPanel(true);
        }
        dlg.show();
        if (!dlg.isCanceled() && (data = dlg.getData()) != null) {
            if (data instanceof Object[]) {
                Object[] datas = (Object[])data;
                int length = datas.length;
                for (int i = 0; i < length; ++i) {
                    IObjectValue objectValue = (IObjectValue)datas[i];
                    if (this.existBizData(objectValue)) continue;
                    this.loadRowData(objectValue);
                    ++this.virtualIndex;
                    this.table.setRowCount(this.table.getRowCount() + 1);
                }
            } else {
                IObjectValue objectValue = (IObjectValue)data;
                if (!this.existBizData(objectValue)) {
                    this.loadRowData(objectValue);
                    ++this.virtualIndex;
                    this.table.setRowCount(this.table.getRowCount() + 1);
                }
            }
            this.selectDefaultRow(true);
            this.updateIndexColumn();
            this.table.reLayoutAndPaint();
        }
    }

    private boolean existBizData(IObjectValue bizData) {
        String idField = this.getLogicPKField(this.bizQuery);
        int count = this.table.getBody().size();
        for (int i = 0; i < count; ++i) {
            String existBizDataID;
            String bizDataID = bizData.get("id").toString();
            if (this.table.getRow(i).getStyleAttributes().isHided() || !bizDataID.equals(existBizDataID = this.table.getRow(i).getCell(idField).getValue().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionRemoveBizData_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionRemoveBizData_actionPerformed(e);
        if (this.table.getSelectManager().size() == 0) {
            return;
        }
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)this.getSelectedRolePK().toString()));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int size = this.table.getSelectManager().size();
        for (i = 0; i < size; ++i) {
            KDTSelectBlock selectBlock = this.table.getSelectManager().get(i);
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                this.isModify = true;
                arrayList.add(new Integer(j));
                BOSUuid bizDataID = BOSUuid.read((String)this.table.getRow(j).getCell(this.getLogicPKField(this.bizQuery)).getValue().toString());
                if (this.getAuthorizedBizDatas().contains(bizDataID)) {
                    DiscretePermCollection collection = new DiscretePermCollection();
                    Iterator iterator = this.checkBoxGroup.iterator();
                    while (iterator.hasNext()) {
                        KDCheckBox checkBox = (KDCheckBox)iterator.next();
                        PermItemInfo permItemInfo = (PermItemInfo)checkBox.getUserObject();
                        DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                        discretePermInfo.setRole(roleInfo);
                        discretePermInfo.setPermItemInfo(permItemInfo);
                        discretePermInfo.setBizDataID(bizDataID);
                        collection.add(discretePermInfo);
                    }
                    this.removeDiscretePerms.put(bizDataID, collection);
                    this.updateDiscretePerms.remove(bizDataID);
                    continue;
                }
                this.addDiscretePerms.remove(bizDataID);
                --this.virtualIndex;
            }
        }
        this.table.setRefresh(false);
        for (i = arrayList.size() - 1; i >= 0; --i) {
            this.table.getRow(((Integer)arrayList.get(i)).intValue()).getStyleAttributes().setHided(true);
        }
        this.updateIndexColumn();
        this.table.setRefresh(true);
        this.table.repaint();
        this.checkBoxGroup.setAllEnable(false);
        this.checkBoxGroup.setAllSelected(false);
    }

    private void loadRowData(IObjectValue objectValue) throws ClassNotFoundException {
        this.isModify = true;
        this.table.setRefresh(false);
        IRow row = this.table.addRow(0);
        int count = this.table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String field = this.table.getColumnKey(i);
            if (INDEX_COLUMN_NAME.equals(field)) continue;
            DataType dataType = this.getDataType(field);
            Object fieldData = null;
            if (field.indexOf(".") != -1) {
                String[] properties = StringUtils.split((String)field, (String)".");
                fieldData = objectValue;
                int length = properties.length;
                for (int j = 0; j < length; ++j) {
                    if (fieldData == null) {
                        fieldData = null;
                        break;
                    }
                    fieldData = ((IObjectValue)fieldData).get(properties[j]);
                }
            } else {
                fieldData = objectValue.get(field);
            }
            if (DataType.BOOLEAN.equals((Object)dataType)) {
                if (fieldData != null) {
                    fieldData = TypeConversionUtils.objToBoolean((Object)fieldData);
                }
            } else if (DataType.ENUM.equals((Object)dataType) && fieldData != null) {
                Class<?> enumClass = Class.forName(this.getEnumName(field));
                if (fieldData instanceof String) {
                    fieldData = EnumUtils.getEnum(enumClass, (String)((String)fieldData)).getAlias();
                } else if (fieldData instanceof Integer) {
                    fieldData = EnumUtils.getEnum(enumClass, (int)((Integer)fieldData)).getAlias();
                }
            }
            row.getCell(i).setValue(fieldData);
        }
        this.table.setRefresh(true);
    }

    private DataType getDataType(String field) {
        QueryFieldInfo queryFieldInfo = this.bizQuery.getUnits().getQueryFields().get(field);
        assert (queryFieldInfo.getPropertyRefs().size() == 1);
        SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
        String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
        EntityObjectInfo entity = subEntityInfo.getEntityRef();
        PropertyCollection collection = entity.getInheritedDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownPropertyInfo;
            PropertyInfo propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) || !propertyName.equals((ownPropertyInfo = (OwnPropertyInfo)propertyInfo).getName())) continue;
            return ownPropertyInfo.getDataType();
        }
        throw new IllegalArgumentException("propertyName:" + propertyName + " not found in entity:" + entity.getFullName());
    }

    private String getEnumName(String field) {
        QueryFieldInfo queryFieldInfo = this.bizQuery.getUnits().getQueryFields().get(field);
        assert (queryFieldInfo.getPropertyRefs().size() == 1);
        SubEntityInfo subEntityInfo = queryFieldInfo.getPropertyRefs().get(0).getSubEntity();
        String propertyName = (String)queryFieldInfo.getPropertyRefs().get(0).getRefProperty().get("name");
        EntityObjectInfo entity = subEntityInfo.getEntityRef();
        PropertyCollection collection = entity.getInheritedDuplicatedProperties();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            OwnPropertyInfo ownPropertyInfo;
            PropertyInfo propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) || !propertyName.equals((ownPropertyInfo = (OwnPropertyInfo)propertyInfo).getName()) || !DataType.ENUM.equals((Object)ownPropertyInfo.getDataType())) continue;
            return ownPropertyInfo.getMetaDataRef();
        }
        throw new IllegalArgumentException("propertyName:" + propertyName + " not found in entity:" + entity.getFullName());
    }

    private IObjectPK getCurrentOrgPK() {
        OrgType orgType = null;
        String ORG_TYPE = "OrgType";
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(this.bizObjectType);
        orgType = StringUtils.isEmpty((String)entity.getExtendedProperty("OrgType")) ? OrgType.NONE : OrgType.getEnum((String)entity.getExtendedProperty("OrgType"));
        if (orgType.equals((Object)OrgType.NONE)) {
            return new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
        }
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit(orgType).getId());
    }

    private IDiscreteDataSelector getBizDataDialog() throws Exception {
        IDiscreteDataSelector selector = this.discreteAccreditProvider.getSelector(this.getCurrentUserPK(), this.getCurrentOrgPK(), (IUIObject)this);
        String condition = null;
        if (selector.isOQLType()) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(this.getBizDataFilter(this.bizObjectType, this.getSelectedRolePK(), false));
            condition = entityViewInfo.toString();
        } else {
            condition = this.getBizDataSQL(this.bizObjectType, this.getSelectedRolePK(), false);
        }
        selector.mergeAccreditCondition(condition);
        return selector;
    }

    private class CheckBoxChangeListener
    implements ChangeListener {
        private CheckBoxChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RoleDiscreteAccreditUI.this.checkBoxChanged(e);
        }
    }
}

