/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.RoleGroupFactory;
import com.kingdee.eas.base.permission.RoleGroupInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleGroupEditUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RoleGroupEditUI
extends AbstractRoleGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RoleGroupEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private boolean checkNumber() {
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            return true;
        }
        String patternStr = "[\\W_]+";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(number);
        return !matcher.find();
    }

    private void initUI() {
        this.btnRemove.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        return sic;
    }

    private void setUIView() {
        this.initUI();
        String title = PermissionCommonUtil.getUITitle(this.getUITitle(), this.getOprtState());
        this.setUITitle(title);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUIView();
    }

    protected IObjectValue createNewData() {
        RoleGroupInfo groupInfo = new RoleGroupInfo();
        groupInfo.setParent((RoleGroupInfo)this.getUIContext().get("ParentNode"));
        return groupInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RoleGroupFactory.getRemoteInstance();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        RoleGroupInfo rolGroupInfo = (RoleGroupInfo)this.getUIContext().get("ParentNode");
        if (!rolGroupInfo.isIsLeaf()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_OnlyLeaf_CanDelete"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        try {
            if (!this.checkNumber()) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"invalid_number"));
                return;
            }
            CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
            ctrlUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            this.editData.setCU(ctrlUnitInfo);
            super.actionSubmit_actionPerformed(e);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
    }

    private void verify() {
        String mulName;
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"numberIsBlank"));
            this.abort();
        }
        if (StringUtils.isEmpty((String)(mulName = this.mulName.getDefaultLangItemData().toString()))) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"nameIsBlank"));
            this.abort();
        }
    }
}

