/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IRolePerm;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.client.AbstractRolePermViewUI;
import com.kingdee.eas.base.permission.client.RoleDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.RoleFieldAccessViewUI;
import com.kingdee.eas.base.permission.client.RulePanel;
import com.kingdee.eas.base.permission.client.tree.IPermissionTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeBuilderFactory;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class RolePermViewUI
extends AbstractRolePermViewUI {
    private KDTreeNode branch = null;
    private static final int NORMAL_INDEX = 1;
    private static final int FORBIDDEN_INDEX = 2;
    private static final int AUTHORIZATION_INDEX = 0;
    private boolean isShowRule = false;
    private RulePanel rulePanel = null;
    private IPermissionTreeBuilder builder = null;
    private ConfigurationInfo configurationInfo = null;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.put("targetID", (Object)new ObjectUuidPK((String)this.getUIContext().get("targetID")));
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initTrees();
        this.setTitle();
        this.loadConfigurationInfo();
    }

    private void loadConfigurationInfo() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        this.configurationInfo = iPermission.getConfigurationInfo();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.showRulePanel(this.isShowRule);
    }

    private void initTrees() throws Exception {
        this.builder = PermissionTreeBuilderFactory.getRolePermTreeBuilder();
        this.buildTrees();
        this.addPopupMenu();
    }

    private void addPopupMenu() {
        UIUtil.addStandardPopupMenu(this.treeNormalPerm);
        UIUtil.addStandardPopupMenu(this.treeForbiddenPerm);
    }

    private void setTitle() {
        this.setUITitle(this.getUITitle() + " - " + this.getRoleName());
    }

    private void initUI() throws Exception {
        this.rulePanel = new RulePanel();
        this.rulePanel.setStatus(this.getOprtState());
        this.add((Component)((Object)this.rulePanel), null);
        this.rulePanel.setBounds(new Rectangle(0, 323, 630, 170));
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.tHelper.getDisabledTables().add(this.rulePanel.getTable());
        this.tabAssign.removeAll();
        this.tabAssign.add((Component)this.tviewNormalPerm, (Object)this.resHelper.getString("tviewNormalPerm.constraints"));
        this.tabAssign.add((Component)this.tviewForbiddenPerm, (Object)this.resHelper.getString("tviewForbiddenPerm.constraints"));
        this.tabAssign.setSelectedComponent((Component)this.tviewNormalPerm);
    }

    private void buildTrees() throws Exception {
        this.branch = this.builder.createTreeBranch();
        IRolePerm iRolePerm = RolePermFactory.getRemoteInstance();
        RolePermCollection rolePerms = iRolePerm.getTargetRolePerms(this.getRolePK());
        ArrayList list = PermissionCommonUtil.assortPerms(rolePerms);
        this.buildNormalTree((RolePermCollection)((Object)list.get(1)));
        this.buildForbiddenTree((RolePermCollection)((Object)list.get(2)));
        this.buildAuthorizationTree((RolePermCollection)((Object)list.get(0)));
    }

    private void buildNormalTree(RolePermCollection rolePerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot((TreeNode)root);
        this.builder.setDataRuleIcon(root);
    }

    private void buildForbiddenTree(RolePermCollection rolePerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        this.builder.setForbiddenIcon(root);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot((TreeNode)root);
    }

    private void buildAuthorizationTree(RolePermCollection rolePerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)rolePerms);
        ((DefaultTreeModel)this.treeAuthorization.getModel()).setRoot((TreeNode)root);
        this.builder.setDataRuleIcon(root);
    }

    private IObjectPK getRolePK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private String getRoleName() {
        return (String)this.getUIContext().get("name");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDiscretePerm.setVisible(false);
        this.btnShowRule.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnHideRule.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnDiscretePerm.setIcon(EASResource.getIcon((String)"imgTbtn_scatterpurview"));
        this.btnFieldAccessAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_fieldpurview"));
    }

    @Override
    public void actionHideRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionHideRule_actionPerformed(e);
        this.isShowRule = false;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    public void actionShowRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowRule_actionPerformed(e);
        this.isShowRule = true;
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    private void showRulePanel(boolean isVisible) {
        IUIWindow win = this.getUIWindow();
        this.rulePanel.setVisible(isVisible);
        if (isVisible) {
            if (win instanceof UIModelDialog) {
                ((UIModelDialog)win).setSize(636, 580);
            } else if (win instanceof Frame) {
                ((Frame)win).setSize(636, 580);
            }
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setSize(636, 425);
        } else if (win instanceof Frame) {
            ((Frame)win).setSize(636, 425);
        }
    }

    @Override
    protected void treeNormalPerm_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeNormalPerm_valueChanged(e);
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            this.loadRule((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
        }
        this.setDiscreteButtonStatus(e);
    }

    @Override
    protected void treeAuthorization_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeAuthorization_valueChanged(e);
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            this.loadRule((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
        }
        this.setDiscreteButtonStatus(e);
    }

    private void setDiscreteButtonStatus(TreeSelectionEvent e) {
        BOSObjectType objectType;
        KDTreeNode node;
        Object old;
        if (e.getNewLeadSelectionPath() != null && (old = e.getNewLeadSelectionPath().getLastPathComponent()) != null && this.enableDataPermission(node = (KDTreeNode)old) && (objectType = this.getRuleObjectType(node)) != null) {
            this.btnDiscretePerm.setVisible(this.configurationInfo.getDiscretEntityTables().containsKey(objectType.toString()));
            return;
        }
        this.btnDiscretePerm.setVisible(false);
    }

    private boolean enableDataPermission(KDTreeNode node) {
        if (node.isLeaf()) {
            RolePermInfo info = (RolePermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType) && info.getPermItem().isEnableDataPermission()) {
                return true;
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                RolePermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (RolePermInfo)child.getUserObject()).getPermItem().getObjectType())) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
        }
        return false;
    }

    private void loadRule(KDTreeNode node) throws EASBizException, ParserException, BOSException {
        if (node == null) {
            this.rulePanel.reset();
        } else {
            RolePermInfo info = (RolePermInfo)node.getUserObject();
            if (info.getPermItem().isIsLeaf() && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                this.rulePanel.setBizObjectType(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                String ruleStructure = info.getRuleStructure();
                this.rulePanel.setRuleStructure(ruleStructure);
                this.rulePanel.refresh();
            } else {
                this.rulePanel.reset();
            }
        }
    }

    private BOSObjectType getRuleObjectType(KDTreeNode node) {
        if (node.isLeaf()) {
            RolePermInfo info = (RolePermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType)) {
                return BOSObjectType.create((String)objectType);
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                RolePermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (RolePermInfo)child.getUserObject()).getPermItem().getObjectType()))) continue;
                return BOSObjectType.create((String)objectType);
            }
        }
        return null;
    }

    @Override
    public void actionDiscretePerm_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType objectType;
        super.actionDiscretePerm_actionPerformed(e);
        Object obj = this.treeNormalPerm.getLastSelectedPathComponent();
        if (obj != null && (objectType = this.getRuleObjectType((KDTreeNode)obj)) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bosObjectType", (Object)objectType);
            uiContext.put((Object)"targetRolePK", (Object)this.getRolePK());
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RoleDiscretePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    @Override
    public void actionFieldAccessAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFieldAccessAccredit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rolePK", (Object)this.getRolePK());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RoleFieldAccessViewUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }
}

