/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.ISpecialDirectorPerm;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.SpecialDirectorPermCollection;
import com.kingdee.eas.base.permission.SpecialDirectorPermFactory;
import com.kingdee.eas.base.permission.SpecialDirectorPermInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractSpecialDirectorListUI;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.f7.AdminF7PromptDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.client.util.UIUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2Map;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpecialDirectorListUI
extends AbstractSpecialDirectorListUI {
    private static final Logger logger = CoreUIObject.getLogger(SpecialDirectorListUI.class);
    static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    public static final String OBJTYPE_LIST = "ObjTypeList";
    public static final String CU_ID = "cu_id";
    private String cuId = null;
    private Map curSelectUserOrgRangeMap = new HashMap();
    private List objTypeList = null;
    private Map selectUserInfoMap = new HashMap();
    private static int USER_INDEX = 0;
    private IOrgRange iOrgRange = null;
    private static final String ORGNUMBER = "org.number";
    private boolean isSave = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        KDTSelectManager kDTSelectManager = this.tblMain.getSelectManager();
        this.tblMain.getSelectManager();
        kDTSelectManager.setSelectMode(10);
        this.objTypeList = (List)this.getUIContext().get(OBJTYPE_LIST);
        this.cuId = this.getUIContext().get(CU_ID).toString();
        if (this.objTypeList == null || this.objTypeList.isEmpty()) {
            throw new IllegalArgumentException("objTypeList is null!");
        }
        this.initOriList();
        this.execQuery();
    }

    private void initUI() {
        this.btnAddUser.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelUser.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnOrgModi.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SpecialDirectorPermFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void initOriList() {
        SpecialDirectorPermCollection specialDirectionCol = null;
        try {
            specialDirectionCol = this.getBizIntefaceMy().getSpecialDirectorCol(this.objTypeList, (IObjectPK)new ObjectStringPK(this.cuId));
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        if (specialDirectionCol == null || specialDirectionCol.isEmpty()) {
            return;
        }
        Map userOrgRangeMap = ToolUtils.transCol2ListByPeroperty((IObjectCollection)specialDirectionCol, new IObjectCol2Map(){

            @Override
            public String getKey(Object obj) {
                SpecialDirectorPermInfo specialPermInfo;
                if (obj instanceof SpecialDirectorPermInfo && (specialPermInfo = (SpecialDirectorPermInfo)obj).getUserOrgRange() != null && specialPermInfo.getUserOrgRange().getId() != null) {
                    return specialPermInfo.getUserOrgRange().getId().toString();
                }
                return null;
            }

            @Override
            public Object getList(Object obj) {
                SpecialDirectorPermInfo specialPermInfo = (SpecialDirectorPermInfo)obj;
                return specialPermInfo.getUserOrgRange();
            }
        });
        if (userOrgRangeMap == null || userOrgRangeMap.isEmpty()) {
            return;
        }
        this.curSelectUserOrgRangeMap.putAll(userOrgRangeMap);
    }

    protected FilterInfo getSelectUserFilter() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.curSelectUserOrgRangeMap == null || this.curSelectUserOrgRangeMap.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"1"));
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"1", CompareType.NOTEQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(ToolUtils.trans2List(this.curSelectUserOrgRangeMap.keySet()), false), CompareType.INCLUDE));
        }
        return filterInfo;
    }

    protected void execQuery() {
        FilterInfo filterInfo = this.getSelectUserFilter();
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        if (filterInfo != null) {
            this.mainQuery.setFilter(filterInfo);
        }
        this.mainQuery.getSorter().add(new SorterItemInfo("user.number"));
        super.execQuery();
        this.addUser2Table(this.selectUserInfoMap);
    }

    private ISpecialDirectorPerm getBizIntefaceMy() throws Exception {
        return (ISpecialDirectorPerm)this.getBizInterface();
    }

    @Override
    public void actionAddUser_actionPerformed(ActionEvent e) throws Exception {
        KDCommonPromptDialog dlg = this.getUserDialog();
        dlg.show();
        if (!dlg.isCanceled()) {
            Object obj = dlg.getData();
            if (obj != null && obj instanceof Object[]) {
                Object[] userInfoAry = (Object[])obj;
                for (int i = 0; i < userInfoAry.length; ++i) {
                    UserInfo userInfo;
                    IRow row;
                    if (userInfoAry[i] == null || (row = this.getRow((userInfo = (UserInfo)userInfoAry[i]).getId().toString(), null)) != null) continue;
                    IRow iRow = this.tblMain.addRow();
                    iRow.getCell(0).setValue((Object)userInfo.getId().toString());
                    iRow.getCell(1).setValue((Object)userInfo.getNumber());
                    iRow.getCell(2).setValue((Object)userInfo.getName());
                    iRow.getCell(3).setValue((Object)userInfo.getType().getAlias());
                }
            }
            this.isSave = false;
        }
    }

    private KDCommonPromptDialog getUserDialog() {
        UserPromptBox dlg = null;
        IUIWindow win = this.getUIWindow();
        if (win instanceof Frame) {
            dlg = new UserPromptBox((Frame)this.getUIWindow());
        } else if (win instanceof Dialog) {
            dlg = new UserPromptBox((Dialog)this.getUIWindow());
        }
        dlg.setEnabledMultiSelection(true);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
        dlg.setQueryInfo(queryPK);
        this.setMaySelectUserFilter(dlg);
        dlg.setHasCUDefaultFilter(false);
        return dlg;
    }

    private void addUser2Table(Map userMap) {
        if (userMap == null || userMap.isEmpty()) {
            return;
        }
        Iterator it = userMap.keySet().iterator();
        int rowCount = this.tblMain.getRowCount();
        while (it.hasNext()) {
            UserInfo oneUserInfo = (UserInfo)userMap.get(it.next().toString());
            IRow iRow = this.tblMain.addRow();
            ++rowCount;
            iRow.getCell(0).setValue((Object)oneUserInfo.getId().toString());
            iRow.getCell(1).setValue((Object)oneUserInfo.getNumber());
            iRow.getCell(2).setValue((Object)oneUserInfo.getName());
            iRow.getCell(3).setValue((Object)oneUserInfo.getType().getAlias());
        }
        this.tblMain.setRowCount(rowCount);
        this.tblMain.reLayoutAndPaint();
    }

    @Override
    public void actionDelUser_actionPerformed(ActionEvent e) throws Exception {
        UIUtil.removeRow(this.tblMain);
        this.isSave = false;
    }

    @Override
    public void actionModiOrg_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List<OrgUnitInfo> orgs = this.selectOrg(this.getUserIdList(this.tblMain, USER_INDEX));
        if (orgs == null || orgs.isEmpty()) {
            return;
        }
        for (int i = this.tblMain.getSelectManager().size() - 1; i >= 0; --i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getTop();
            for (int j = selectBlock.getBottom(); j >= size1; --j) {
                IRow row = this.tblMain.getRow(j);
                String tpUserid = row.getCell("user.id").getValue().toString();
                int rowIndex = row.getRowIndex();
                this.tblMain.removeRow(rowIndex);
                for (int k = 0; k < orgs.size(); ++k) {
                    OrgUnitInfo org = orgs.get(k);
                    IRow existRow = this.getRow(tpUserid, org.getId().toString());
                    if (existRow != null) continue;
                    IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
                    IRow iRow = this.tblMain.addRow(rowIndex++);
                    iRow.getCell("user.id").setValue(row.getCell("user.id").getValue());
                    iRow.getCell("user.number").setValue(row.getCell("user.number").getValue());
                    iRow.getCell("user.name").setValue(row.getCell("user.name").getValue());
                    iRow.getCell("user.type").setValue(row.getCell("user.type").getValue());
                    iRow.getCell("org.id").setValue((Object)org.getId());
                    iRow.getCell(ORGNUMBER).setValue((Object)org.getNumber());
                    iRow.getCell("org.name").setValue((Object)org.getName());
                }
            }
        }
        this.isSave = false;
    }

    private void setMaySelectUserFilter(KDCommonPromptDialog dlg) {
        List alreadySelectUserList = UITools.getUserIdList(this.tblMain, 1);
        FilterInfo filterInfo = null;
        if (alreadySelectUserList != null && !alreadySelectUserList.isEmpty()) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(alreadySelectUserList, false), CompareType.NOTINCLUDE));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        dlg.setEntityViewInfo(entityViewInfo);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyBeforeSave();
        this.getBizIntefaceMy().save(this.objTypeList, this.getAllSaveData(), (IObjectPK)new ObjectStringPK(this.cuId));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"saveSuccessed"));
        this.isSave = true;
    }

    private void verifyBeforeSave() {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow currentRow = this.tblMain.getRow(i);
            ICell orgNumberCell = currentRow.getCell(ORGNUMBER);
            Object orgNumber = orgNumberCell.getValue();
            if (orgNumber != null && !StringUtils.isEmpty((String)orgNumber.toString())) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
            SysUtil.abort();
        }
    }

    public List getUserIdList(KDTable tblMain, int column) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int size = tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)tblMain, (IBlock)tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                String userId = (String)tblMain.getValueAt(j, column);
                if (StringUtils.isEmpty((String)userId)) continue;
                arrayList.add(userId);
            }
        }
        return arrayList;
    }

    public IRow getRow(String userId, String orgId) {
        if (orgId == null) {
            orgId = "";
        }
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String tpOrgId;
            IRow row = this.tblMain.getRow(i);
            String tpUserid = row.getCell("user.id").getValue().toString();
            String string = tpOrgId = row.getCell("org.id").getValue() == null ? "" : row.getCell("org.id").getValue().toString();
            if (!userId.equals(tpUserid) || !orgId.equals(tpOrgId)) continue;
            return row;
        }
        return null;
    }

    public List<OrgUnitInfo> selectOrg(List<String> userIdStrList) {
        ArrayList<OrgUnitInfo> adminOrgList = new ArrayList<OrgUnitInfo>();
        AdminF7PromptDialog f7 = new AdminF7PromptDialog((IUIObject)this, userIdStrList);
        f7.setMultiSelect(true);
        f7.show();
        if (!f7.isCanceled()) {
            Object obj = f7.getData();
            if (obj instanceof Object[]) {
                Object[] adminAry = (Object[])obj;
                for (int i = 0; i < adminAry.length; ++i) {
                    adminOrgList.add((OrgUnitInfo)adminAry[i]);
                }
            } else if (obj instanceof Object) {
                adminOrgList.add((OrgUnitInfo)obj);
            }
        }
        return adminOrgList;
    }

    private List<Map<String, String>> getAllSaveData() {
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            String tpUserid = row.getCell("user.id").getValue().toString();
            String tpOrgId = row.getCell("org.id").getValue().toString();
            if (StringUtils.isEmpty((String)tpUserid) || StringUtils.isEmpty((String)tpOrgId)) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("userId", tpUserid);
            data.put("orgId", tpOrgId);
            datas.add(data);
        }
        return datas;
    }

    protected boolean checkBeforeWindowClosing() {
        if (!this.isSave) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    this.actionSave.actionPerformed(event);
                    return !this.actionSave.isInvokeFailed();
                }
                catch (Exception exc) {
                    return false;
                }
            }
            if (result == 1) {
                return super.checkBeforeWindowClosing();
            }
            return false;
        }
        return super.checkBeforeWindowClosing();
    }
}

