/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.MultiLangList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.AbstractUserType;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserDataTransferFacade;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserDataTransferFacadeFactory;
import com.kingdee.eas.base.permission.UserDataTransferInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.UserTypeFactory;
import com.kingdee.eas.base.permission.client.AbstractUserDataTransferUI;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.service.ValidateCommunicationFactory;
import com.kingdee.eas.base.permission.service.comstrategy.CommunicationInfo;
import com.kingdee.eas.base.permission.service.comstrategy.ValidateComResultInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.BigMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class UserDataTransferUI
extends AbstractUserDataTransferUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDataTransferUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUsbKeyResource";
    private UserListUIHelper helper = null;
    boolean isRegister = false;
    boolean isBizManager = this.getCurrentUser().isBizAdmin();

    public UserDataTransferUI() throws Exception {
        this.helper = new UserListUIHelper();
        this.initUI();
        this.installListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initUI() {
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.bizSourceAcount.setRequired(true);
        this.initUserF7(this.bizSourceAcount);
        this.initUserF7(this.bizTgtAccount);
        this.updateUserRealName(this.bizUserName, this.getSourceUserType());
        this.updateUIByCheck(false);
    }

    private void initUserF7(KDBizPromptBox f7) {
        f7.setSelector((KDPromptSelector)this.getUserDialog());
        EntityViewInfo evi = new EntityViewInfo();
        try {
            evi.setFilter(this.helper.getCurrentRangeUser());
        }
        catch (ParserException e) {
            logger.error((Object)"permission.UserDataTransferUI.initUserF7:ParserException ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"permission.UserDataTransferUI.initUserF7:EASBizException ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"permission.UserDataTransferUI.initUserF7:BOSException ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error((Object)"permission.UserDataTransferUI.initUserF7:UuidException ", (Throwable)e);
        }
        f7.setEntityViewInfo(evi);
        f7.setCommitFormat("$number$");
        f7.setDisplayFormat("$number$--$name$");
        f7.setEditFormat("$number$");
    }

    private KDCommonPromptDialog getUserDialog() {
        UserPromptBox dlg = new UserPromptBox((IUIObject)this.getUIWindow());
        dlg.setEnabledMultiSelection(true);
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
        dlg.setQueryInfo(queryPK);
        dlg.setHasCUDefaultFilter(false);
        return dlg;
    }

    public void onLoad() throws Exception {
        try {
            this.isRegister = FrameWorkClientUtils.getLicenseController().isRegister();
        }
        catch (LicenseException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        super.onLoad();
        HashMap map = (HashMap)this.getUIContext();
        UserInfo sltUserInfo = (UserInfo)map.get("sltUserInfo");
        if (map.get("licenseIsUserType") == null || !Boolean.valueOf(map.get("licenseIsUserType").toString()).booleanValue()) {
            // empty if block
        }
        this.bizSourceAcount.setData((Object)sltUserInfo);
        this.setFilterForAuthAdmin();
        this.setFilterForBizUser();
        this.chkCpBasicMsg.setVisible(true);
    }

    private void setFilterForBizUser() throws ParserException {
        try {
            FilterInfo filter = this.getBizUserFilter();
            EntityViewInfo tgtEvi = this.bizTgtAccount.getEntityViewInfo();
            EntityViewInfo sourceEvi = this.bizSourceAcount.getEntityViewInfo();
            tgtEvi = this.mergeEviAndFilter(tgtEvi, filter, "and");
            sourceEvi = this.mergeEviAndFilter(sourceEvi, filter, "and");
            this.bizSourceAcount.setEntityViewInfo(tgtEvi);
            this.bizTgtAccount.setEntityViewInfo(sourceEvi);
        }
        catch (BOSException be) {
            this.handleException((Exception)((Object)be));
        }
        catch (EASBizException ee) {
            this.handleException((Exception)((Object)ee));
        }
    }

    private FilterInfo getBizUserFilter() throws BOSException, ParserException, EASBizException {
        if (this.isBizManager) {
            FilterInfo bizFilter = this.helper.getCurrentRangeUser();
            FilterInfo adminFilter = new FilterInfo(" type <> 10 ");
            bizFilter.mergeFilter(adminFilter, "and");
            return bizFilter;
        }
        return new FilterInfo();
    }

    private void setFilterForAuthAdmin() throws ParserException {
        try {
            FilterInfo authAdminFilter = this.getAuAdminFilter();
            EntityViewInfo tgtEvi = this.bizTgtAccount.getEntityViewInfo();
            EntityViewInfo sourceEvi = this.bizSourceAcount.getEntityViewInfo();
            tgtEvi = this.mergeEviAndFilter(tgtEvi, authAdminFilter, "and");
            sourceEvi = this.mergeEviAndFilter(sourceEvi, authAdminFilter, "and");
            this.bizSourceAcount.setEntityViewInfo(tgtEvi);
            this.bizTgtAccount.setEntityViewInfo(sourceEvi);
        }
        catch (BOSException be) {
            this.handleException((Exception)((Object)be));
        }
    }

    private FilterInfo getAuAdminFilter() throws ParserException {
        return Administrator.getNotAuUserFilter();
    }

    private EntityViewInfo mergeEviAndFilter(EntityViewInfo evi, FilterInfo filter, String logic) throws BOSException {
        if (evi != null && evi.getFilter() != null) {
            evi.getFilter().mergeFilter(filter, logic);
        } else {
            evi = new EntityViewInfo();
            evi.setFilter(filter);
        }
        return evi;
    }

    private void installListener() {
        MyListener listener = new MyListener();
        this.chkCpBasicMsg.addActionListener((ActionListener)listener);
        this.bizSourceAcount.addDataChangeListener((DataChangeListener)listener);
    }

    private UserType getSourceUserType() {
        UserInfo userInfo = (UserInfo)this.bizSourceAcount.getData();
        if (userInfo != null) {
            return userInfo.getType();
        }
        return UserType.PERSON;
    }

    private void setTargetFilter(UserType type) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo fi = null;
        fi = UserType.SYSTEM.equals((Object)type) ? new FilterItemInfo("type", (Object)new Integer(10), CompareType.EQUALS) : new FilterItemInfo("type", (Object)new Integer(10), CompareType.NOTEQUALS);
        filter.getFilterItems().add(fi);
        try {
            filter.mergeFilter(this.getAuAdminFilter(), "and");
            filter.mergeFilter(this.getBizUserFilter(), "and");
        }
        catch (BOSException be) {
            this.handleException((Exception)((Object)be));
        }
        catch (EASBizException ee) {
            this.handleException((Exception)((Object)ee));
        }
        catch (ParserException pe) {
            this.handleException((Exception)((Object)pe));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.bizTgtAccount.setData(null);
        this.bizTgtAccount.setEntityViewInfo(evi);
    }

    private void enableFunction(UserType type) {
        UserInfo userInfo = (UserInfo)this.bizSourceAcount.getData();
        if (userInfo == null) {
            return;
        }
        boolean isBizAdmin = userInfo.isBizAdmin();
        if (UserType.SYSTEM.equals((Object)type)) {
            this.chkCpCURange.setEnabled(true);
            this.chkCpAdminRange.setEnabled(false);
            this.chkCpBizRange.setEnabled(false);
            this.chkCpPerm.setEnabled(false);
        } else if (isBizAdmin) {
            this.chkCpCURange.setEnabled(true);
            this.chkCpAdminRange.setEnabled(true);
            this.chkCpBizRange.setEnabled(true);
            this.chkCpPerm.setEnabled(true);
        } else {
            this.chkCpCURange.setEnabled(false);
            this.chkCpAdminRange.setEnabled(true);
            this.chkCpBizRange.setEnabled(true);
            this.chkCpPerm.setEnabled(true);
        }
    }

    private void updateUserRealName(KDBizPromptBox pmtUserRelation, UserType userType) {
        try {
            pmtUserRelation.setRequired(true);
            this.kDLabelContainer3.setBoundEditor((JComponent)pmtUserRelation);
            pmtUserRelation.setEditFormat("$name$");
            pmtUserRelation.setDisplayFormat("$name$");
            pmtUserRelation.setCommitFormat("$name$");
            pmtUserRelation.setVisible(true);
            pmtUserRelation.setEditable(true);
            this.mlbUserRealName.setVisible(false);
            if (UserType.OTHER.equals((Object)userType) || Administrator.isAdminType(userType)) {
                pmtUserRelation.setVisible(false);
                boolean isSlted = this.chkCpBasicMsg.isSelected();
                this.mlbUserRealName.setVisible(true);
                if (isSlted) {
                    this.mlbUserRealName.setEnabled(true);
                } else {
                    this.mlbUserRealName.setEnabled(false);
                }
                LanguageInfo languageInfo = new LanguageInfo(SysContext.getSysContext().getLocale());
                this.mlbUserRealName.setSelectedLanguage(languageInfo);
                this.mlbUserRealName.setRequired(true);
                this.kDLabelContainer3.setBoundEditor((JComponent)this.mlbUserRealName);
            } else {
                try {
                    AbstractUserType iUserType = UserTypeFactory.getUserType(userType);
                    iUserType.setSelector(pmtUserRelation, this.getCurrentSelectCtrlUnit(), (Component)((Object)this));
                }
                catch (UserException ue) {
                    logger.error((Object)"user type not exist", (Throwable)((Object)ue));
                    UserTypeFactory.getDefaultUserType().setSelector(pmtUserRelation, null, (Component)((Object)this));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException(e);
        }
    }

    private void updateUIByCheck(boolean isAddUser) {
        if (isAddUser) {
            this.checkedAddUser();
        } else {
            this.uncheckAddUser();
        }
    }

    private void checkedAddUser() {
        this.bizTgtAccount.setVisible(false);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.txtTgtAccount);
        this.txtTgtAccount.setVisible(true);
        this.txtTgtAccount.setRequired(true);
        this.bizTgtAccount.setRequired(false);
        this.bizUserName.setEnabled(true);
        this.txtPsd.setEnabled(true);
        this.txtConfirmPsd.setEnabled(true);
        this.mlbUserRealName.setEnabled(true);
        this.txtPhone.setEnabled(true);
        this.txtEmail.setEnabled(true);
    }

    private void uncheckAddUser() {
        this.txtTgtAccount.setVisible(false);
        this.bizTgtAccount.setVisible(true);
        this.bizTgtAccount.setRequired(true);
        this.txtTgtAccount.setRequired(false);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.bizTgtAccount);
        this.bizUserName.setEnabled(false);
        this.txtPsd.setEnabled(false);
        this.txtConfirmPsd.setEnabled(false);
        this.kDLabelContainer2.validate();
        this.mlbUserRealName.setEnabled(false);
        this.txtPhone.setEnabled(false);
        this.txtEmail.setEnabled(false);
    }

    @Override
    public void actionConfrim_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfrim_actionPerformed(e);
        if (this.verifyInput()) {
            if (PermissionHelper.isAuthenticateAdminEnabled() && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"MULTI_PROMPTS")) == 2) {
                SysUtil.abort();
            }
            if (this.isCopyPerm() && this.getTargetUserInfo() != null) {
                PermissionHelper.alertNeedAuthen((Component)((Object)this), this.getTargetUserInfo().getNumber());
            }
            String res = this.submit(this.getUserDataTransferInfo());
            BigMsgBox.showInfo((StringBuffer)new StringBuffer(PermissionResUtil.getResource("res_103") + "\n" + res));
        }
    }

    private boolean isCopyPerm() {
        return this.chkCpPerm.isSelected();
    }

    private UserInfo getTargetUserInfo() {
        return (UserInfo)this.bizTgtAccount.getData();
    }

    private UserDataTransferInfo getUserDataTransferInfo() {
        UserDataTransferInfo info = new UserDataTransferInfo();
        info.setAddUser(this.chkCpBasicMsg.isSelected());
        info.setAddUserAccount(this.txtTgtAccount.getText());
        info.setCpAdminOrgRange(this.chkCpAdminRange.isSelected());
        info.setCpBizOrgRange(this.chkCpBizRange.isSelected());
        info.setCpCuOrgRange(this.chkCpCURange.isSelected());
        info.setCpPerm(this.chkCpPerm.isSelected());
        info.setSourceUserInfo(this.getSourceUserInfo());
        info.setTgtUserInfo(this.getTgtUserInfo());
        info.setUserRealName(this.bizUserName.getData());
        info.setCell(this.txtPhone.getText());
        info.setEmail(this.txtEmail.getText());
        String password = new String(this.txtPsd.getPassword());
        try {
            password = CryptoTean.encrypt((String)info.getAddUserAccount(), (String)password);
        }
        catch (CryptException e) {
            this.handUIException(e);
        }
        info.setUserPsd(password);
        if (info.isAddUser()) {
            LanguageInfo lInfo = null;
            List list = MultiLangList.getLanguageList();
            for (int i = 0; i < list.size(); ++i) {
                lInfo = (LanguageInfo)list.get(i);
                info.setUserStrNameHash(lInfo.getLocale(), (String)this.mlbUserRealName.getItemDataByLang(lInfo));
            }
        }
        return info;
    }

    private UserInfo getSourceUserInfo() {
        return (UserInfo)this.bizSourceAcount.getData();
    }

    private UserInfo getTgtUserInfo() {
        return (UserInfo)this.bizTgtAccount.getData();
    }

    private String submit(UserDataTransferInfo info) throws Exception {
        String str = "";
        try {
            IUserDataTransferFacade udtf = UserDataTransferFacadeFactory.getRemoteInstance();
            str = udtf.transferData(info);
        }
        catch (PermissionServiceException e) {
            MsgBox.showInfo((String)e.getMessage());
            SysUtil.abort();
        }
        return str;
    }

    private boolean verifyInput() throws Exception {
        if (this.bizSourceAcount.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_104"));
            return false;
        }
        if (this.chkCpBasicMsg.isSelected()) {
            if (StringUtils.isEmpty((String)this.txtTgtAccount.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_105"));
                return false;
            }
            UserInfo sourceUser = (UserInfo)this.bizSourceAcount.getData();
            if (sourceUser.getType().equals((Object)UserType.SYSTEM) || sourceUser.getType().equals((Object)UserType.OTHER)) {
                if (this.mlbUserRealName.getSelectedItem() == null || StringUtils.isEmpty((String)this.mlbUserRealName.getSelectedItemData().toString())) {
                    MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_106"));
                    return false;
                }
            } else if (this.bizUserName.getData() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_106"));
                return false;
            }
            if (!this.txtPsd.getText().equals(this.txtConfirmPsd.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_107"));
                return false;
            }
        } else {
            if (this.bizTgtAccount.getData() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_108"));
                return false;
            }
            UserInfo sourceUserInfo = (UserInfo)this.bizSourceAcount.getData();
            UserInfo tgtUserInfo = (UserInfo)this.bizTgtAccount.getData();
            if (sourceUserInfo.getId().equals((Object)tgtUserInfo.getId())) {
                MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_109"));
                return false;
            }
        }
        if (!(this.chkCpAdminRange.isSelected() || this.chkCpBasicMsg.isSelected() || this.chkCpBizRange.isSelected() || this.chkCpCURange.isSelected() || this.chkCpPerm.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)PermissionResUtil.getResource("res_110"));
            return false;
        }
        if (this.isRegister && this.chkCpBasicMsg.isSelected()) {
            logger.error((Object)"verifyInput 1111===");
            CommunicationInfo info = new CommunicationInfo();
            info.setEmail(this.txtEmail.getText());
            info.setPhone(this.txtPhone.getText());
            logger.error((Object)"verifyInput 222===");
            ValidateComResultInfo resultInfo = ValidateCommunicationFactory.getRemoteInstance().ValidateCommunication(null, info);
            logger.error((Object)("verifyInput resultInfo===" + resultInfo));
            if (resultInfo != null) {
                logger.error((Object)("verifyInput resultInfo.isSuccess()===" + resultInfo.isSuccess()));
            }
            if (resultInfo != null && !resultInfo.isSuccess()) {
                logger.error((Object)"verifyInput 333===");
                throw new UserException(new NumericExceptionSubItem(resultInfo.getOprCode(), resultInfo.getOprMsg()));
            }
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private CtrlUnitInfo getCurrentSelectCtrlUnit() {
        CtrlUnitInfo ctrlInfo = null;
        if (ctrlInfo == null) {
            ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        return ctrlInfo;
    }

    private String getCurrentOrgRange() {
        return this.getCurrentSelectCtrlUnit().getId().toString();
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    @Override
    protected void bizUserName1_dataChanged(DataChangeEvent e) throws Exception {
        LowTimer lowTime = new LowTimer();
        if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue())) {
            PersonInfo selectPerson = (PersonInfo)e.getNewValue();
            try {
                selectPerson = ((IUser)this.getBizInterface()).getPersonWithContact(selectPerson);
            }
            catch (Throwable t) {
                logger.error((Object)"", t);
            }
            this.synTouchInfo(selectPerson);
        }
        logger.info((Object)("begin getAdmin org:" + lowTime.msValue()));
    }

    private void synTouchInfo(PersonInfo personInfo) {
        this.txtPhone.setText(personInfo.getCell());
        this.txtEmail.setText(personInfo.getEmail());
    }

    public ICoreBase getBizInterface() throws BOSException {
        return UserFactory.getRemoteInstance();
    }

    private class MyListener
    implements ActionListener,
    DataChangeListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isSlted = UserDataTransferUI.this.chkCpBasicMsg.isSelected();
            UserDataTransferUI.this.updateUIByCheck(isSlted);
        }

        public void dataChanged(DataChangeEvent eventObj) {
            UserType type = UserDataTransferUI.this.getSourceUserType();
            UserDataTransferUI.this.updateUserRealName(UserDataTransferUI.this.bizUserName, type);
            UserDataTransferUI.this.enableFunction(type);
            UserDataTransferUI.this.setTargetFilter(type);
        }
    }
}

