/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserOrgRoleRelationFilterUI;
import com.kingdee.eas.base.permission.client.helper.PermissionOrgF7Factory;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OUUnionF7;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class UserOrgRoleRelationFilterUI
extends AbstractUserOrgRoleRelationFilterUI {
    private static final Logger logger = Logger.getLogger(UserOrgRoleRelationFilterUI.class);
    private static final String USER_ID = "userId.id";
    private static final String ORG_ID = "orgId.id";
    private static final String ROLE_ID = "roleId.id";
    protected Object ui = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionUIResource";

    public UserOrgRoleRelationFilterUI() throws Exception {
    }

    public UserOrgRoleRelationFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            this.initUser();
            this.initOrgUnit();
            this.initRole();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void initRole() throws Exception {
        this.prmtRole.setQueryInfo("com.kingdee.eas.base.permission.app.RoleQuery");
        this.prmtRole.setDisplayFormat("$name$");
        this.prmtRole.setEditFormat("$number$");
        this.prmtRole.setEditable(true);
        this.prmtRole.setCommitFormat("$number$");
        this.prmtRole.setData(null);
    }

    protected void initUser() throws Exception {
        this.prmtUser.setQueryInfo("com.kingdee.eas.base.permission.app.UserListQuery");
        this.prmtUser.setDisplayFormat("$name$");
        this.prmtUser.setEditFormat("$number$");
        this.prmtUser.setEditable(true);
        this.prmtUser.setCommitFormat("$number$");
        this.prmtUser.setData(null);
    }

    protected void initOrgUnit() throws Exception {
        IObjectPK currentUserPK = ToolUtils.getCurrentUserPK();
        List bizUserCUOrgRange = PermissionRangeHelper.getBizUserCUOrgRange(null, currentUserPK);
        boolean isAdmin = Administrator.isCUAdmin(null, currentUserPK);
        OUUnionF7 orgF7 = PermissionOrgF7Factory.getOUUnionF7((IUIObject)this, new HashSet(), false, "00000000-0000-0000-0000-000000000000CCE7AED4", bizUserCUOrgRange, isAdmin, bizUserCUOrgRange);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setCommitFormat("$number$");
        this.prmtOrgUnit.setEditable(true);
        orgF7.setMultiSelect(false);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
        this.prmtOrgUnit.setData(null);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo fInfo = new FilterInfo();
        Object ob = null;
        if (this.prmtUser.getData() != null) {
            ob = this.prmtUser.getData();
            UserInfo selectedUserInfo = new UserInfo();
            if (ob instanceof UserInfo) {
                selectedUserInfo = (UserInfo)this.prmtUser.getData();
            }
            fInfo.getFilterItems().add(new FilterItemInfo(USER_ID, (Object)selectedUserInfo.getId(), CompareType.EQUALS));
        }
        if (this.prmtOrgUnit.getData() != null) {
            ob = this.prmtOrgUnit.getData();
            FullOrgUnitInfo org = new FullOrgUnitInfo();
            if (ob instanceof FullOrgUnitInfo) {
                org = (FullOrgUnitInfo)ob;
            }
            fInfo.getFilterItems().add(new FilterItemInfo(ORG_ID, (Object)org.getId(), CompareType.EQUALS));
        }
        if (this.prmtRole.getData() != null) {
            ob = this.prmtRole.getData();
            RoleInfo roleInfo = new RoleInfo();
            if (ob instanceof RoleInfo) {
                roleInfo = (RoleInfo)this.prmtRole.getData();
            }
            fInfo.getFilterItems().add(new FilterItemInfo(ROLE_ID, (Object)roleInfo.getId(), CompareType.EQUALS));
        }
        return fInfo;
    }

    public void clear() {
        try {
            this.prmtOrgUnit.setData(null);
            this.prmtUser.setData(null);
            this.prmtRole.setData(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void loadData(EntityViewInfo v) {
        try {
            this.onLoad();
            super.loadData(v);
            FilterInfo filter = v.getFilter();
            FilterItemCollection itemCol = filter == null ? new FilterItemCollection() : filter.getFilterItems();
            for (int i = itemCol.size() - 1; i >= 0; --i) {
                FilterItemInfo itemInfo = itemCol.get(i);
                String prop = itemInfo.getPropertyName();
                String compareValue = itemInfo.getCompareValue().toString();
                ObjectStringPK pk = new ObjectStringPK(compareValue);
                if (USER_ID.equals(prop)) {
                    UserInfo user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)pk, this.getSelector());
                    this.prmtUser.setData((Object)user);
                    continue;
                }
                if (ORG_ID.equals(prop)) {
                    FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk, this.getSelector());
                    orgInfo.setNumber(compareValue);
                    this.prmtOrgUnit.setData((Object)orgInfo);
                    continue;
                }
                if (!ROLE_ID.equals(prop)) continue;
                RoleInfo roleInfo = RoleFactory.getRemoteInstance().getRoleInfo((IObjectPK)pk, this.getSelector());
                roleInfo.setNumber(compareValue);
                this.prmtRole.setData((Object)roleInfo);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("name"));
        col.add(new SelectorItemInfo("number"));
        return col;
    }
}

