/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.InheritPermFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractUserSubOrgUI;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class UserSubOrgUI
extends AbstractUserSubOrgUI {
    private static final Logger logger = CoreUIObject.getLogger(UserSubOrgUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    public static final String USERS = "USERS";
    public static final String ORGPK = "ORGPK";
    public static final String ROLEPK = "ROLEPK";
    public static final String PERMCHANGEID = "permChangeId";
    private static final String USER_NAME = "userName";
    private static final String USER_NUMBER = "userNumber";
    private static final String ORG_NUMBER = "org.number";
    private static final String ORG_NAME = "org.name";
    private static final String USER_ID = "id";
    private UserInfo[] users = null;
    private IObjectPK selectedUserPK = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initUserTable();
    }

    private void initUI() {
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnRemove.setVisible(false);
        this.kDLabel1.setText(EASResource.getString((String)RESOURCE, (String)"SelectedUser"));
        this.kDLabel2.setText(EASResource.getString((String)RESOURCE, (String)"SelectedSubOrg"));
        this.setUITitle(EASResource.getString((String)RESOURCE, (String)"AddUserRoleForSubOrg"));
    }

    private IObjectPK getSelectedUserPK() {
        if (this.getUsers() == null || this.getUsers().length < 1) {
            return null;
        }
        if (this.selectedUserPK == null) {
            return new ObjectUuidPK(this.getUsers()[0].getId());
        }
        return this.selectedUserPK;
    }

    private void initUserTable() {
        if (this.getUsers() == null) {
            return;
        }
        for (int i = 0; i < this.getUsers().length; ++i) {
            UserInfo user = this.getUsers()[i];
            IRow row = this.kdtUser.addRow();
            row.getCell(USER_NAME).setValue((Object)user.getName());
            row.getCell(USER_NUMBER).setValue((Object)user.getNumber());
            row.getCell(USER_ID).setValue((Object)user.getId());
        }
        this.kdtUser.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                UserSubOrgUI.this.kdtUser_activeCellChanged(e);
            }
        });
    }

    protected void kdtUser_activeCellChanged(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtUser.getRow(rowIndex);
        if (rowIndex >= 0 && row != null) {
            this.selectedUserPK = new ObjectStringPK(row.getCell(USER_ID).getValue().toString());
            try {
                this.mainQuery = new EntityViewInfo();
                this.mainQuery.setFilter(this.getDefaultFilterForQuery());
                this.execQuery();
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String longNumber;
        FilterInfo defaultFilter = super.getDefaultFilterForQuery();
        IObjectPK orgPK = this.getCurrentOrgPK();
        try {
            longNumber = this.getOrgInfo(orgPK).getLongNumber();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            longNumber = null;
        }
        IObjectPK userPK = this.getSelectedUserPK();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo subFilterItem = new FilterItemInfo("org.longNumber", (Object)(longNumber + "!%"), CompareType.LIKE);
        FilterItemInfo userFilterItem = new FilterItemInfo("user.id", (Object)userPK);
        FilterItemInfo typeFilterItem = new FilterItemInfo("type", (Object)String.valueOf(10));
        filter.getFilterItems().add(subFilterItem);
        filter.getFilterItems().add(typeFilterItem);
        filter.getFilterItems().add(userFilterItem);
        if (defaultFilter == null || defaultFilter.getFilterItems().size() == 0) {
            return filter;
        }
        try {
            defaultFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return defaultFilter;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("org.longNumber"));
        ev.setSorter(sortCol);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (e.getClickCount() == 1 && rowIndex < 0) {
            super.tblMain_tableClicked(e);
        }
    }

    private FullOrgUnitInfo getOrgInfo(IObjectPK orgPK) throws Exception {
        return FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo(orgPK);
    }

    private UserInfo[] getUsers() {
        if (this.users == null) {
            Object[] objects = (Object[])this.getUIContext().get(USERS);
            this.users = new UserInfo[objects.length];
            for (int i = 0; i < this.users.length; ++i) {
                this.users[i] = (UserInfo)objects[i];
            }
        }
        return this.users;
    }

    private IObjectPK getCurrentOrgPK() {
        return (IObjectPK)this.getUIContext().get(ORGPK);
    }

    private IObjectPK getRolePK() {
        return (IObjectPK)this.getUIContext().get(ROLEPK);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected String getKeyFieldName() {
        return "org.id";
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> userCol = new HashSet<String>();
        for (int i = 0; i < this.getUsers().length; ++i) {
            userCol.add(this.getUsers()[i].getId().toString());
        }
        InheritPermFacadeFactory.getRemoteInstance().addUsersSubOrgRole(userCol, this.getCurrentOrgPK(), this.getRolePK());
        this.getUIWindow().close();
    }

    @Override
    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{ORG_NUMBER, ORG_NAME};
        return locateNames;
    }
}

