/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.discreteImpl.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.client.discreteImpl.DiscreteDataFetch;
import com.kingdee.eas.base.permission.client.discreteImpl.DiscreteViewPermissionHelper;
import com.kingdee.eas.base.permission.client.discreteImpl.impl.AbstractDiscreteRptViewPerm;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import java.util.Map;
import org.apache.log4j.Logger;

public class DiscreteUserRptOldDataPerm
extends AbstractDiscreteRptViewPerm
implements DiscreteViewPermissionHelper {
    private static Logger logger = Logger.getLogger((String)DiscreteUserRptOldDataPerm.class.getName());

    @Override
    public void setUserQueryFilter(FilterInfo filterInfo, IObjectPK userPK) {
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ToolUtils.getCurrentCUPK().toString()));
    }

    @Override
    public void setF7FilterInfo(NewOrgViewF7PromptDialog orgF7, OrgType orgType, IObjectPK selectedUserPK) throws BOSException, EASBizException {
        orgF7.setCurrentCUID("00000000-0000-0000-0000-000000000000CCE7AED4");
        orgF7.setNeedAddOrgRange(false);
        String orgRangeSQL = PermissionRangeHelper.getUserOrgIdRangeSQL(null, selectedUserPK, OrgRangeType.BIZ_ORG_TYPE);
        StringBuffer extraTreeFilter = new StringBuffer();
        extraTreeFilter.append("\"BASEUNIT\"").append(".FID IN (").append(orgRangeSQL).append(")");
        orgF7.setExtraTreeFilters(extraTreeFilter.toString());
        StringBuffer outerFilter = new StringBuffer();
        outerFilter.append("unit.id in (").append(orgRangeSQL).append(")");
        try {
            orgF7.setOuterFilterInfo(new FilterInfo(outerFilter.toString()));
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public DiscretePermCollection getDiscretePermCollection(DiscretePermCollection discretPermCol, Map uiContext) {
        DiscreteDataFetch discreteDataFetch = (DiscreteDataFetch)uiContext.get(DiscreteDataFetch.class.getName());
        if (discreteDataFetch == null) {
            throw new IllegalArgumentException("old user rpt imp ,but discreteDataFetch is null!");
        }
        for (int colIndex = 0; colIndex < discretPermCol.size(); ++colIndex) {
            BOSUuid bosUUId;
            DiscretePermInfo discretePermInfo = discretPermCol.get(colIndex);
            if (discretePermInfo == null || (bosUUId = discretePermInfo.getBizDataID()) == null) continue;
            logger.info((Object)("getOrgType : bosUUid is:" + bosUUId.toString()));
            OrgType orgType = null;
            if (discreteDataFetch != null) {
                orgType = discreteDataFetch.getBizDataOrgType((IObjectPK)new ObjectStringPK(bosUUId.toString()));
            }
            logger.info((Object)("orgType is:" + orgType));
            if (orgType == null) continue;
            PermItemInfo permItemInfo = (PermItemInfo)this.getAllRptPermItemInfoMap().get(orgType.toString());
            discretePermInfo.setPermItemInfo(permItemInfo);
            logger.info((Object)("permItemInfo be changed to :" + permItemInfo.getNumber()));
        }
        return discretPermCol;
    }
}

