/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoleHelper {
    private static Map cuOrgRangeListMap = new HashMap();
    private static Map cuOrgRangeSQLMap = new HashMap();
    private static Map manageOrgRangeListMap = new HashMap();
    private static Map manageOrgRangeSQLMap = new HashMap();

    private static String getCurrenUserId() {
        return ToolUtils.getCurrentUserPK().toString();
    }

    public static List getCUOrgRange() throws BOSException, EASBizException {
        List cuOrgRangeList = null;
        String userId = RoleHelper.getCurrenUserId();
        if (cuOrgRangeListMap.get(userId) != null) {
            cuOrgRangeList = (List)cuOrgRangeListMap.get(userId);
        } else {
            cuOrgRangeList = PermissionRangeHelper.getCUOrgRange(null);
            cuOrgRangeListMap.put(userId, cuOrgRangeList);
        }
        return cuOrgRangeList;
    }

    public static String getCUOrgRangeSQL() throws BOSException, EASBizException {
        String cuOrgRangeSQL = null;
        String userId = RoleHelper.getCurrenUserId();
        if (cuOrgRangeSQLMap.get(userId) != null) {
            cuOrgRangeSQL = (String)cuOrgRangeSQLMap.get(userId);
        } else {
            cuOrgRangeSQL = PermissionRangeHelper.getCUOrgRangeSQL(null);
            cuOrgRangeSQLMap.put(userId, cuOrgRangeSQL);
        }
        return cuOrgRangeSQL;
    }

    public static RoleCollection getAuthorizedRoles() throws EASBizException, BOSException {
        IRole role = RoleFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo cuFilter = new FilterInfo();
        cuFilter.getFilterItems().add(new FilterItemInfo("CU.id in (" + RoleHelper.getCUOrgRangeSQL() + ")"));
        cuFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        cuFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        cuFilter.setMaskString("#0 OR #1 OR #2");
        entityViewInfo.setFilter(cuFilter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        return role.getRoleCollection(entityViewInfo);
    }

    public static String getManageOrgRangeList() throws EASBizException, BOSException, Exception {
        String manageOrgRangeList = "''";
        UserInfo curUserInfo = ToolUtils.getCurrentUser();
        String userId = curUserInfo.getId().toString();
        if (manageOrgRangeListMap.get(userId) != null) {
            manageOrgRangeList = (String)manageOrgRangeListMap.get(userId);
        } else {
            OrgRangeType orgRangeType = null;
            if (Administrator.isAdminType(curUserInfo.getType())) {
                orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
            } else if (curUserInfo.isBizAdmin()) {
                orgRangeType = OrgRangeType.MANAGE_ORG_TYPE;
            }
            if (orgRangeType == null) {
                return manageOrgRangeList;
            }
            List rangeIdList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType(ToolUtils.getCurrentUserPK(), orgRangeType);
            manageOrgRangeList = ToolUtils.aryToStr(rangeIdList, false);
            if (Administrator.isAdminType(curUserInfo.getType())) {
                List list = PermissionUIHelper.getOrgStructureByCUList(manageOrgRangeList);
                String structOrgList = ToolUtils.aryToStr(list, false);
                List ouIdList = PermissionUIHelper.getSubOrgIds(manageOrgRangeList);
                String ouIdString = ToolUtils.aryToStr(ouIdList, false);
                manageOrgRangeList = ouIdString + "," + structOrgList;
            }
            manageOrgRangeListMap.put(userId, manageOrgRangeList);
        }
        return manageOrgRangeList;
    }

    public static String getManageOrgRangeSQL() throws EASBizException, BOSException, Exception {
        String manageOrgRangeSQL = "''";
        UserInfo curUserInfo = ToolUtils.getCurrentUser();
        String userId = curUserInfo.getId().toString();
        if (manageOrgRangeSQLMap.get(userId) != null) {
            manageOrgRangeSQL = (String)manageOrgRangeSQLMap.get(userId);
        } else {
            OrgRangeType orgRangeType = null;
            if (Administrator.isAdminType(curUserInfo.getType())) {
                orgRangeType = OrgRangeType.BIZ_ORG_TYPE;
            } else if (curUserInfo.isBizAdmin()) {
                orgRangeType = OrgRangeType.MANAGE_ORG_TYPE;
            }
            if (orgRangeType == null) {
                return manageOrgRangeSQL;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select forgid from t_pm_orgrange where fuserid = '").append(userId).append("'");
            if (orgRangeType != null) {
                sb.append(" and ftype = ").append(orgRangeType.getValue());
            }
            manageOrgRangeSQL = sb.toString();
            if (Administrator.isAdminType(curUserInfo.getType())) {
                String structOrgSQL = PermissionUIHelper.getOrgStructureByCUSQL(manageOrgRangeSQL);
                String ouIdSQL = PermissionUIHelper.getSubOrgIdsBySQL(manageOrgRangeSQL);
                manageOrgRangeSQL = ouIdSQL + " union " + structOrgSQL;
            }
            manageOrgRangeSQLMap.put(userId, manageOrgRangeSQL);
        }
        return manageOrgRangeSQL;
    }
}

