/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.client.helper.UnionOrgHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;

public class UserOrgRangeViewHelper {
    private static final int DEFAULT_ORG_COL = 4;

    public static void setUserOrgRangeView(CoreUI coreUI, KDTable tblBizOrgRange, KDTable tblAdminOrgRange, KDTable tblManageOrgRange, OrgRangeCollection orgRanges, UserInfo userInfo, String opr) throws BOSException {
        UnionOrgHelper unionOrgHelper = new UnionOrgHelper();
        unionOrgHelper.init(orgRanges);
        int size = orgRanges.size();
        for (int i = 0; i < size; ++i) {
            OrgRangeInfo orgRangeInfo = orgRanges.get(i);
            if (OrgRangeType.BIZ_ORG_TYPE.equals((Object)orgRangeInfo.getType())) {
                IRow row = UserOrgRangeViewHelper.bindOrgInfo(orgRangeInfo, tblBizOrgRange.addRow());
                row.getCell("orgName").setValue((Object)(orgRangeInfo.getOrg().getName() + unionOrgHelper.getDateViewByOrgId(orgRangeInfo.getOrg())));
                boolean flag = PermissionUIHelper.isCanBeDefOrg(orgRangeInfo.getOrg());
                if (!flag) {
                    row.getCell("isDefOrg").getStyleAttributes().setBackground(coreUI.getBackground());
                }
                if (flag && !OprtState.VIEW.equals(opr)) {
                    row.getCell("isDefOrg").getStyleAttributes().setLocked(false);
                }
                if (userInfo.getDefOrgUnit() != null) {
                    row.getCell("isDefOrg").setValue((Object)userInfo.getDefOrgUnit().getId().equals((Object)orgRangeInfo.getOrg().getId()));
                    continue;
                }
                row.getCell("isDefOrg").setValue((Object)Boolean.FALSE);
                continue;
            }
            if (OrgRangeType.ADMIN_ORG_TYPE.equals((Object)orgRangeInfo.getType())) {
                tblAdminOrgRange.getStyleAttributes().setLocked(true);
                IRow newRow = tblAdminOrgRange.addRow();
                UserOrgRangeViewHelper.bindOrgInfo(orgRangeInfo, newRow);
                continue;
            }
            if (!OrgRangeType.MANAGE_ORG_TYPE.equals((Object)orgRangeInfo.getType()) || tblManageOrgRange == null) continue;
            tblManageOrgRange.getStyleAttributes().setLocked(true);
            UserOrgRangeViewHelper.bindOrgInfo(orgRangeInfo, tblManageOrgRange.addRow());
        }
    }

    private static IRow bindOrgInfo(OrgRangeInfo orgRangeInfo, IRow row) {
        row.getCell("id").setValue((Object)orgRangeInfo.getId());
        row.getCell("org").setValue((Object)orgRangeInfo.getOrg());
        row.getCell("orgNumber").setValue((Object)orgRangeInfo.getOrg().getNumber());
        row.getCell("orgName").setValue((Object)orgRangeInfo.getOrg().getName());
        return row;
    }

    public static int setValue(KDTable tblBizOrgRange, KDTEditEvent e, int defOrgColumn) {
        int rowIndex = e.getRowIndex();
        if (e.getColIndex() == defOrgColumn) {
            boolean newValue = (Boolean)e.getValue();
            if (newValue) {
                int size = tblBizOrgRange.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (i == rowIndex) continue;
                    tblBizOrgRange.getRow(i).getCell(defOrgColumn).setValue((Object)Boolean.FALSE);
                }
            } else {
                rowIndex = -1;
            }
        }
        return rowIndex;
    }

    public static String getDefOrgId(KDTable tblBizOrgRange, int defOrgColumn) {
        FullOrgUnitInfo org = UserOrgRangeViewHelper.getDefOrg(tblBizOrgRange);
        if (org != null) {
            return org.getId().toString();
        }
        return null;
    }

    public static FullOrgUnitInfo getDefOrg(KDTable tblBizOrgRange) {
        int size = tblBizOrgRange.getRowCount();
        for (int i = 0; i < size; ++i) {
            Boolean isDef;
            Object obj = tblBizOrgRange.getRow(i).getCell(4).getValue();
            if (obj == null || !(isDef = (Boolean)obj).booleanValue()) continue;
            Object orgObj = tblBizOrgRange.getRow(i).getCell("org").getValue();
            return (FullOrgUnitInfo)orgObj;
        }
        return null;
    }
}

