/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.menusync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.permission.metadata.DependenceCollection;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.utils.XMLStoreHelper;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.util.StringUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class PermissionWriter {
    private static Logger logger = Logger.getLogger((String)PermissionWriter.class.getName());
    private KDTreeNode treeNode;

    public PermissionWriter(KDTreeNode treeNode) {
        this.treeNode = treeNode;
    }

    public void writerLocalFile(String fileName) throws IOException, DataAccessException {
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = System.getProperty("user.home") + File.separator + "my.permission";
        }
        if (this.treeNode == null) {
            return;
        }
        logger.info((Object)("......... begin writer file: fileName is:" + fileName));
        DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(fileName)));
        PermissionInfo permissionInfo = new PermissionInfo();
        Enumeration permEnum = this.treeNode.depthFirstEnumeration();
        while (permEnum.hasMoreElements()) {
            KDTreeNode permTreeNode = (KDTreeNode)permEnum.nextElement();
            if (permTreeNode == null || !(permTreeNode.getUserObject() instanceof PermissionItemInfo)) continue;
            PermissionItemInfo permItemInfo = (PermissionItemInfo)permTreeNode.getUserObject();
            permissionInfo.getPermissionItems().add(permItemInfo);
        }
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)System.getProperty("user.home"));
        XMLStoreHelper xmlStoreHelper = new XMLStoreHelper(ctx);
        xmlStoreHelper.setBosType(MetaDataTypeList.PERMISSION);
        permissionInfo.setName("allCustom");
        MutilLangeToolForParam.muti2Obj((String)"allCustom", (IObjectValue)permissionInfo, (String)"alias");
        xmlStoreHelper.store((IObjectValue)permissionInfo, (OutputStream)out);
        logger.info((Object)"......... begin writer file over!");
        out.close();
    }

    public void writer(String fileName, DependenceCollection dependenceCol) throws IOException, BOSException, EASBizException {
        PermissionInfo permissionInfo = new PermissionInfo();
        Enumeration permEnum = this.treeNode.depthFirstEnumeration();
        while (permEnum.hasMoreElements()) {
            DefaultKingdeeTreeNode permTreeNode = (DefaultKingdeeTreeNode)permEnum.nextElement();
            if (permTreeNode == null || !(permTreeNode.getUserObject() instanceof PermissionItemInfo)) continue;
            PermissionItemInfo permItemInfo = (PermissionItemInfo)permTreeNode.getUserObject();
            permissionInfo.getPermissionItems().add(permItemInfo);
        }
        if (logger.isDebugEnabled()) {
            this.doCheckPerm(permissionInfo);
        }
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        if (dependenceCol != null && !dependenceCol.isEmpty()) {
            permissionInfo.getDependences().clear();
            permissionInfo.getDependences().addObjectCollection((IObjectCollection)dependenceCol);
        }
        iPermItem.saveCustomPermItem(permissionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckPerm(PermissionInfo permissionInfo) {
        OutputStreamWriter fileOut = null;
        try {
            if (permissionInfo == null || permissionInfo.getPermissionItems().isEmpty()) {
                return;
            }
            File file = new File("c:" + File.separator + "checkPermRes.txt");
            fileOut = new FileWriter(file);
            PermissionItemCollection permissionCol = permissionInfo.getPermissionItems();
            int count = 0;
            int size = permissionCol.size();
            for (int i = 0; i < size; ++i) {
                PermissionItemInfo permItem = permissionCol.get(i);
                if (!this.notRightPerm(permItem)) continue;
                ArrayList<String> strList = new ArrayList<String>();
                strList.add(permItem.getName());
                strList.add(permItem.getAlias());
                strList.add(permItem.getGroup());
                fileOut.write(ToolUtils.aryToStr(strList, false) + "\r\n");
                if (count % 100 == 0) {
                    fileOut.flush();
                }
                ++count;
            }
            fileOut.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean notRightPerm(PermissionItemInfo permItem) {
        String groupStr = permItem.getGroup();
        if (groupStr.endsWith(".")) {
            groupStr = groupStr.substring(0, groupStr.length() - 1);
        }
        if (permItem != null && !StringUtils.isEmpty((String)groupStr)) {
            int lastCharPos = groupStr.lastIndexOf(".");
            String firstChar = groupStr.substring(lastCharPos + 1, lastCharPos + 2);
            try {
                Integer.parseInt(firstChar);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }
}

