/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.quickperm;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.eas.base.permission.client.IPopMenuSourceUI;
import com.kingdee.eas.base.permission.client.quickperm.IPopMenuPerform;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuConfigInfo;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuPerformContext;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuPerformFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class PopMenuHelper {
    private static Logger logger = Logger.getLogger(PopMenuHelper.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private KDTree sourceTree;
    private MouseListener mouseListener = null;
    IPopMenuPerform iPopMenu = null;
    KDPopupMenu popMenu = null;
    private Set needCtrlPermNumberSet = null;
    private IPopMenuSourceUI sourceUI = null;

    public PopMenuHelper(IPopMenuSourceUI sourceUI, KDTree tree) {
        this.sourceUI = sourceUI;
        this.sourceTree = tree;
    }

    public void dealPopMenu(PopMenuPerformContext ctx) {
        this.iPopMenu = PopMenuPerformFactory.getPopMenuImpl(ctx);
        this.initMenu(ctx);
        if (this.isNeedPopMenu(ctx.getTreeSelectEvent())) {
            this.addPopMenu();
        } else {
            this.clearPopMenu();
        }
    }

    private void initMenu(PopMenuPerformContext ctx) {
        KDMenuItem menuItem = new KDMenuItem(this.iPopMenu.getViewName());
        this.iPopMenu.setPrepareContext(ctx);
        PopMenuItemListener myPopLis = new PopMenuItemListener();
        myPopLis.setCtx(ctx);
        menuItem.addActionListener((ActionListener)myPopLis);
        this.popMenu = new KDPopupMenu();
        this.popMenu.add((JMenuItem)menuItem);
    }

    private void clearPopMenu() {
        if (this.mouseListener != null) {
            this.sourceTree.removeMouseListener(this.mouseListener);
        }
    }

    private void addPopMenu() {
        this.clearPopMenu();
        if (this.mouseListener == null) {
            this.mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.popMenu(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.popMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.popMenu(e);
                }

                private void popMenu(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        PopMenuHelper.this.popMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
        }
        this.sourceTree.addMouseListener(this.mouseListener);
    }

    private boolean isNeedPopMenu(TreeSelectionEvent e) {
        if (this.needCtrlPermNumberSet == null) {
            this.initNeedCtrlPerm();
        }
        return this.needCtrlPermNumberSet.contains(this.iPopMenu.getPermItemId());
    }

    private void initNeedCtrlPerm() {
        this.needCtrlPermNumberSet = PopMenuConfigInfo.getInstance().getAllKey();
    }

    private class PopMenuItemListener
    implements ActionListener {
        PopMenuPerformContext tempCtx = null;

        private PopMenuItemListener() {
        }

        public void setCtx(PopMenuPerformContext ctx) {
            this.tempCtx = ctx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (MsgBox.isOk((int)MsgBox.showConfirm2((String)EASResource.getString((String)PopMenuHelper.RESOURCE, (String)"please_save_data_first")))) {
                    PopMenuHelper.this.iPopMenu.action_perform(e);
                    if (PopMenuHelper.this.sourceUI != null && this.tempCtx.isModify()) {
                        PopMenuHelper.this.sourceUI.reloadUI();
                    }
                }
            }
            catch (Exception ae) {
                logger.error((Object)"", (Throwable)ae);
            }
        }
    }
}

