/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.quickperm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IRolePerm;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuConfigInfo;
import com.kingdee.eas.base.permission.client.quickperm.RuleProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class RolePermProxy {
    private static String PREFIX = " WHERE ";
    private static Logger logger = Logger.getLogger(RolePermProxy.class);

    public void saveRolePermRule(RolePermInfo rolePermInfo, RuleInfo ruleInfo) throws EASBizException, BOSException, ParserException {
        rolePermInfo.setRuleStructure(PREFIX + ruleInfo.getId().toString());
        rolePermInfo.setRuleExpr(PREFIX + "(" + RuleProxy.buildRuleExpr(ruleInfo.getBizObject(), ruleInfo.getScript()) + ")");
        rolePermInfo.setPermType(PermType.NORMAL);
        String permId = rolePermInfo.getPermItem().getId().toString();
        if (!PopMenuConfigInfo.getInstance().getAllKey4Batch().contains(permId)) {
            IRolePerm iRolePerm = RolePermFactory.getRemoteInstance();
            if (rolePermInfo.getId() == null) {
                iRolePerm.addnew(rolePermInfo);
            } else {
                iRolePerm.update((IObjectPK)new ObjectStringPK(rolePermInfo.getId().toString()), rolePermInfo);
            }
        } else {
            this.saveBatchSubNode(rolePermInfo, ruleInfo);
        }
    }

    private void saveBatchSubNode(RolePermInfo rolePermInfo, RuleInfo ruleInfo) throws EASBizException, BOSException {
        String permId = rolePermInfo.getPermItem().getId().toString();
        String subPermId = PopMenuConfigInfo.getInstance().getValueBatch(permId);
        if (StringUtils.isEmpty((String)subPermId)) {
            return;
        }
        String[] subPermIdAry = StringUtils.split((String)subPermId, (String)",");
        if (subPermIdAry == null || subPermIdAry.length == 0) {
            return;
        }
        int size = subPermIdAry.length;
        for (int i = 0; i < size; ++i) {
            this.saveBatchPerm(rolePermInfo, subPermIdAry[i]);
        }
    }

    private void saveBatchPerm(RolePermInfo rolePermInfo, String permItemId) throws EASBizException, BOSException {
        RolePermInfo tempRolePermInfo = null;
        try {
            tempRolePermInfo = (RolePermInfo)ObjectUtils.createCopy((Object)rolePermInfo);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("CloneNotSupportedException is fail!", (Throwable)e);
        }
        this.deletePermInfo(tempRolePermInfo.getRole().getId().toString(), permItemId);
        PermItemInfo permItemInfo = tempRolePermInfo.getPermItem();
        permItemInfo.setId(BOSUuid.read((String)permItemId));
        tempRolePermInfo.setId(BOSUuid.create((BOSObjectType)rolePermInfo.getBOSType()));
        this.savePermInfo(tempRolePermInfo);
    }

    private void savePermInfo(RolePermInfo tempRolePermInfo) throws BOSException, EASBizException {
        IRolePerm iRolePerm = RolePermFactory.getRemoteInstance();
        iRolePerm.saveSimpleRoleInfo(tempRolePermInfo);
    }

    private void deletePermInfo(String roleId, String permItemId) throws EASBizException, BOSException {
        IRolePerm iRolePerm = RolePermFactory.getRemoteInstance();
        iRolePerm.deleteSimpleInfo(permItemId, roleId);
    }
}

