/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.tree;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.client.tree.AbstractPermissionTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.util.ObjectUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractAccreditTreeBuilder
extends AbstractPermissionTreeBuilder
implements IAccreditTreeBuilder {
    @Override
    public void removeNodes(KDTree tree, KDTreeNode[] treeNodes) {
        assert (treeNodes != null);
        KDTreeNode root = (KDTreeNode)tree.getModel().getRoot();
        int length = treeNodes.length;
        for (int i = 0; i < length; ++i) {
            KDTreeNode foundNode = this.findNode(root, this.getPermItem(treeNodes[i]).getId());
            if (foundNode == null) continue;
            KDTreeNode parent = (KDTreeNode)foundNode.getParent();
            if (parent != null) {
                KDTreeNode removeNode = this.findNode(root, this.getPermItem(treeNodes[i]).getId());
                ((KingdeeTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)removeNode);
                while (parent != null && parent.getChildCount() == 0) {
                    KDTreeNode node = parent;
                    if ((parent = (KDTreeNode)node.getParent()) == null) continue;
                    removeNode = this.findNode(root, this.getPermItem(node).getId());
                    ((KingdeeTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)removeNode);
                }
                continue;
            }
            root = null;
            break;
        }
        if (root == null || root.getChildCount() == 0) {
            ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)root);
        }
    }

    private PermItemInfo getPermItem(KDTreeNode treeNode) {
        return this.getPermItem((IObjectValue)treeNode.getUserObject());
    }

    @Override
    public void addNodes(KDTree tree, KDTreeNode[] treeNodes, Set extendedNodes) throws CloneNotSupportedException {
        assert (tree != null && treeNodes != null);
        KDTreeNode root = (KDTreeNode)tree.getModel().getRoot();
        extendedNodes.addAll(this.getExpendedNodes(tree));
        int length = treeNodes.length;
        for (int i = 0; i < length; ++i) {
            KDTreeNode node = (KDTreeNode)ObjectUtils.createCopy((Object)treeNodes[i]);
            root = this.createRootForAdd(root, node);
        }
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)root);
        HashMap<BOSUuid, KDTreeNode> existPermItems = new HashMap<BOSUuid, KDTreeNode>();
        Enumeration enumTarget = ((KDTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            KDTreeNode nodeTarget = (KDTreeNode)enumTarget.nextElement();
            existPermItems.put(this.getPermItem(nodeTarget).getId(), nodeTarget);
        }
        for (KDTreeNode treeNode : extendedNodes) {
            BOSUuid permItemID = this.getPermItem(treeNode).getId();
            if (!existPermItems.containsKey(permItemID)) continue;
            TreePath treePath = new TreePath(((KDTreeNode)existPermItems.get(permItemID)).getPath());
            tree.expandPath(treePath);
        }
        BOSUuid selectedPermItemID = this.getPermItem(treeNodes[0]).getId();
        KDTreeNode selectedTreeNode = (KDTreeNode)existPermItems.get(selectedPermItemID);
        tree.setSelectionPath(new TreePath(selectedTreeNode.getPath()));
    }

    private KDTreeNode createRootForAdd(KDTreeNode root, KDTreeNode addNode) {
        PermItemInfo pIAdd;
        Map mapRoot = this.getNodeMap(root);
        if (mapRoot.containsKey((pIAdd = this.getPermItem(addNode)).getId())) {
            if (pIAdd.isIsLeaf()) {
                return root;
            }
            KDTreeNode node = (KDTreeNode)mapRoot.get(pIAdd.getId());
            this.mergeNode(addNode, mapRoot);
            root = (KDTreeNode)node.getRoot();
        } else {
            KDTreeNode parent = (KDTreeNode)addNode.getParent();
            if (parent == null) {
                root = addNode;
            } else {
                KDTreeNode parentInRoot = null;
                while (parent != null) {
                    this.removeExcludeChilds(parent, addNode);
                    PermItemInfo piParent = this.getPermItem(parent);
                    if (mapRoot.containsKey(piParent.getId())) {
                        parentInRoot = (KDTreeNode)mapRoot.get(piParent.getId());
                        parentInRoot.add((MutableTreeNode)addNode);
                        break;
                    }
                    addNode = parent;
                    parent = (KDTreeNode)addNode.getParent();
                }
                root = (KDTreeNode)addNode.getRoot();
            }
        }
        return root;
    }

    private void mergeNode(KDTreeNode addNode, Map mapRoot) {
        PermItemInfo piAdd = this.getPermItem(addNode);
        KDTreeNode nodeInRoot = (KDTreeNode)mapRoot.get(piAdd.getId());
        for (int i = addNode.getChildCount() - 1; i >= 0; --i) {
            KDTreeNode childAdd = (KDTreeNode)addNode.getChildAt(i);
            PermItemInfo piChildAdd = this.getPermItem(childAdd);
            if (piChildAdd.isIsLeaf()) {
                if (mapRoot.containsKey(piChildAdd.getId())) continue;
                nodeInRoot.add((MutableTreeNode)childAdd);
                continue;
            }
            if (mapRoot.containsKey(piChildAdd.getId())) {
                this.mergeNode(childAdd, mapRoot);
                continue;
            }
            nodeInRoot.add((MutableTreeNode)childAdd);
        }
    }

    private KDTreeNode findNode(KDTreeNode node, BOSUuid permItemID) {
        boolean isFound = false;
        if (node == null) {
            return null;
        }
        Enumeration enumTarget = node.breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            KDTreeNode nodeTarget = (KDTreeNode)enumTarget.nextElement();
            PermItemInfo piTarget = this.getPermItem(nodeTarget);
            if (!piTarget.getId().equals((Object)permItemID)) continue;
            isFound = true;
            return nodeTarget;
        }
        if (!isFound) {
            return this.findNode((KDTreeNode)node.getParent(), permItemID);
        }
        return null;
    }

    private void removeExcludeChilds(KDTreeNode parent, KDTreeNode leftChild) {
        assert (leftChild != null);
        PermItemInfo piLeftChild = this.getPermItem(leftChild);
        if (parent != null) {
            Enumeration childs = parent.children();
            HashSet<KDTreeNode> setRemove = new HashSet<KDTreeNode>();
            while (childs.hasMoreElements()) {
                KDTreeNode child = (KDTreeNode)childs.nextElement();
                PermItemInfo piChild = this.getPermItem(child);
                if (piLeftChild.getId().equals((Object)piChild.getId())) continue;
                setRemove.add(child);
            }
            for (KDTreeNode nodeRemove : setRemove) {
                parent.remove((MutableTreeNode)nodeRemove);
            }
        }
    }

    private Map getNodeMap(KDTreeNode node) {
        if (node == null) {
            return new HashMap();
        }
        HashMap<BOSUuid, KDTreeNode> mapTarget = new HashMap<BOSUuid, KDTreeNode>(4000);
        Enumeration enumTarget = node.breadthFirstEnumeration();
        while (enumTarget.hasMoreElements()) {
            KDTreeNode nodeTarget = (KDTreeNode)enumTarget.nextElement();
            PermItemInfo piTarget = this.getPermItem(nodeTarget);
            mapTarget.put(piTarget.getId(), nodeTarget);
        }
        return mapTarget;
    }

    @Override
    public Set getExpendedNodes(KDTree tree) {
        HashSet<KDTreeNode> setNode = new HashSet<KDTreeNode>();
        if (tree == null || tree.getModel() == null || tree.getModel().getRoot() == null) {
            return setNode;
        }
        Enumeration enumeration = ((KDTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            TreePath nodePath = new TreePath(node.getPath());
            if (!tree.isExpanded(nodePath)) continue;
            setNode.add(node);
        }
        return setNode;
    }

    @Override
    public void expand(KDTree tree, Set expendNodes) {
        HashMap<BOSUuid, KDTreeNode> existPermItems = new HashMap<BOSUuid, KDTreeNode>();
        if (tree == null || tree.getModel() == null || tree.getModel().getRoot() == null) {
            return;
        }
        Enumeration enumeration = ((KDTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            existPermItems.put(this.getPermItem(node).getId(), node);
        }
        for (KDTreeNode treeNode : expendNodes) {
            BOSUuid permItemID = this.getPermItem(treeNode).getId();
            if (!existPermItems.containsKey(permItemID)) continue;
            KDTreeNode temp = (KDTreeNode)existPermItems.get(permItemID);
            TreePath treePath = new TreePath(temp.getPath());
            tree.expandPath(treePath);
        }
        tree.updateUI();
    }
}

