/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.tree;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IIDSecondAuthorize;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.client.tree.IPermissionTreeBuilder;
import com.kingdee.eas.base.permission.client.tree.PermissionTreeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public abstract class AbstractPermissionTreeBuilder
implements IPermissionTreeBuilder {
    private static final Icon ICON_NORNAL = EASResource.getIcon((String)"imgTbtn_unforbidPerm");
    private static final Icon ICON_FORBID = EASResource.getIcon((String)"imgTbtn_forbidPerm");
    private static final Icon ICON_DATARULE = EASResource.getIcon((String)"imgTbtn_dataaccredit");
    private static final Icon ICON_LEAF_ADVICE = EASResource.getIcon((String)"imgTree_folder_leafpick");
    private static final Icon ICON_FOLDER_OPEN__ADVICE = EASResource.getIcon((String)"imgTree_folder_openpick");
    private static final Icon ICON_FOLDER_CLOSE_ADVICE = EASResource.getIcon((String)"imgTree_folder_closepick");

    @Override
    public KDTreeNode createTreeBranch() throws Exception {
        ArrayList<IObjectValue> collection = new ArrayList<IObjectValue>();
        PermItemCollection piBranches = this.getBranches();
        int size = piBranches.size();
        for (int i = 0; i < size; ++i) {
            collection.add(this.createNewUserObject(piBranches.get(i)));
        }
        return this.createChildNode(collection);
    }

    @Override
    public KDTreeNode createSecondAuthorizeTree() throws Exception {
        ArrayList<IObjectValue> collection = new ArrayList<IObjectValue>();
        PermItemCollection piBranches = this.getSecondAuthorizeBranches();
        int size = piBranches.size();
        for (int i = 0; i < size; ++i) {
            collection.add(this.createNewUserObject(piBranches.get(i)));
        }
        return this.createChildNode(collection);
    }

    protected abstract IObjectValue createNewUserObject(PermItemInfo var1);

    protected abstract PermItemInfo getPermItem(IObjectValue var1);

    private KDTreeNode createChildNode(Collection collection) {
        return PermissionTreeHelper.createChildNode(collection, this);
    }

    @Override
    public KDTreeNode buildTreeRoot(KDTreeNode branch, IObjectCollection leaves) throws Exception {
        if (branch == null) {
            return null;
        }
        KDTreeNode root = (KDTreeNode)ObjectUtils.createCopy((Object)branch);
        Map mapLeaves = this.getPermItemMap(leaves);
        Enumeration enumeration = root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            PermItemInfo permItemInfo = this.getPermItem((IObjectValue)node.getUserObject());
            String permItemID = permItemInfo.getId().toString();
            if (!mapLeaves.containsKey(permItemID)) continue;
            Collection collection = (Collection)mapLeaves.get(permItemID);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                KDTreeNode child = new KDTreeNode(iterator.next());
                child.setText(this.getPermItem((IObjectValue)child.getUserObject()).getAlias());
                node.add((MutableTreeNode)child);
            }
        }
        this.removeEmptyNode(root);
        if (root.getChildCount() == 0) {
            root = null;
        }
        return root;
    }

    protected void removeEmptyNode(KDTreeNode root) {
        if (root != null && root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                KDTreeNode node = (KDTreeNode)root.getChildAt(i);
                this.removeEmptyNode(node);
                if (this.getPermItem((IObjectValue)node.getUserObject()).isIsLeaf() || node.getChildCount() != 0) continue;
                node.removeFromParent();
            }
        }
    }

    private Map getPermItemMap(IObjectCollection objectCollection) {
        HashMap map = new HashMap(1000);
        int size = objectCollection.size();
        for (int i = 0; i < size; ++i) {
            Collection<IObjectValue> collection;
            IObjectValue objectValue = objectCollection.getObject(i);
            PermItemInfo permItemInfo = this.getPermItem(objectValue);
            if (permItemInfo.getParent() == null) continue;
            String permItemID = permItemInfo.getParent().getId().toString();
            if (map.containsKey(permItemID)) {
                collection = (Collection)map.get(permItemID);
                collection.add(objectValue);
                continue;
            }
            collection = new LinkedHashSet();
            collection.add(objectValue);
            map.put(permItemID, collection);
        }
        return map;
    }

    protected PermItemCollection getBranches() throws EASBizException, BOSException {
        PermItemCollection branches = null;
        try {
            IPermItem iPermItem = PermItemFactory.getRemoteInstance();
            branches = iPermItem.getBranches();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            throw new AbortException((Throwable)e);
        }
        return branches;
    }

    protected PermItemCollection getSecondAuthorizeBranches() throws EASBizException, BOSException {
        PermItemCollection branches = null;
        IIDSecondAuthorize secondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
        branches = secondAuthorize.getPermItemTreeCollection();
        return branches;
    }

    @Override
    public void setForbiddenIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        Enumeration enumeration = treeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            if (this.getPermItem((IObjectValue)node.getUserObject()).isIsLeaf()) {
                node.setCustomIcon(ICON_FORBID);
                continue;
            }
            node.setCustomIcon(null);
        }
    }

    @Override
    public void setDefaultIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        Enumeration enumeration = treeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            node.setCustomIcon(null);
        }
    }

    @Override
    public void setDataRuleIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        Enumeration enumeration = treeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
            PermItemInfo permItemInfo = this.getPermItem((IObjectValue)node.getUserObject());
            if (!StringUtils.isEmpty((String)permItemInfo.getObjectType()) && permItemInfo.isEnableDataPermission()) {
                node.setCustomIcon(ICON_DATARULE);
                continue;
            }
            if (node.isLeaf()) {
                node.setCustomIcon(ICON_NORNAL);
                continue;
            }
            node.setCustomIcon(null);
        }
    }

    @Override
    public void setAdviceIcon(KDTreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (treeNode.isLeaf()) {
            treeNode.setCustomIcon(ICON_LEAF_ADVICE);
            for (KDTreeNode parent = (KDTreeNode)treeNode.getParent(); parent != null; parent = (KDTreeNode)parent.getParent()) {
                parent.setCustomIcon(ICON_FOLDER_OPEN__ADVICE);
            }
        } else {
            treeNode.setCustomIcon(ICON_FOLDER_CLOSE_ADVICE);
            for (KDTreeNode parent = (KDTreeNode)treeNode.getParent(); parent != null; parent = (KDTreeNode)parent.getParent()) {
                parent.setCustomIcon(ICON_FOLDER_CLOSE_ADVICE);
            }
        }
    }
}

