/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.tree;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.client.tree.AbstractPermissionTreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.MutableTreeNode;

public class PermissionTreeHelper {
    public static KDTreeNode createChildNode(Collection collection, AbstractPermissionTreeBuilder builder) {
        KDTreeNode root = null;
        HashMap<BOSUuid, KDTreeNode> mapPerms = new HashMap<BOSUuid, KDTreeNode>();
        for (IObjectValue objectValue : collection) {
            PermItemInfo permItemInfo = builder.getPermItem(objectValue);
            if (permItemInfo.getParent() == null) {
                root = new KDTreeNode((Object)objectValue);
                root.setText(permItemInfo.getAlias());
                mapPerms.put(permItemInfo.getId(), root);
                continue;
            }
            Object parent = mapPerms.get(permItemInfo.getParent().getId());
            if (parent == null) continue;
            KDTreeNode node = new KDTreeNode((Object)objectValue);
            node.setText(permItemInfo.getAlias());
            KDTreeNode parentNode = (KDTreeNode)parent;
            parentNode.add((MutableTreeNode)node);
            mapPerms.put(permItemInfo.getId(), node);
        }
        return root;
    }

    public static void generateItemTree(KDTreeNode root, PermissionItemCollection collection) {
        if (root == null || collection == null) {
            throw new IllegalArgumentException("root and collection can not be null");
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            PermissionItemInfo item = collection.get(i);
            String group = item.getGroupName();
            KDTreeNode node = PermissionTreeHelper.getTreeNodeByGroup(root, group);
            KDTreeNode itemNode = new KDTreeNode((Object)item.getAlias());
            itemNode.setUserObject((Object)item);
            node.add((MutableTreeNode)itemNode);
        }
    }

    private static KDTreeNode getTreeNodeByGroup(KDTreeNode root, String group) {
        if (StringUtils.isEmpty((String)group)) {
            return root;
        }
        String[] items = StringUtils.split((String)group, (String)".");
        return PermissionTreeHelper.getTreeNodeBySplitArray(root, items);
    }

    private static KDTreeNode getTreeNodeBySplitArray(KDTreeNode root, String[] items) {
        KDTreeNode selectedNode = null;
        if (items.length >= 1) {
            String item = items[0];
            if (item != null && !item.startsWith("EAS") && !item.startsWith("360")) {
                item = item.replaceFirst("\\w{3}", "");
            }
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                String label;
                KDTreeNode child = (KDTreeNode)children.nextElement();
                Object obj = child.getUserObject();
                if (!(obj instanceof String) || !(label = (String)obj).equals(item)) continue;
                selectedNode = child;
                break;
            }
            if (selectedNode == null) {
                selectedNode = new KDTreeNode((Object)item);
                selectedNode.setUserObject((Object)item);
                root.add((MutableTreeNode)selectedNode);
            }
        }
        if (items.length == 1) {
            return selectedNode;
        }
        String[] otherItems = new String[items.length - 1];
        System.arraycopy(items, 1, otherItems, 0, items.length - 1);
        return PermissionTreeHelper.getTreeNodeBySplitArray(selectedNode, otherItems);
    }
}

