/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IIDSecondAuthorize;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.plugin.IIdentityCAAuthorize;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.EASSignatureInfo;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.base.security.PkiSecurityException;
import com.kingdee.eas.base.security.SignatureStatusEnum;
import com.kingdee.eas.base.security.client.InputPasswordUI;
import com.kingdee.eas.base.security.provider.client.IPKIClientExt2Provider;
import com.kingdee.eas.base.security.usbkey.USBKeyInitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.framework.ObjectValueSignature;
import com.kingdee.eas.framework.client.BillEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CAIdentityAuthorize
extends ObjectValueSignature
implements IIdentityCAAuthorize {
    private static Logger logger = Logger.getLogger(CAIdentityAuthorize.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static String UKCA_CHECKPASSWORD = "UKCA_CHECKPASSWORD";
    private static String UKCA_CHECKUSER = "UKCA_CHECKUSER";
    public static final String SELECT_IDS = "selectIds";
    private static String FY_SETTLETYPENUMBER = "UKCA_SETTLETYPENUMBER";
    private static IEASSignature iEASSignature = null;
    private static IPKIClientExt2Provider clientPKI = null;

    private static Map getRomotePlainMapCollection(BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getPlainTextMapCollection(bosType, pk, fieldKeyName);
    }

    private static Map getRomoteFormatPlainMapCollection(BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        return facade.getFormatPlainTextMapCollection(bosType, pk, fieldKeyName);
    }

    private static Map getRomoteSignatureConfig() throws Exception {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        Map map = facade.getSignatrueConfig();
        return map;
    }

    private static boolean checkNeedSign(BOSObjectType type, IObjectPK pk) throws EASBizException, BOSException, CryptException {
        boolean boolResult = false;
        SignatureFieldInfo info = (SignatureFieldInfo)signaturConfigMap.get(type.toString());
        String strSettleType = info.getSettleTypeFieldName();
        if (StringUtils.isEmpty((String)strSettleType)) {
            return true;
        }
        BOSObjectType settleObjectType = BOSObjectType.create((String)"E96B2B8E");
        IDynamicObject dynamicObject = DynamicObjectFactory.getRemoteInstance();
        IObjectValue object1 = dynamicObject.getValue(type, pk);
        IObjectValue settleTypeInfo = (IObjectValue)object1.get(strSettleType);
        if (settleTypeInfo != null) {
            ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)settleTypeInfo.get("id").toString()));
            IObjectValue objSettleType = dynamicObject.getValue(settleObjectType, (IObjectPK)objectPK);
            String settleNumber = objSettleType.get("number").toString();
            String strParam = StringUtils.cnulls((String)ParamManager.getParamValue(null, null, (String)FY_SETTLETYPENUMBER));
            boolResult = settleNumber.equalsIgnoreCase(strParam);
        } else {
            logger.info((Object)("checkNeedSign:type is :" + type + ",pk is:" + pk + ",fieldName is:" + strSettleType + ",then settleTypeInfo is null"));
        }
        return boolResult;
    }

    public static boolean checkPassword() throws EASBizException, BOSException, CryptException {
        String strParam = StringUtils.cnulls((String)ParamManager.getParamValue(null, null, (String)UKCA_CHECKPASSWORD));
        clientPKI = USBKeyInitFactory.getUsbKey();
        String isUsbKeyExistent = clientPKI.isUsbKeyExistent();
        for (int i = 0; i < 5; ++i) {
            String temp = clientPKI.isUsbKeyExistent();
            if (null != temp) continue;
            isUsbKeyExistent = temp;
        }
        String errorMsg = null;
        boolean res = false;
        try {
            clientPKI = USBKeyInitFactory.getUsbKey();
            if (isUsbKeyExistent == null) {
                errorMsg = EASResource.getString((String)RESOURCE, (String)"USBKEY_CHECK_DEVICE_FAIL");
                MsgBox.showError((String)errorMsg);
                SysUtil.abort();
            } else if ("finger".equals(isUsbKeyExistent)) {
                if (IPKIClientExt2Provider.class.isAssignableFrom(clientPKI.getClass())) {
                    res = clientPKI.checkPasswd("".getBytes("UTF-8"));
                }
                if (!res) {
                    errorMsg = EASResource.getString((String)RESOURCE, (String)"USBKEY_PASSWORD_ERROR");
                    MsgBox.showError((String)errorMsg);
                    SysUtil.abort();
                }
            } else if (strParam.equalsIgnoreCase("true") || !clientPKI.isKeyLogin()) {
                String strValue;
                IUIWindow uiWindow = UITools.showUI(null, "com.kingdee.eas.base.security.client.InputPasswordUI", new UIContext());
                if (((InputPasswordUI)uiWindow.getUIObject()).isCancel()) {
                    SysUtil.abort();
                }
                if (!(res = clientPKI.checkPasswd((strValue = ((InputPasswordUI)uiWindow.getUIObject()).getReturnValue()).getBytes("UTF-8")))) {
                    errorMsg = EASResource.getString((String)RESOURCE, (String)"USBKEY_PASSWORD_ERROR");
                    MsgBox.showError((String)errorMsg);
                    SysUtil.abort();
                }
                USBKeyInitFactory.setPwd((String)strValue);
            }
        }
        catch (Exception e) {
            SysUtil.abort();
        }
        return true;
    }

    public static boolean checkUser() throws EASBizException, BOSException, CryptException {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        try {
            clientPKI = USBKeyInitFactory.getNewUsbKey();
            String usbKeyNumber1 = null;
            try {
                usbKeyNumber1 = new String(clientPKI.getUserID(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String curUserNumber = userInfo.getNumber();
            if (!curUserNumber.equalsIgnoreCase(usbKeyNumber1)) {
                String errorMsg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USB_CURRENT_USER_DIFF"), curUserNumber, usbKeyNumber1);
                MsgBox.showError((String)errorMsg);
                SysUtil.abort();
            }
        }
        catch (NullPointerException e) {
            logger.info((Object)"usbKey check device fail!");
            MsgBox.showError((String)EASResource.getString((String)RESOURCE, (String)"USBKEY_CHECK_DEVICE_FAIL"));
            SysUtil.abort();
        }
        catch (UsbKeyException e) {
            logger.info((Object)"usbKey check device fail!");
            MsgBox.showError((String)EASResource.getString((String)RESOURCE, (String)"USBKEY_CHECK_DEVICE_FAIL"));
            SysUtil.abort();
        }
        return true;
    }

    public void checkPlaintText(List signBillIds, Map uiContext) throws EASBizException, BOSException {
        CoreBillBaseInfo billInfo;
        HashMap editBillid = (HashMap)uiContext.get("DATAOBJECTS");
        String dataObjectName = (String)uiContext.get("DATAOBJECTNAME");
        if ("editdata".equalsIgnoreCase(dataObjectName) && (null == (billInfo = (CoreBillBaseInfo)editBillid.get("editData")) || null == billInfo.getId())) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"CA_CHECK_PLAINTEXT_SAVE"));
            SysUtil.abort();
        }
        if (signBillIds.size() < 1) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"CA_CHECK_CONFIG_NEEDSIGN"));
            SysUtil.abort();
        }
        BOSObjectType bosObjectType = BOSUuid.read((String)((String)signBillIds.get(0))).getType();
        String fieldKeyName = (String)uiContext.get("getKeyFieldName");
        ObjectUuidPK[] pk = new ObjectUuidPK[signBillIds.size()];
        for (int i = 0; i < signBillIds.size(); ++i) {
            pk[i] = new ObjectUuidPK(BOSUuid.read((String)((String)signBillIds.get(i))));
        }
        try {
            CAIdentityAuthorize.getRomotePlainMapCollection(bosObjectType, (IObjectPK[])pk, fieldKeyName);
        }
        catch (Exception e) {
            CAIdentityAuthorize.showFailureMsg(e.getMessage(), bosObjectType);
        }
    }

    @Override
    public boolean checkIdentity(Window ownerUI, IObjectPK userPk, Map uiContext, AuthorizeTypeEnum authorizeType) throws EASBizException, BOSException, CryptException {
        logger.error((Object)("checkIdentity start... authorizeType: " + (Object)((Object)authorizeType)));
        boolean boolResult = true;
        List signBillIds = CAIdentityAuthorize.checkNeedSign(ownerUI, userPk, uiContext);
        if (!CAIdentityAuthorize.checkCaOrgRange(signBillIds, uiContext)) {
            logger.info((Object)"is not in CaOraRange,don't check Signature");
            return true;
        }
        this.checkPlaintText(signBillIds, uiContext);
        if (!authorizeType.equals((Object)AuthorizeTypeEnum.caAuthOnlyVerfiy)) {
            CAIdentityAuthorize.checkUser();
            CAIdentityAuthorize.checkPassword();
        }
        if (!authorizeType.equals((Object)AuthorizeTypeEnum.caAuthOnlySignature)) {
            if (signBillIds.size() > 0) {
                logger.error((Object)"checkSignature start... ");
                BOSObjectType bosObjectType = BOSUuid.read((String)((String)signBillIds.get(0))).getType();
                if (iEASSignature == null) {
                    iEASSignature = EASSignatureFactory.getRemoteInstance();
                }
                try {
                    iEASSignature.checkSignature(bosObjectType, signBillIds);
                }
                catch (PkiSecurityException e) {
                    if (PkiSecurityException.VERIFY_FAIL_BIZ.getCode().equals(e.getSubCode())) {
                        MsgBox.showWarning((String)e.getLocalizedMessage());
                        SysUtil.abort();
                    }
                    throw e;
                }
            }
        } else {
            logger.error((Object)"onlySignature is true, ignore checkSignature.");
        }
        return boolResult;
    }

    private static List checkNeedSign(Window ownerUI, IObjectPK userPk, Map uiContext) throws EASBizException, BOSException, CryptException {
        BOSObjectType bosObjectType = null;
        ArrayList signBillIds = new ArrayList();
        if (uiContext != null && uiContext.containsKey(SELECT_IDS)) {
            logger.info((Object)"has SELECT_IDS data!");
            ArrayList selectIds = (ArrayList)uiContext.get(SELECT_IDS);
            if (selectIds != null && selectIds.size() > 0) {
                if (selectIds.get(0) != null) {
                    bosObjectType = BOSUuid.read((String)selectIds.get(0).toString()).getType();
                    if (!ObjectValueSignature.isHasBosTypeConfig((BOSObjectType)bosObjectType)) {
                        logger.info((Object)("config file not config this bostype is:" + bosObjectType + " check sign over!"));
                        return new ArrayList();
                    }
                } else {
                    logger.info((Object)"selectIds.get(0) is null.");
                }
                for (int i = 0; i < selectIds.size(); ++i) {
                    if (selectIds.get(0) == null) continue;
                    String selectDataId = (String)selectIds.get(i);
                    boolean boolBillType = CAIdentityAuthorize.checkNeedSign(bosObjectType, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)selectDataId)));
                    logger.info((Object)("read checkNeedSign info ,res is:" + boolBillType + " dataId is:" + selectDataId));
                    if (!boolBillType) continue;
                    signBillIds.add(selectIds.get(i));
                }
            }
        } else {
            logger.info((Object)"SELECT_IDS is null.");
        }
        return signBillIds;
    }

    public static void saveSignature(Window ownerUI, IObjectPK userPk, Map uiContext) throws EASBizException, BOSException, CryptException {
        List signBillIds = CAIdentityAuthorize.checkNeedSign(ownerUI, userPk, uiContext);
        if (!CAIdentityAuthorize.checkCaOrgRange(signBillIds, uiContext)) {
            logger.info((Object)"is not in CaOraRange\uff0cdon't saveSignature");
            return;
        }
        if (signBillIds.size() > 0) {
            logger.info((Object)"signature start... ");
            BOSObjectType bosObjectType = BOSUuid.read((String)((String)signBillIds.get(0))).getType();
            ObjectUuidPK[] pk = new ObjectUuidPK[signBillIds.size()];
            for (int i = 0; i < signBillIds.size(); ++i) {
                pk[i] = new ObjectUuidPK(BOSUuid.read((String)((String)signBillIds.get(i))));
            }
            try {
                String isUsbKeyExistent = clientPKI.isUsbKeyExistent();
                if ("finger".equals(isUsbKeyExistent)) {
                    CAIdentityAuthorize.signatureByFingerWithoutCheck(null, bosObjectType, (IObjectPK[])pk, (String)uiContext.get("getKeyFieldName"));
                }
                CAIdentityAuthorize.signatureWithoutCheckSign(null, bosObjectType, (IObjectPK[])pk, (String)uiContext.get("getKeyFieldName"));
            }
            catch (Exception e) {
                logger.error((Object)"signature error:", (Throwable)e);
                throw new PkiSecurityException(PkiSecurityException.SIGN_FAIL_BIZ, (Throwable)e);
            }
        } else {
            logger.info((Object)"signature signBillIds size is 0.");
        }
    }

    public static void signatureWithoutCheckSign(String status, BOSObjectType bosType, IObjectPK[] pk, String fieldKeyName) throws Exception {
        try {
            Map map = CAIdentityAuthorize.getRomotePlainMapCollection(bosType, pk, fieldKeyName);
            Map mapFormat = CAIdentityAuthorize.getRomoteFormatPlainMapCollection(bosType, pk, fieldKeyName);
            if (map != null) {
                if (map.size() > 1) {
                    CAIdentityAuthorize.batchSignatrue(bosType, map, mapFormat, status, pk);
                } else {
                    CAIdentityAuthorize.signature(bosType, map, mapFormat, status, pk);
                }
            }
            CAIdentityAuthorize.showSucessMsg(null);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private static void batchSignatrue(BOSObjectType bosType, Map plainText, Map plainFormatText, String status, IObjectPK[] pk) throws BOSException {
        long timeStart = System.nanoTime();
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            String userName = SysContext.getSysContext().getUserName();
            byte[] pwd = USBKeyInitFactory.getPwd().getBytes("utf-8");
            CoreBaseCollection coll = new CoreBaseCollection();
            IEASSignature easSignture = EASSignatureFactory.getRemoteInstance();
            clientPKI.checkUSBKeyState(userName, pwd);
            Iterator iterator = plainText.keySet().iterator();
            while (iterator.hasNext()) {
                String id = iterator.next().toString();
                byte[] plainTextByte = (byte[])plainText.get(id);
                byte[] formatByte = (byte[])plainFormatText.get(id);
                byte[] curSignature = clientPKI.batchSign(plainTextByte, userName, pwd);
                EASSignatureInfo signatureInfo = new EASSignatureInfo();
                signatureInfo.setBosType(bosType.toString());
                signatureInfo.setSignature(new String(curSignature, "UTF-8"));
                signatureInfo.setUser(userInfo);
                signatureInfo.setPlainText(new String(plainTextByte, "UTF-8"));
                signatureInfo.setFormatPlainText(new String(formatByte, "UTF-8"));
                signatureInfo.setObjectid(id);
                signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
                coll.add((CoreBaseInfo)signatureInfo);
            }
            easSignture.addnew(coll);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("signature(map) time spent(ns): " + (System.nanoTime() - timeStart)));
    }

    private static void signature(BOSObjectType bosType, Map plainText, Map plainFormatText, String status, IObjectPK[] pk) throws BOSException {
        long timeStart = System.nanoTime();
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            Iterator iterator = plainText.keySet().iterator();
            CoreBaseCollection coll = new CoreBaseCollection();
            IEASSignature easSignture = EASSignatureFactory.getRemoteInstance();
            while (iterator.hasNext()) {
                String id = iterator.next().toString();
                byte[] objByte = (byte[])plainText.get(id);
                byte[] formatByte = (byte[])plainFormatText.get(id);
                String userName = SysContext.getSysContext().getUserName();
                byte[] curSignature = clientPKI.sign(objByte, userName, USBKeyInitFactory.getPwd().getBytes("utf-8"));
                EASSignatureInfo signatureInfo = new EASSignatureInfo();
                signatureInfo.setBosType(bosType.toString());
                signatureInfo.setSignature(new String(curSignature, "UTF-8"));
                signatureInfo.setUser(userInfo);
                signatureInfo.setPlainText(new String(objByte, "UTF-8"));
                signatureInfo.setFormatPlainText(new String(formatByte, "UTF-8"));
                signatureInfo.setObjectid(id);
                signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
                coll.add((CoreBaseInfo)signatureInfo);
            }
            easSignture.addnew(coll);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("signature(map) time spent(ns): " + (System.nanoTime() - timeStart)));
    }

    private static void signatureByFingerWithoutCheck(String status, BOSObjectType bosObjectType, IObjectPK[] pk, String fieldKeyName) throws EASBizException, BOSException {
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        Map plainTextMap = facade.getPlainTextMapCollection(bosObjectType, pk, fieldKeyName);
        Map plainFormatTextMap = facade.getFormatPlainTextMapCollection(bosObjectType, pk, fieldKeyName);
        if (plainTextMap != null) {
            try {
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                String userName = SysContext.getSysContext().getUserName();
                Iterator iterator = plainTextMap.keySet().iterator();
                CoreBaseCollection coll = new CoreBaseCollection();
                IEASSignature easSignture = EASSignatureFactory.getRemoteInstance();
                while (iterator.hasNext()) {
                    String id = iterator.next().toString();
                    byte[] objByte = (byte[])plainTextMap.get(id);
                    byte[] formatByte = (byte[])plainFormatTextMap.get(id);
                    byte[] curSignature = clientPKI.sign(objByte, userName, "finger".getBytes("utf-8"));
                    EASSignatureInfo signatureInfo = new EASSignatureInfo();
                    signatureInfo.setBosType(bosObjectType.toString());
                    signatureInfo.setSignature(new String(curSignature, "UTF-8"));
                    signatureInfo.setUser(userInfo);
                    signatureInfo.setPlainText(new String(objByte, "UTF-8"));
                    signatureInfo.setFormatPlainText(new String(formatByte, "UTF-8"));
                    signatureInfo.setObjectid(id);
                    signatureInfo.setAuditStatus(SignatureStatusEnum.SUCCESS);
                    coll.add((CoreBaseInfo)signatureInfo);
                }
                easSignture.addnew(coll);
                USBKeyInitFactory.updateCert((IPKIClientExt2Provider)clientPKI, (String)userName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static boolean checkCaOrgRange(List pks, Map uiContext) throws EASBizException, BOSException, CryptException {
        boolean result = false;
        boolean isExtends = false;
        IEASSignature easSignature = EASSignatureFactory.getRemoteInstance();
        HashMap context = new HashMap();
        if (uiContext == null) {
            return true;
        }
        if (uiContext.get("ORG.PK") == null) {
            return true;
        }
        if (uiContext.get("METADATA.PK") != null && !(uiContext.get("METADATA.PK") instanceof String)) {
            try {
                Class<?> uiClazz = Class.forName(((IMetaDataPK)uiContext.get("METADATA.PK")).getFullName());
                isExtends = Class.forName(BillEditUI.class.getName()).isAssignableFrom(uiClazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (pks.isEmpty() || isExtends) {
            IIDSecondAuthorize idSecondAuthorize = IDSecondAuthorizeFactory.getRemoteInstance();
            if (uiContext.get("PERMISSIONITEM") != null && uiContext.get("ACTION.PK") == null) {
                Set ret = idSecondAuthorize.getCaOrgRangeByPermItemName((String)uiContext.get("PERMISSIONITEM"));
                return ret.contains(SysContext.getSysContext().getCurrentOrgUnit().getId());
            }
            Set ret = idSecondAuthorize.getCaOrgRangeByActionPK((IMetaDataPK)uiContext.get("METADATA.PK"), (IMetaDataPK)uiContext.get("ACTION.PK"));
            logger.error((Object)("CAIdentity ret:" + ret.toString() + " ORG.PK:" + uiContext.get("ORG.PK") == null ? "" : uiContext.get("ORG.PK").toString()));
            if (ret.isEmpty()) {
                return true;
            }
            return ret.contains(uiContext.get("ORG.PK").toString());
        }
        context.put("APPROVEBOSTYPE", uiContext.get("APPROVEBOSTYPE"));
        context.put("PERMISSIONITEM", uiContext.get("PERMISSIONITEM"));
        context.put("METADATA.PK", uiContext.get("METADATA.PK"));
        context.put("ACTION.PK", uiContext.get("ACTION.PK"));
        for (int i = 0; i < pks.size(); ++i) {
            String pk = pks.get(i).toString();
            logger.error((Object)("CAIdentity pk:" + pk + " I:" + i));
            boolean check = easSignature.checkCaOrgRange(pk, context);
            if (!check) continue;
            return true;
        }
        return result;
    }

    public static boolean isBosTypeSignatureWhenApprove(String pk, BOSObjectType bosType) {
        SignatureFieldInfo info;
        logger.error((Object)"bostype:*********************************");
        if (CAIdentityAuthorize.isHasBosTypeConfig(bosType) && (info = (SignatureFieldInfo)signaturConfigMap.get(bosType.toString())).isSignatureWhenApprove()) {
            HashMap<String, Object> uiContext = new HashMap<String, Object>();
            uiContext.put("APPROVEBOSTYPE", bosType);
            uiContext.put("METADATA.PK", "APPROVEUI");
            uiContext.put("ORG.PK", "APPROVE");
            try {
                ArrayList<String> lists = new ArrayList<String>();
                lists.add(pk);
                boolean result = CAIdentityAuthorize.checkCaOrgRange(lists, uiContext);
                logger.error((Object)("bostype:" + bosType + "Result:" + result));
                return result;
            }
            catch (Exception e) {
                logger.error((Object)"CAIdentityAuthorize isBosTypeSignatureWhenApprove error");
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    @Override
    public void checkIdentity(Window ownerUI, IObjectPK userPk) throws PermissionException {
    }

    public static boolean isHasBosTypeConfig(BOSObjectType bosType) {
        if (bosType != null) {
            SignatureFieldInfo info;
            if (signaturConfigMap == null) {
                try {
                    signaturConfigMap = CAIdentityAuthorize.getRomoteSignatureConfig();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (signaturConfigMap != null && signaturConfigMap.containsKey(bosType.toString()) && (info = (SignatureFieldInfo)signaturConfigMap.get(bosType.toString())).isSignatureNeeded()) {
                return true;
            }
        }
        return false;
    }

    public static void showSucessMsg(String msg) {
    }

    public static void showFailureMsg(String msg, BOSObjectType bosType) {
        SignatureFieldInfo info;
        String fieldAlias;
        String failureMsg = "";
        if (CAIdentityAuthorize.isHasBosTypeConfig(bosType) && !StringUtils.isEmpty((String)(fieldAlias = (info = (SignatureFieldInfo)signaturConfigMap.get(bosType.toString())).getFieldAlias(msg)))) {
            failureMsg = fieldAlias;
            String errorMsg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"CA_CHECK_PLAINTEXT_FALI"), failureMsg);
            MsgBox.showError((String)errorMsg);
        }
        SysUtil.abort();
    }

    public static boolean isBosTypeSignatureWhenApprove(BOSObjectType bosType) {
        SignatureFieldInfo info;
        return CAIdentityAuthorize.isHasBosTypeConfig(bosType) && (info = (SignatureFieldInfo)signaturConfigMap.get(bosType.toString())).isSignatureWhenApprove();
    }
}

