/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldAccessStrategyCollection;
import com.kingdee.eas.base.permission.FieldAccessStrategyFactory;
import com.kingdee.eas.base.permission.IFieldAccessStrategy;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.util.PermissionOrgTypeUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;

public class FieldAccessUtil {
    private FieldAccessUtil() {
    }

    public static Set getGrantedFieldInfos(Set originFieldInfos, Set grantedFields) {
        HashSet<String[]> ret = new HashSet<String[]>();
        for (String[] fieldInfo : originFieldInfos) {
            if (!grantedFields.contains(fieldInfo[1])) continue;
            ret.add(fieldInfo);
        }
        return ret;
    }

    public static Set getEntityFieldInfos(BOSObjectType entityType) {
        LinkedHashSet<String[]> result = new LinkedHashSet<String[]>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(entityType);
        PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            String[] fieldInfo;
            PropertyInfo propertyInfo = properties.get(i);
            if (propertyInfo instanceof OwnPropertyInfo) {
                String propertyName = propertyInfo.getName();
                if (!FieldAccessUtil.isEnableFieldPermission(propertyInfo) || "id".equals(propertyName)) continue;
                fieldInfo = new String[]{FieldAccessUtil.getPropertyAlias(propertyInfo), propertyInfo.getName()};
                result.add(fieldInfo);
                continue;
            }
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            if (PermissionCommonUtil.isEntry(linkPropertyInfo)) {
                HashSet<BOSObjectType> parentEntityTypes = new HashSet<BOSObjectType>();
                parentEntityTypes.add(entityType);
                result.addAll(FieldAccessUtil.getEntryEntityFieldInfos(entity.getType(), linkPropertyInfo, parentEntityTypes, null));
                continue;
            }
            if (!FieldAccessUtil.isEnableFieldPermission(propertyInfo)) continue;
            fieldInfo = new String[]{FieldAccessUtil.getPropertyAlias(propertyInfo), propertyInfo.getName()};
            result.add(fieldInfo);
        }
        return result;
    }

    private static boolean isEnableFieldPermission(PropertyInfo propertyInfo) {
        String value = propertyInfo.getExtendedProperty("enableFieldPermission");
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private static Set getEntryEntityFieldInfos(BOSObjectType mainEntityType, LinkPropertyInfo entryPropertyInfo, Set parentEntityTypes, String currentPropPath) {
        LinkedHashSet<String[]> result = new LinkedHashSet<String[]>();
        EntityObjectInfo entity = PermissionCommonUtil.getLinkEntity(mainEntityType, entryPropertyInfo);
        if (!parentEntityTypes.contains(entity.getType())) {
            parentEntityTypes.add(entity.getType());
            PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
            int size = properties.size();
            for (int i = 0; i < size; ++i) {
                String[] fieldInfo;
                PropertyInfo propertyInfo = properties.get(i);
                if (propertyInfo instanceof OwnPropertyInfo) {
                    String propertyName;
                    if (!FieldAccessUtil.isEnableFieldPermission(propertyInfo) || "id".equals(propertyName = propertyInfo.getName())) continue;
                    fieldInfo = new String[]{FieldAccessUtil.getPropertyAlias((PropertyInfo)entryPropertyInfo) + "." + FieldAccessUtil.getPropertyAlias(propertyInfo), currentPropPath == null ? entryPropertyInfo.getName() + "." + propertyInfo.getName() : currentPropPath + "." + entryPropertyInfo.getName() + "." + propertyInfo.getName()};
                    result.add(fieldInfo);
                    continue;
                }
                if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                if (PermissionCommonUtil.isEntry(linkPropertyInfo)) {
                    result.addAll(FieldAccessUtil.getEntryEntityFieldInfos(entity.getType(), linkPropertyInfo, parentEntityTypes, currentPropPath == null ? entryPropertyInfo.getName() : currentPropPath + "." + entryPropertyInfo.getName()));
                    continue;
                }
                if (!FieldAccessUtil.isEnableFieldPermission(propertyInfo)) continue;
                fieldInfo = new String[]{FieldAccessUtil.getPropertyAlias((PropertyInfo)entryPropertyInfo) + "." + FieldAccessUtil.getPropertyAlias(propertyInfo), currentPropPath == null ? entryPropertyInfo.getName() + "." + propertyInfo.getName() : currentPropPath + "." + entryPropertyInfo.getName() + "." + propertyInfo.getName()};
                result.add(fieldInfo);
            }
        }
        return result;
    }

    private static String getPropertyAlias(PropertyInfo propertyInfo) {
        return StringUtils.isEmpty((String)propertyInfo.getAlias()) ? propertyInfo.getName() : propertyInfo.getAlias();
    }

    public static Set getFieldAccessStrategy(BOSObjectType objectType, IObjectPK cuPK) throws BOSException {
        HashSet<String> result = new HashSet<String>();
        IFieldAccessStrategy iFieldAccessStrategy = FieldAccessStrategyFactory.getRemoteInstance();
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(objectType);
        String orgID = PermissionCommonUtil.getMainBizOrgType(entity).equals((Object)OrgType.NONE) ? "11111111-1111-1111-1111-111111111111CCE7AED4" : cuPK.toString();
        String oql = new StringBuffer(60).append("SELECT fieldName ").append(" WHERE bizObjectType = '").append(objectType.toString()).append("' ").append(" AND CU.id = '").append(orgID).append("' ").toString();
        FieldAccessStrategyCollection strategyCollection = iFieldAccessStrategy.getFieldAccessStrategyCollection(oql);
        int size = strategyCollection.size();
        for (int i = 0; i < size; ++i) {
            result.add(strategyCollection.get(i).getFieldName());
        }
        return result;
    }

    private static void removeNode(IMetaDataLoader loader, DefaultKingdeeTreeNode root, Set orgTypes, Set bosObjectType) {
        DefaultKingdeeTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                BOSObjectType objectType;
                MetaDataBriefInfo mdbInfo;
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                FieldAccessUtil.removeNode(loader, node, orgTypes, bosObjectType);
                Object userObject = node.getUserObject();
                if (!(userObject instanceof MetaDataBriefInfo) || !(mdbInfo = (MetaDataBriefInfo)userObject).getMetaDataType().equals((Object)MetaDataTypeList.ENTITY) || bosObjectType.contains((objectType = mdbInfo.getBOType()).toString()) && orgTypes.contains(PermissionCommonUtil.getMainBizOrgType(loader.getEntity(objectType)))) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    private static Set getBOSObjectTypes(IObjectPK userPK, IObjectPK orgPK) throws EASBizException, BOSException {
        HashSet objectTypesSet = new HashSet();
        IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getRemoteInstance();
        Set userOrgPermSet = iUserOrgPerm.getBizObjectTypes(userPK, orgPK);
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        Set userRoleOrgSet = iUserRoleOrgManager.getBizObjectTypes(userPK, orgPK);
        objectTypesSet.addAll(userOrgPermSet);
        objectTypesSet.addAll(userRoleOrgSet);
        return objectTypesSet;
    }

    public static void filterUserFieldAccessTreeNode(IObjectPK userPK, IObjectPK orgPK, DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
        Set bosObjectTypes = FieldAccessUtil.getBOSObjectTypes(userPK, orgPK);
        Set orgTypes = PermissionOrgTypeUtils.getOrgTypes(null, orgPK);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        FieldAccessUtil.removeNode(loader, root, orgTypes, bosObjectTypes);
        PermissionCommonUtil.removeEmptyPackageNode(root);
    }
}

