/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.dpcard;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.dpcard.DynamicPassword;
import com.kingdee.eas.base.permission.dpcard.IDynamicPasswordService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.web.EASWebLicenceHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class DynamicPasswordService
extends AbstractBOSObject
implements IDynamicPasswordService {
    private static Logger logger = Logger.getLogger(DynamicPasswordService.class);
    private static final int EXPIRE_TIME = 30;
    private static final String CONFIG_NAME = "PermParam.properties";
    private static int configTime = 0;
    private static Map<String, DynamicPassword> dp = new ConcurrentHashMap<String, DynamicPassword>();

    public DynamicPasswordService() throws EASBizException, BOSException {
        this.initExporeTime();
    }

    public DynamicPasswordService(Context ctx) throws EASBizException, BOSException {
        this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExporeTime() {
        if (configTime <= 0) {
            FileInputStream fin = null;
            try {
                File paramFile = new File(System.getProperty("eas.deploy") + File.separator + CONFIG_NAME);
                fin = new FileInputStream(paramFile);
                Properties params = new Properties();
                params.load(fin);
                String expireTime = params.getProperty("ExpireTime");
                configTime = StringUtils.isEmpty((String)expireTime) || Integer.parseInt(expireTime) <= 0 ? 30 : Integer.parseInt(expireTime);
                return;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)(PermissionResUtil.getResource("res_126") + e));
            }
            catch (IOException e) {
                logger.error((Object)(PermissionResUtil.getResource("res_127") + e));
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            configTime = 30;
        }
    }

    @Override
    public Map getCode(Context ctx, Map data) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ctx.get((Object)"LOGIN_TYPE") == null || !"MOBILE".equals(ctx.get((Object)"LOGIN_TYPE").toString())) {
            result.put("success", false);
            result.put("errMsg", "illegal param!");
            logger.debug((Object)"\u975e\u6cd5\u8bbf\u95ee\uff0c\u4e0a\u4e0b\u6587\u4e2d\u6ca1\u6709\u79fb\u52a8BOS\u8bbe\u7f6e\u7684\u767b\u5f55\u65b9\u5f0f");
            return result;
        }
        int licenseResult = 0;
        try {
            licenseResult = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).requestLicense(EASWebLicenceHelper.createLicenseUserInfo((String)"", (Context)ctx), "com.kingdee.eas.cp.eip.sso.web.controller.DynPasswordController");
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        if (licenseResult != 1) {
            result.put("success", false);
            result.put("errMsg", "illegal license!");
            logger.debug((Object)"\u975e\u6cd5\u8bbf\u95ee\uff0c\u6ca1\u6709\u5408\u6cd5\u7684\u8bb8\u53ef\uff01");
            return result;
        }
        if (data == null || data.get("userId") == null || data.get("userNumber") == null) {
            result.put("success", false);
            result.put("errMsg", "illegal param!");
            return result;
        }
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)data.get("userId").toString()));
        user.setNumber(data.get("userNumber").toString());
        Random random = new Random();
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            code.append(random.nextInt(10));
        }
        result.put("success", true);
        result.put("code", code);
        result.put("expireTime", configTime);
        this.setCode(ctx, user, code.toString());
        return result;
    }

    @Override
    public boolean checkCode(Context ctx, String userId, String code) throws BOSException, EASBizException {
        long nowTime = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)userId)) {
            logger.debug((Object)"\u7528\u6237\u540d\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isEmpty((String)code)) {
            logger.debug((Object)"\u52a8\u6001\u5bc6\u7801\u4e3a\u7a7a");
            return false;
        }
        if (code.length() != 6) {
            logger.debug((Object)"\u975e\u6cd5\u52a8\u6001\u5bc6\u7801");
            return false;
        }
        DynamicPassword dpInfo = dp.get(userId);
        if (dpInfo == null) {
            logger.debug((Object)"\u52a8\u6001\u5bc6\u7801\u4e0d\u5728\u7f13\u5b58\u5185");
            return false;
        }
        if (nowTime > dpInfo.getExpirTime()) {
            logger.debug((Object)"\u52a8\u6001\u5bc6\u7801\u5df2\u8fc7\u671f");
            return false;
        }
        if (PermissionUtil.encrypt((String)userId, (String)code).equals(dpInfo.getCode())) {
            dp.remove(userId);
            return true;
        }
        logger.debug((Object)"\u5bc6\u7801\u4e0d\u5339\u914d");
        return false;
    }

    private void setCode(Context ctx, UserInfo user, String code) throws BOSException, EASBizException {
        try {
            String userId = user.getId().toString();
            long expirTime = System.currentTimeMillis() + (long)(configTime * 1000);
            dp.put(userId, new DynamicPassword(userId, code, expirTime));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public BOSObjectType getType() {
        return null;
    }

    private static String getXTOpenID(Context ctx, UserInfo userInfo) throws BOSException, SQLException {
        String sql = "select FXTID from T_PM_EASXTUSERMAP where FUSERID=?";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString()});
        if (result.size() < 1) {
            logger.info((Object)"Fetch OPENID by userid return nothing, Fetch it by personid");
            sql = "select FXTID from T_PM_EASXTUSERMAP where FPERSONID=(select FPERSONID from T_PM_USER where FID=?)";
            result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString()});
            if (result.size() >= 1 && result.next()) {
                return result.getString("FXTID");
            }
        } else if (result.next()) {
            return result.getString("FXTID");
        }
        logger.error((Object)("Get XT openID error, userNumber=" + userInfo.getNumber() + " and FID=" + userInfo.getId().toString()));
        throw new BOSException("Get XT openID error, userNumber=" + userInfo.getNumber() + " and FID=" + userInfo.getId().toString());
    }
}

