/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.eas.EASObject;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.service.helper.IPermissionParameter;
import com.kingdee.eas.common.EASBizException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PermissionParameter
extends EASObject
implements IPermissionParameter {
    private static Logger logger = Logger.getLogger(PermissionParameter.class);
    private Properties params = null;
    public static final String USBKEY_USEABLE = "USBKEY_USEABLE";
    public static final String USBKEYIMP = "USBKEYIMP";
    public static final String ENABLE_ID_AUTHEN = "EnableIDAuthorize";
    public static final String ENABLE_AUTHEN_ADMIN = "EnableAuthenticateAdmin";
    public static final String ENABLE_PERM_SUBSYTEM_FILE = "EnablePermSubsystemFile";
    public static final String DYNAMIC_CARD_PWD_CHECK_CLASS = "DynamicCardPwdCheckClass";
    public static final String GOLDGRID_HTML = "GOLD_HTML";
    public static final String GOLDGRID_HTML_FILENAME = "goldgrid.properties";
    public static final String ENABLE_FINGER_PRINT = "EnableFingerPrint";
    public static final String ENABLE_AUDIT_ADMIN = "EnableAuditAdmin";
    private static String enableEncrypt;
    private static String disableEncrypt;

    public PermissionParameter() {
        this.registerInterface(IPermissionParameter.class, this);
        this.getPermissionParam();
    }

    private Properties getPermissionParam() {
        FileInputStream fin = null;
        try {
            File paramFile = this.getParamFile();
            fin = new FileInputStream(paramFile);
            this.params = new Properties();
            this.params.load(fin);
            fin.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)(PermissionResUtil.getResource("res_126") + e));
            this.storeParamFile();
        }
        catch (IOException e) {
            logger.error((Object)(PermissionResUtil.getResource("res_127") + e));
            this.storeParamFile();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.params;
    }

    private File getParamFile() throws IOException {
        return this.getParamFile("PermParam.properties");
    }

    private File getParamFile(String fileName) throws IOException {
        String ctrlFilePath = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append(fileName).toString();
        File paramFile = new File(ctrlFilePath);
        return paramFile;
    }

    @Override
    public String getUsbkeyImp() {
        return this.getPermissionParameter(USBKEYIMP);
    }

    @Override
    public boolean isNeedUsbKeyPerm() {
        this.initUsbkeyEncryptInfo();
        return enableEncrypt != null && enableEncrypt.equalsIgnoreCase(this.getPermissionParameter(USBKEY_USEABLE));
    }

    private void initUsbkeyEncryptInfo() {
        if (PermissionParameter.isUsbkeyEncryptInfoInited()) {
            return;
        }
        try {
            enableEncrypt = CryptoUtil.encrypt((String)"true");
            disableEncrypt = CryptoUtil.encrypt((String)"false");
        }
        catch (CryptException e) {
            e.printStackTrace();
            logger.error((Object)("\u52a0\u5bc6usbkey\u76f8\u5173\u4fe1\u606f\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage()));
        }
    }

    private static boolean isUsbkeyEncryptInfoInited() {
        return PermissionParameter.isNotNil(enableEncrypt) && PermissionParameter.isNotNil(disableEncrypt);
    }

    private static boolean isNotNil(String str) {
        return str != null && str.length() > 0;
    }

    public BOSObjectType getType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeParamFile() {
        FileOutputStream fout = null;
        try {
            File clientCtrlFile = this.getParamFile();
            fout = new FileOutputStream(clientCtrlFile);
            Properties props = new Properties();
            props.put(USBKEY_USEABLE, "false");
            props.put(USBKEYIMP, "");
            props.put(ENABLE_AUTHEN_ADMIN, "false");
            props.put(ENABLE_ID_AUTHEN, "false");
            props.put(ENABLE_FINGER_PRINT, "false");
            props.put(DYNAMIC_CARD_PWD_CHECK_CLASS, "");
            props.store(fout, "param information:");
            fout.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)(PermissionResUtil.getResource("res_126") + e));
        }
        catch (IOException e) {
            logger.error((Object)(PermissionResUtil.getResource("res_127") + e));
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isIDAuthorizeEnabled() {
        return "true".equalsIgnoreCase(this.getPermissionParameter(ENABLE_ID_AUTHEN));
    }

    private String getHtmlStr() {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            String url = this.getPermissionParameter("SIGN_SERVER_IP_PORT");
            File htmlFileNameFile = this.getParamFile(GOLDGRID_HTML_FILENAME);
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(htmlFileNameFile)));
            while (true) {
                String tempStr;
                if ((tempStr = reader.readLine()) != null && tempStr.indexOf("<setUrl/>") != -1) {
                    tempStr = url;
                }
                if (tempStr != null) {
                    sb.append("\n").append(tempStr);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)"readfile erro!", (Throwable)e);
            throw new IllegalArgumentException("read goldgrid.properties file error!");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getPermissionParameter(String paramName) {
        String property;
        if (GOLDGRID_HTML.equals(paramName)) {
            return this.getHtmlStr();
        }
        if (this.params == null) {
            this.getPermissionParam();
        }
        if ((property = this.params.getProperty(paramName)) != null) {
            property = property.trim();
        }
        return property;
    }

    @Override
    public boolean isAuthenticateAdminEnabled() {
        return "true".equalsIgnoreCase(this.getPermissionParameter(ENABLE_AUTHEN_ADMIN));
    }

    @Override
    public String getDynamicCardPwdCheckClass() {
        return this.getPermissionParameter(DYNAMIC_CARD_PWD_CHECK_CLASS);
    }

    @Override
    public boolean isFingerPrintEnable() {
        return "true".equalsIgnoreCase(this.getPermissionParameter(ENABLE_FINGER_PRINT));
    }

    @Override
    public void disableAuthenticateAdmin() {
        this.params.setProperty(ENABLE_AUTHEN_ADMIN, "false");
        this.storeToPropertiesFile();
        PermissionCommonUtil.setParam(ENABLE_AUTHEN_ADMIN, false);
    }

    @Override
    public void enableAuthenticateAdmin() {
        this.params.setProperty(ENABLE_AUTHEN_ADMIN, "true");
        this.storeToPropertiesFile();
        PermissionCommonUtil.setParam(ENABLE_AUTHEN_ADMIN, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeToPropertiesFile() {
        FileOutputStream fot = null;
        try {
            File paramFile = this.getParamFile();
            fot = new FileOutputStream(paramFile);
            this.params.store(fot, "");
            fot.flush();
            this.clearMenuCache();
        }
        catch (Exception e) {
            logger.error((Object)(PermissionResUtil.getResource("res_127") + e));
        }
        finally {
            if (fot != null) {
                try {
                    fot.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void clearMenuCache() throws EASBizException, BOSException {
        PermissionChangeHelper helper = new PermissionChangeHelper();
        IObjectPK[] userPKs = new IObjectPK[]{new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"), new ObjectUuidPK("00000000-0000-0000-0000-00000000000113B7DE7F")};
        Context ctx = ContextUtils.getContextFromSession();
        helper.setUserPKs(userPKs);
        helper.exceChange(ctx);
    }

    @Override
    public void disableEnableIdAuthen() {
        this.params.setProperty(ENABLE_ID_AUTHEN, "false");
        this.storeToPropertiesFile();
        PermissionCommonUtil.setParam(ENABLE_ID_AUTHEN, false);
    }

    @Override
    public void enableEnableIdAuthen() {
        this.params.setProperty(ENABLE_ID_AUTHEN, "true");
        this.storeToPropertiesFile();
        PermissionCommonUtil.setParam(ENABLE_ID_AUTHEN, true);
    }
}

