/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.util.SecurityConsoleValidator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AdminSecurityOperatorForJDBC {
    Logger logger = Logger.getLogger((String)AdminSecurityOperatorForJDBC.class.toString());

    public String getLoginNumber(Connection conn, int dbType, String userNumber) throws Exception {
        Statement ps = null;
        try {
            this.logger.info((Object)("Now get user login number by connection and userNumber " + userNumber));
            ps = conn.prepareStatement("select FLoginNumber from t_pm_user where upper(FNumber)=?");
            ps.setString(1, userNumber.toUpperCase());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("FLoginNumber");
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            this.logger.error((Object)"auto update error: ", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    public String getPwTip(Connection conn, int dbType, String userNumber) throws Exception {
        this.getAdminID(userNumber);
        SecurityConsoleValidator securityConsoleValidator = new SecurityConsoleValidator(conn, userNumber);
        return securityConsoleValidator.getSecurityPolicy();
    }

    public void updateLoginNumber(Connection conn, int dbType, String userNumber, String loginNumber) throws Exception {
        String adminId = this.getAdminID(userNumber);
        this.checkLoginNumber(conn, dbType, userNumber, loginNumber);
        Statement ps = null;
        try {
            ps = conn.prepareStatement("update t_pm_user set floginnumber=? where fid='" + adminId + "'");
            ps.setString(1, loginNumber);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    public void updatePassAndLoginNumber(Connection conn, int dbType, String userNumber, String password, String loginNumber) throws Exception {
        String adminId = this.getAdminID(userNumber);
        this.checkLoginNumber(conn, dbType, userNumber, loginNumber);
        SecurityConsoleValidator securityConsoleValidator = new SecurityConsoleValidator(conn, userNumber);
        securityConsoleValidator.validate(password);
        try {
            securityConsoleValidator.updatePassAndLoginNumber(conn, dbType, userNumber, password, loginNumber, adminId);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"auto update error: ", (Throwable)e);
            }
        }
    }

    private String getAdminID(String userNumber) {
        if ("administrator".equalsIgnoreCase(userNumber)) {
            return "00000000-0000-0000-0000-00000000000013B7DE7F";
        }
        if ("sscAdmin".equalsIgnoreCase(userNumber)) {
            return "Wp3rRSFxRCaPFjuE2apQjRO33n8=";
        }
        if ("authenadmin".equalsIgnoreCase(userNumber)) {
            return "00000000-0000-0000-0000-00000000000113B7DE7F";
        }
        if ("auditadmin".equalsIgnoreCase(userNumber)) {
            return "00000000-0000-0000-0000-00000000000213B7DE7F";
        }
        if ("virtualUser".equalsIgnoreCase(userNumber)) {
            return "IpyedAEWEADgAAmlwKgTMBO33n8=";
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u4fee\u6539\u7528\u6237" + userNumber + "\u7684\u5bc6\u7801\u548c\u767b\u5f55\u540d");
    }

    private void checkLoginNumber(Connection conn, int dbType, String userNumber, String loginNumber) throws Exception {
        ResultSet rowSet;
        String adminId = this.getAdminID(userNumber);
        if (userNumber.equalsIgnoreCase(loginNumber)) {
            throw new UserException(UserException.LOGINNUMBER_CANNOT_EQUAL_NUMBER);
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FID FROM T_PM_User WHERE (UPPER(FNumber) =  '").append(loginNumber.toUpperCase()).append("' ").append(" or UPPER(FLoginNumber) = '").append(loginNumber.toUpperCase()).append("' )");
        if (userNumber != null) {
            sql.append(" AND FID <> '").append(adminId).append("' ");
        }
        if ((rowSet = conn.prepareStatement(sql.toString()).executeQuery()).next()) {
            throw new UserException(UserException.LOGINNUMBER_HASBEEN_USE);
        }
    }
}

