/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class CacheUtil {
    public static final String CACHE_PERM_FUNC = "permission.function";
    public static final String CACHE_PERM_FIELD = "permission.field";
    public static final String CACHE_PERM_DATA = "permission.data";
    public static final String CACHE_PERM_RULE = "permission.rule";
    public static final String CACHE_USER = "permission.user";
    private static Logger logger = Logger.getLogger((String)CacheUtil.class.getName());

    public static boolean isEnableCache() {
        return true;
    }

    public static void clearBizCache(BOSObjectType bosType) {
        CacheServiceFactory.getInstance().discardType(bosType);
    }

    public static void clearRuleCache() {
        CustomCacheService cacheService = new CustomCacheService(CACHE_PERM_RULE);
        cacheService.removeAll();
        cacheService = new CustomCacheService(CACHE_PERM_DATA);
        cacheService.removeAll();
    }

    public static void clearCacheByType(String cacheType) {
        CustomCacheService cacheService = new CustomCacheService(cacheType);
        cacheService.removeAll();
    }

    public static void clearCacheAllUsers() {
        CacheUtil.clearCacheByType(CACHE_PERM_FUNC);
        CacheUtil.clearCacheByType(CACHE_PERM_FIELD);
        CacheUtil.clearCacheByType(CACHE_PERM_DATA);
        CacheUtil.clearCacheByType(CACHE_PERM_RULE);
    }

    public static void clearCache4User(String cacheType, IObjectPK userPK) {
        CustomCacheService cacheService = new CustomCacheService(cacheType);
        cacheService.hdel(userPK.toString());
    }

    public static void clearCache4User(IObjectPK userPK) {
        CacheUtil.clearCache4User(CACHE_PERM_FUNC, userPK);
        CacheUtil.clearCache4User(CACHE_PERM_FIELD, userPK);
        CacheUtil.clearCache4User(CACHE_PERM_DATA, userPK);
        CacheUtil.clearCache4User(CACHE_PERM_RULE, userPK);
    }

    public static void clearCache4Users(IObjectPK[] userPKs) {
        for (IObjectPK userPK : userPKs) {
            CacheUtil.clearCache4User(userPK);
        }
    }

    public static String getCacheKey(String cacheType, IObjectPK userPK, Object[] params) {
        if (!CacheUtil.isEnableCache()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = params.length;
        for (int i = 0; i < length; ++i) {
            sb.append(StringUtils.cnulls((Object)params[i]));
        }
        StringBuffer head = new StringBuffer();
        head.append("1#").append(userPK.toString()).append("#");
        return head.toString() + Utils.transMD5((String)sb.toString());
    }

    public static String getCacheKey(Object[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append("0#");
        int length = params.length;
        for (int i = 0; i < length; ++i) {
            sb.append(StringUtils.cnulls((Object)params[i]));
        }
        return "0#" + Utils.transMD5((String)sb.toString());
    }

    public static String array2Str(Object[] params) {
        StringBuffer sb = new StringBuffer();
        int length = params.length;
        for (int i = 0; i < length; ++i) {
            sb.append(StringUtils.cnulls((Object)params[i]));
        }
        return sb.toString();
    }

    public static Object getCacheValue(String cacheType, String key) {
        if (!CacheUtil.isEnableCache()) {
            return null;
        }
        CustomCacheService cacheService = new CustomCacheService(cacheType);
        String[] keys = key.split("#");
        if ("1".equals(keys[0])) {
            return cacheService.hget(keys[1], key.substring(keys[1].length() + 3));
        }
        return cacheService.get(key);
    }

    public static void putCacheValue(String cacheType, String key, Object obj) {
        if (!CacheUtil.isEnableCache()) {
            return;
        }
        CustomCacheService cacheService = new CustomCacheService(cacheType);
        String[] keys = key.split("#");
        if ("1".equals(keys[0])) {
            cacheService.hset(keys[1], key.substring(keys[1].length() + 3), obj);
        } else {
            cacheService.put(key, obj);
        }
    }

    public static UserInfo getCacheUserInfo(Context ctx, String userPK) throws BOSException, EASBizException {
        UserInfo user = null;
        if (user == null) {
            IUser iUser = null;
            iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
            user = iUser.getUserInfo((IObjectPK)new ObjectStringPK(userPK));
        }
        return user;
    }

    public static void updateCacheOfUserInfo(Context ctx, String userPK) {
        if (!CacheUtil.isEnableCache()) {
            return;
        }
        CustomCacheService cacheService = new CustomCacheService(CACHE_USER);
        UserInfo user = null;
        try {
            IUser iUser = null;
            iUser = ctx == null ? UserFactory.getRemoteInstance() : UserFactory.getLocalInstance(ctx);
            user = iUser.getUserInfo((IObjectPK)new ObjectStringPK(userPK));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (user == null) {
            if (cacheService.contains(userPK)) {
                cacheService.remove(userPK);
            }
        } else {
            cacheService.put(userPK, user);
        }
    }

    public static void main(String[] args) {
    }
}

