/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.xt;

import com.kingdee.util.StringUtils;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class RSAUtils {
    private static final Logger logger = Logger.getLogger(RSAUtils.class);

    public static PrivateKey restorePrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static PublicKey restorePublicKey(byte[] bytes) throws Exception {
        X509EncodedKeySpec pkcs = new X509EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(pkcs);
    }

    public static byte[] encrypt(byte[] src, Key key) throws Exception {
        Cipher cipher = RSAUtils.getCipher("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return cipher.doFinal(src);
    }

    public static String decrypt(String input, Key key) throws Exception {
        byte[] base64Data = Base64.decodeBase64((byte[])input.getBytes("utf-8"));
        byte[] decrptedData = RSAUtils.deEncryptLarger(base64Data, key);
        return new String(decrptedData, "UTF-8");
    }

    public static byte[] deEncrypt(byte[] dest, Key key) throws Exception {
        Cipher cipher = RSAUtils.getCipher("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        return cipher.doFinal(dest);
    }

    public static String encryptString(String dataStr, Key key) throws Exception {
        byte[] data = dataStr.getBytes("UTF-8");
        byte[] result = RSAUtils.encryptLarger(data, key);
        return new String(Base64.encodeBase64((byte[])result), "UTF-8");
    }

    public static byte[] encryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = RSAUtils.getRSACipher();
        rsa.init(1, key);
        SecureRandom random = new SecureRandom();
        byte[] secretKey = new byte[16];
        random.nextBytes(secretKey);
        Cipher aes = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(1, k);
        byte[] ciphedKey = rsa.doFinal(secretKey);
        byte[] ciphedData = aes.doFinal(data);
        byte[] result = new byte[128 + ciphedData.length];
        System.arraycopy(ciphedKey, 0, result, 0, 128);
        System.arraycopy(ciphedData, 0, result, 128, ciphedData.length);
        return result;
    }

    private static Cipher getCipher(String type) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(type, "SunJCE");
            return cipher;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        try {
            cipher = Cipher.getInstance(type);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return cipher;
    }

    public static byte[] deEncryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = RSAUtils.getCipher("RSA");
        rsa.init(2, key);
        byte[] secretKeyData = new byte[128];
        System.arraycopy(data, 0, secretKeyData, 0, secretKeyData.length);
        byte[] cipherData = new byte[data.length - secretKeyData.length];
        System.arraycopy(data, secretKeyData.length, cipherData, 0, cipherData.length);
        byte[] secretKey = rsa.doFinal(secretKeyData);
        Cipher aes = RSAUtils.getCipher("AES");
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(2, k);
        byte[] deciphedData = aes.doFinal(cipherData);
        return deciphedData;
    }

    public static String entryPwd(String userName, String pwd) throws Exception {
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)pwd)) {
            return "";
        }
        int length = userName.length();
        if (length < 8) {
            for (int i = 0; i < 8 - length && (userName = userName + "\u0000").length() != 8; ++i) {
            }
        }
        byte[] keybts = new byte[8];
        System.arraycopy(userName.getBytes("utf-8"), 0, keybts, 0, 8);
        byte[] src = pwd.getBytes("utf-8");
        SecretKeySpec deskey = new SecretKeySpec(keybts, "DES");
        Cipher cipher = RSAUtils.getCipher("DES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(keybts);
        cipher.init(1, (Key)deskey, iv);
        byte[] encryptBts = cipher.doFinal(src);
        return new String(Base64.encodeBase64((byte[])encryptBts), "utf-8");
    }

    public static Cipher getRSACipher() {
        Cipher rsa = null;
        try {
            rsa = Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"this should never happen", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)"this should never happen", (Throwable)e);
        }
        return rsa;
    }
}

