/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.showdata.showDataStrategy;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.risk.ModelOtherEntryInfo;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.ShowStyle;
import com.kingdee.eas.base.risk.SrcDataType;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.showdata.ShowDataInfo;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.AbstractShowDataStrategy;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.GetValueAdapterOutData;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.GetValueAdapterRiskfactor;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.GetValueAdapterSQL;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.ISetValueAdapter;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.SetValueAdapterHyperlinks;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.SetValueAdapterText;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.ShowDataExprStrategy;
import com.kingdee.eas.base.risk.service.showdata.showDataStrategy.ShowDataSQLStrategy;

public class ShowDataFactory {
    public static ShowDataInfo getShowData(Context ctx, RiskParam param, RiskModelInfo riskModelInfo, ModelOtherEntryInfo entryInfo) throws RiskException {
        ISetValueAdapter iSetValueAdapter;
        ShowStyle showStyle = entryInfo.getShowStyle();
        SrcDataType srcDataType = entryInfo.getSrcDataType();
        if (ShowStyle.text.equals((Object)showStyle)) {
            iSetValueAdapter = new SetValueAdapterText();
        } else if (ShowStyle.links.equals((Object)showStyle)) {
            iSetValueAdapter = new SetValueAdapterHyperlinks();
        } else {
            throw new RiskException(RiskException.EXCEPTIONRISK);
        }
        AbstractShowDataStrategy strategy = null;
        if (SrcDataType.SQL.equals((Object)srcDataType)) {
            GetValueAdapterSQL iGetValueAdapter = new GetValueAdapterSQL();
            strategy = new ShowDataSQLStrategy(iGetValueAdapter, iSetValueAdapter);
        } else if (SrcDataType.riskfactor.equals((Object)srcDataType)) {
            GetValueAdapterRiskfactor iGetValueAdapter = new GetValueAdapterRiskfactor();
            strategy = new ShowDataExprStrategy(iGetValueAdapter, iSetValueAdapter);
        } else if (SrcDataType.outdata.equals((Object)srcDataType)) {
            GetValueAdapterOutData iGetValueAdapter = new GetValueAdapterOutData();
            strategy = new ShowDataExprStrategy(iGetValueAdapter, iSetValueAdapter);
        } else {
            throw new RiskException(RiskException.EXCEPTIONRISK);
        }
        return strategy.getShowDataInfo(ctx, param, riskModelInfo, entryInfo);
    }
}

