/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.tools.smecloud.apigw.util;

import java.sql.Timestamp;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    private final long period;
    private volatile long now;

    public TimeUtil(long period) {
        this.period = period;
        this.now = System.currentTimeMillis();
        this.scheduleClockUpdating();
    }

    private void scheduleClockUpdating() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "System Clock");
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> {
            this.now = System.currentTimeMillis();
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    private long currentTimeMillis() {
        return this.now;
    }

    private static TimeUtil instance() {
        return InstanceHolder.INSTANCE;
    }

    public static long now() {
        return TimeUtil.instance().currentTimeMillis();
    }

    public static String nowDate() {
        return new Timestamp(TimeUtil.instance().currentTimeMillis()).toString();
    }

    private static class InstanceHolder {
        public static final TimeUtil INSTANCE = new TimeUtil(1L);

        private InstanceHolder() {
        }
    }
}

