/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.IReportServer;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportProperty;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;

public class ReportUtil
extends JComponent {
    private static final long serialVersionUID = 2179639165449762007L;

    public static HashMap getOneRowData(IRowSet rs) throws SQLException {
        IRowSetMetaData rowSetMeta = rs.getRowSetMetaData();
        int j = rowSetMeta.getColumnCount();
        HashMap<String, Object> map = new HashMap<String, Object>(j);
        for (int k = 1; k <= j; ++k) {
            map.put(rowSetMeta.getColumnName(k).toLowerCase(), rs.getObject(k));
        }
        return map;
    }

    public void showReport(IReport report, KDTable table) {
        if (report == null) {
            return;
        }
        if (null == table) {
            table = new KDTable();
        }
        table.getHeadMergeManager().setMergeMode(3);
        table.getGroupManager().setGroup(true);
        ReportHeader header = report.getReportHeader();
        this.buildTableColumn(table, header);
        int maxLevel = header.getMaxLevel();
        for (int i = 0; i < maxLevel; ++i) {
            table.addHeadRow();
        }
        this.buildTableHeader(table, null, header, maxLevel);
    }

    public void showReport(IReport report, KDTable table, KDPanel panelTitle) {
        this.showReport(report, table);
        this.buildReportTitle(report.getReportTitles(), panelTitle);
    }

    public boolean showReport(String reportID, KDTable table) throws Exception {
        boolean bresult = false;
        if (reportID.equals("")) {
            return bresult;
        }
        if (null == table) {
            table = new KDTable();
        }
        if (this.getBasReportInfo(reportID, table, null)) {
            bresult = true;
        }
        return bresult;
    }

    public boolean showReport(String reportID, KDTable table, KDPanel panelTitle) throws Exception {
        boolean bresult = false;
        if (reportID.equals("")) {
            return bresult;
        }
        if (null == table) {
            table = new KDTable();
        }
        if (null == panelTitle) {
            panelTitle = new KDPanel();
        }
        if (this.getBasReportInfo(reportID, table, panelTitle)) {
            bresult = true;
        }
        return bresult;
    }

    private boolean getBasReportInfo(String sreportid, KDTable table, KDPanel panelTitle) throws Exception {
        ReportProperty reportProperty = new ReportProperty();
        RptParams filter = new RptParams();
        ReportHeader reportHeader = null;
        ReportTitles reportTitles = null;
        boolean bresult = false;
        try {
            IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)reportProperty.getRptSvrClassName(), IReportServer.class);
            HashMap result = server.getData(sreportid, filter);
            reportHeader = (ReportHeader)result.get("reportheader");
            reportTitles = (ReportTitles)result.get("reporttitle");
            table.getHeadMergeManager().setMergeMode(3);
            table.getGroupManager().setGroup(true);
            this.buildTableColumn(table, reportHeader);
            int maxLevel = reportHeader.getMaxLevel();
            for (int i = 0; i < maxLevel; ++i) {
                table.addHeadRow();
            }
            this.buildTableHeader(table, null, reportHeader, maxLevel);
            if (null != panelTitle) {
                this.buildReportTitle(reportTitles, panelTitle);
            }
            bresult = true;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return bresult;
    }

    protected void buildTableHeader(KDTable table, IRow row, ReportHeader header, int maxLevel) {
        ArrayList child = header.getChilds();
        if (child != null) {
            ReportHeader leftChild;
            IRow newRow = table.getHeadRow(header.getLevel());
            newRow.getStyleAttributes().setWrapText(true);
            for (int i = 0; i < child.size(); ++i) {
                this.buildTableHeader(table, newRow, (ReportHeader)child.get(i), maxLevel);
            }
            if (child.size() > 1 && header.getCaption() != null && row != null && (leftChild = header.getMostLeftChild()) != null) {
                ICell cell = row.getCell(leftChild.getFieldName());
                cell.setValue((Object)header.getCaption());
                KDTMergeManager mm = table.getHeadMergeManager();
                mm.mergeBlock(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + header.getAllLeafCount() - 1, 4);
            }
        } else if (row != null) {
            ICell cell = row.getCell(header.getFieldName());
            cell.setValue((Object)header.getCaption());
            KDTMergeManager mm = table.getHeadMergeManager();
            if (maxLevel > header.getLevel()) {
                mm.mergeBlock(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex() + (maxLevel - header.getLevel()), cell.getColumnIndex(), 4);
            }
        }
    }

    protected void buildTableColumn(KDTable table, ReportHeader header) {
        ArrayList arrayList = header.getChilds();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.buildTableColumn(table, (ReportHeader)arrayList.get(i));
            }
        } else {
            IColumn col = table.addColumn();
            if (header.isMergeable()) {
                col.setGroup(true);
                col.setMergeable(true);
            }
            col.setKey(header.getFieldName());
            col.setWidth(header.getWidth());
            StyleAttributes st = col.getStyleAttributes();
            st.setHided(!header.isVisible());
            Styles.HorizontalAlignment align = Styles.HorizontalAlignment.NORMAL;
            switch (header.getAlign()) {
                case 1: {
                    align = Styles.HorizontalAlignment.LEFT;
                    break;
                }
                case 3: {
                    align = Styles.HorizontalAlignment.RIGHT;
                    break;
                }
                case 2: {
                    align = Styles.HorizontalAlignment.CENTER;
                    break;
                }
            }
            st.setHorizontalAlign(align);
        }
    }

    protected void buildReportTitle(ReportTitles reportTitles, KDPanel panelTitle) {
        boolean isExistsTitles = false;
        panelTitle.removeAll();
        panelTitle.setVisible(false);
        if (reportTitles != null) {
            int row = 0;
            int col = 0;
            int maxRows = 0;
            for (int i = 12; i > 0; --i) {
                String sTitle = reportTitles.getTitle(i - 1);
                if (sTitle == null) continue;
                maxRows = (i - 1) / 3 + 1;
                isExistsTitles = true;
                break;
            }
            if (isExistsTitles) {
                TableLayout layout = TableLayout.split((int)maxRows, (int)3);
                panelTitle.setLayout((LayoutManager)layout);
                for (int i = 0; i < 12; ++i) {
                    String sTitle = reportTitles.getTitle(i);
                    if (sTitle == null) continue;
                    KDLabel label = new KDLabel(sTitle);
                    col = i % 3;
                    row = i / 3;
                    panelTitle.add((Component)label, (Object)layout.cell(row, col));
                }
            }
            Rectangle r = (Rectangle)this.getClientProperty("OriginalBounds");
            int y = maxRows * 15 + 10;
            this.add((Component)panelTitle, new KDLayout.Constraints(5, 5, r.width, y + 20 - 5, 13));
            this.add((Component)panelTitle, new KDLayout.Constraints(5, y + 20, r.width - 10, r.height - y - 20 - 5, 15));
            panelTitle.setVisible(isExistsTitles);
        }
    }
}

