/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.IReportConnectQuery;
import com.kingdee.eas.base.report.IReportTree;
import com.kingdee.eas.base.report.IReportViewer;
import com.kingdee.eas.base.report.MenuBarPropertyEvent;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportFactory;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.ReportTreeNode;
import com.kingdee.eas.base.report.ReportTreeNodeInfo;
import com.kingdee.eas.base.report.client.AbstractReportTreeViewerUI;
import com.kingdee.eas.base.report.client.MenuBuilder;
import com.kingdee.eas.base.report.client.ReportQueryDlg;
import com.kingdee.eas.base.report.client.ReportViewerUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public final class ReportTreeViewerUI
extends AbstractReportTreeViewerUI
implements TreeSelectionListener,
TreeWillExpandListener,
TreeExpansionListener,
IReportViewer {
    IReportTree report;
    ReportViewerUI _reportViewUI;
    MenuBuilder menuBuilder = new MenuBuilder((JToolBar)this.toolBar, (JMenu)this.menuEdit);
    ReportQueryDlg filterDlg = ReportQueryDlg.getDefaultReportQueryDlg(this);
    private boolean isInitReport = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onLoad() throws Exception {
        super.onLoad();
        Map ctx = this.getUIContext();
        String uiParam = (String)ctx.get("UIClassParam");
        if (uiParam == null) return;
        this.report = ReportFactory.createTreeReport(uiParam, null);
        this.filterDlg.setTitle(this.report.getReport().getReportProperty().getName());
        if (Boolean.valueOf(String.valueOf(ctx.get("com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_BE_JOINQUERY"))).booleanValue()) {
            RptParams filter = (RptParams)ctx.get("com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_PARAMS");
            HashMap mapData = (HashMap)ctx.get("com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_DATA");
            if (!(this.report instanceof IReportConnectQuery)) throw new ReportException(ReportException.REPORT_NOT_CONNECTQUERY, new Object[]{this.report.getReport().getReportProperty().getName()});
            ((IReportConnectQuery)((Object)this.report)).ConnectQuery(filter, mapData);
        } else if (this.showFilter(this.report.getReport(), true)) {
            this.report.getReport().setFilter(this.filterDlg.getFilter());
        } else {
            this.close();
            return;
        }
        this.report.getReport().setReportViewer(this);
        this.refreshReport();
    }

    protected void close() {
        SysUtil.abort();
    }

    protected void buildReportTitle(ReportTitles reportTitles) {
        boolean isExistsTitles = false;
        this.titlePanel.removeAll();
        this.titlePanel.setVisible(false);
        if (reportTitles != null) {
            int row = 0;
            int col = 0;
            int maxRows = 0;
            for (int i = 12; i > 0; --i) {
                String sTitle = reportTitles.getTitle(i - 1);
                if (sTitle == null) continue;
                maxRows = (i - 1) / 3 + 1;
                isExistsTitles = true;
                break;
            }
            if (isExistsTitles) {
                TableLayout layout = TableLayout.split((int)maxRows, (int)3);
                this.titlePanel.setLayout((LayoutManager)layout);
                for (int i = 0; i < 12; ++i) {
                    String sTitle = reportTitles.getTitle(i);
                    if (sTitle == null) continue;
                    KDLabel label = new KDLabel(sTitle);
                    col = i % 3;
                    row = i / 3;
                    this.titlePanel.add((Component)label, (Object)layout.cell(row, col));
                }
            }
            Rectangle r = (Rectangle)this.getClientProperty("OriginalBounds");
            int y = maxRows * 15 + 10;
            this.add((Component)this.titlePanel, new KDLayout.Constraints(5, 5, r.width, y + 20 - 5, 13));
            this.add((Component)this.splitPaneMain, new KDLayout.Constraints(5, y + 20, r.width - 10, r.height - y - 20 - 5, 15));
            this.titlePanel.setVisible(isExistsTitles);
        }
    }

    private void refreshReport() throws Exception {
        this.report.getReport().Refresh();
        this.showReport(this.report);
    }

    public void showReport(IReportTree report) throws Exception {
        this.report = report;
        this.initTree();
        this.setUITitle(report.getReport().getReportProperty().getName());
    }

    private String getLogActionName(String oprName) {
        return this.getLogActionName(this.report.getReport(), oprName);
    }

    private String getLogActionName(IReport report, String oprName) {
        String op = null;
        int pos = oprName.indexOf(40);
        if (pos >= 0) {
            op = oprName.substring(0, pos);
        }
        if (report != null && report.getReportProperty() != null && report.getReportProperty().getName() != null) {
            op = report.getReportProperty().getName() + "--" + op;
        }
        return op;
    }

    private boolean showFilter(IReport report, boolean useDefaultSolution) throws Exception {
        String filterUIName = report.getFilterPanelName();
        String op = this.getLogActionName(report, this.menuFilter.getText());
        IObjectPK pk = LogUtil.beginLog(null, (String)op, (BOSObjectType)new BOSObjectType("CE4FCE63"), null, (String)op);
        LogUtil.afterLog(null, (IObjectPK)pk);
        if (filterUIName != null) {
            return this.filterDlg.showFilterDialog(filterUIName, useDefaultSolution);
        }
        return true;
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        if (this.showFilter(this.report.getReport(), false)) {
            this.refreshReport();
        }
    }

    private void initTree() throws Exception {
        this.treeMain.removeTreeSelectionListener((TreeSelectionListener)this);
        this.treeMain.removeTreeWillExpandListener((TreeWillExpandListener)this);
        this.treeMain.removeTreeExpansionListener((TreeExpansionListener)this);
        ReportTreeNode treeNode = this.report.getTreeNode();
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)((Object)treeNode)));
        this.treeMain.updateUI();
        this.treeMain.addTreeSelectionListener((TreeSelectionListener)this);
        this.treeMain.addTreeWillExpandListener((TreeWillExpandListener)this);
        this.treeMain.addTreeExpansionListener((TreeExpansionListener)this);
        this.treeMain.expandAllNodes(false, (TreeNode)((Object)treeNode));
        this.treeMain.setSelectionRow(0);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        try {
            DefaultKingdeeTreeNode treeNode;
            ReportTreeNodeInfo nodeInfo;
            if (e.getNewLeadSelectionPath() != null && this.report.onTreeSelectedValueChanged(nodeInfo = (ReportTreeNodeInfo)(treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getUserObject())) {
                if (this._reportViewUI == null) {
                    this._reportViewUI = new ReportViewerUI();
                    this.splitPaneMain.add((Component)this.treeMainView, (Object)"left");
                    this.splitPaneMain.add((Component)((Object)this._reportViewUI), (Object)"right");
                    this._reportViewUI.initLayout();
                    this._reportViewUI.showReport(this.report.getReport());
                }
                this.buildReportTitle(this.report.getReport().getReportTitles());
                if (!this.isInitReport) {
                    int i;
                    for (i = 0; i < this._reportViewUI.getComponentCount(); ++i) {
                        if (!this._reportViewUI.getComponent(i).getName().equals("titlesPanel")) continue;
                        this._reportViewUI.remove(this._reportViewUI.getComponent(i));
                        break;
                    }
                    for (i = 0; i < this._reportViewUI.getComponentCount(); ++i) {
                        if (!this._reportViewUI.getComponent(i).getName().equals("tableMain")) continue;
                        this._reportViewUI.getComponent(i).setBounds(0, 0, this.splitPaneMain.getRightComponent().getWidth(), this.splitPaneMain.getHeight());
                        this._reportViewUI.add(this._reportViewUI.getComponent(i), new KDLayout.Constraints(0, 0, this.splitPaneMain.getRightComponent().getWidth(), this.splitPaneMain.getHeight(), 15));
                        break;
                    }
                    this.isInitReport = true;
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        ReportTreeNode node = (ReportTreeNode)((Object)event.getPath().getLastPathComponent());
        List childNodes = this.report.expandNode(node);
        for (int i = 0; childNodes != null && i < childNodes.size(); ++i) {
            this.treeMain.addNodeInto((MutableTreeNode)((Object)((ReportTreeNode)((Object)childNodes.get(i)))), (MutableTreeNode)((Object)node));
        }
        if (node.getNeedExpandNode() != null) {
            this.treeMain.removeNodeFromParent((MutableTreeNode)((Object)node.getNeedExpandNode()));
            node.clearNeedExpandNode();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    @Override
    public void addBarItem(String name, String caption, String description, String toolTipText, String imageKey, Object image, String shortcut, boolean enabled, boolean visible, boolean beginGroup) {
        if (!this.menuBuilder.isExistsMenu(name)) {
            IItemAction action = (IItemAction)ActionProxyFactory.getProxy((Object)((Object)new ActionUserButton((IUIObject)this, name, caption, description)), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext());
            this.menuBuilder.addBarItem(name, caption, description, toolTipText, imageKey, image, beginGroup, action);
            if (shortcut != null && shortcut.toString() != "") {
                action.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke(shortcut));
            }
        }
    }

    @Override
    public CellEvent getCurrentCell() {
        return this._reportViewUI == null ? null : this._reportViewUI.getCurrentCell();
    }

    @Override
    public HashMap getCurrentRow() throws SQLException {
        return this._reportViewUI == null ? null : this._reportViewUI.getCurrentRow();
    }

    @Override
    public void removeBarItem(String name) {
    }

    @Override
    public MenuBarPropertyEvent getBarProperty(String name, int propName) {
        return this.menuBuilder.getMenuProperty(name, propName);
    }

    @Override
    public void setBarProperty(MenuBarPropertyEvent event) {
        this.menuBuilder.setMenuProperty(event);
    }

    @Override
    public void setActionVisiable(String actionName, boolean visiable) {
        ItemAction action = this.getActionManager().getAction(actionName);
        if (action != null) {
            action.setVisible(visiable);
        }
    }

    @Override
    public void setActionEnable(String actionName, boolean enable) {
        ItemAction action = this.getActionManager().getAction(actionName);
        if (action != null) {
            action.setEnabled(enable);
        }
    }

    public void actionUserBotton_actionPerformed(ActionEvent e) throws Exception {
        this.report.getReport().getReportEventProxy().fireOnMenuClick(((Component)e.getSource()).getName());
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshReport();
    }

    @Override
    public ArrayList getSelectRows() throws SQLException {
        return this._reportViewUI == null ? null : this._reportViewUI.getSelectRows();
    }

    @Override
    public void Refresh() throws Exception {
        this.refreshReport();
    }

    @Override
    public IRowSet getDataSource() throws Exception {
        return null;
    }

    @Override
    public void showEditUI(String keyFieldName, String editUIName) throws Exception {
    }

    protected class ActionUserButton
    extends ItemAction {
        public ActionUserButton(IUIObject uiObject, String name, String caption, String description) {
            super(uiObject);
            this.putValue("ShortDescription", caption);
            this.putValue("LongDescription", description);
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            ReportTreeViewerUI.this.getUIContext().put("ORG.PK", ReportTreeViewerUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)ReportTreeViewerUI.this, "ActionUserButton", "actionUserBotton_actionPerformed", e);
        }
    }
}

