/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.client.note;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.impl.note.KDNoteRptDesigner;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_ReportEnv;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesignListener;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportProperty;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Component;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ReportNotePrintHelper {
    private static Logger logger = Logger.getLogger(ReportNotePrintHelper.class);
    public static final HashMap ReportHeaderDataTypeMap = new HashMap();

    protected MetaClass parseReportHeader(IReport report) {
        MetaClass mc = new MetaClass();
        String reportName = report.getReportProperty().getName();
        mc.setNamex(reportName, DataDefType.BOS_QUERY.getName());
        mc.setAlias(reportName);
        mc.setExpr(reportName);
        ReportHeader header = report.getReportHeader();
        HashMap child = header.getAllChilds();
        for (Object key : child.keySet()) {
            ReportHeader childHeader = (ReportHeader)child.get(key);
            mc.addField(this.parseHeader2Field(childHeader));
        }
        return mc;
    }

    private MetaField parseHeader2Field(ReportHeader reportHeader) {
        MetaField field = new MetaField();
        field.setName(reportHeader.getFieldName());
        field.setAlias(reportHeader.getFullCaption());
        field.setType((DataType)ReportHeaderDataTypeMap.get(new Integer(reportHeader.getType())));
        return field;
    }

    protected MetaClass parseReportTitles(IReport report) {
        ReportTitles titles = report.getReportTitles();
        if (titles != null) {
            MetaClass mc = new MetaClass();
            String name = report.getReportProperty().getName() + "-title";
            mc.setNamex(name, DataDefType.BOS_QUERY.getName());
            mc.setDesc(name);
            mc.setExpr(name);
            for (int i = 0; i < 12; ++i) {
                String title = titles.getTitle(i);
                if (title == null) continue;
                MetaField field = new MetaField();
                field.setName("title" + i);
                field.setAlias("\u6807\u9898" + i);
                field.setType(DataType.STRING);
                mc.addField(field);
            }
            return mc;
        }
        return null;
    }

    public void design(IReport report, Component owner, IReportDesignListener eventListner) throws KDRSException, ReportException {
        KDNoteRptDesigner rptDsg = new KDNoteRptDesigner(owner);
        HashMap<String, MetaClass> args = new HashMap<String, MetaClass>();
        MetaClass mc = this.parseReportHeader(report);
        args.put(ReportUtil.ARG_META_CLASS, mc);
        IBizContent content = KDNoteHelper.getBizContent();
        String objPath = this.getFullPath(report, ".kdrs-form");
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.put("category", "kdrs-form");
        atts.put("name", PathUtil.getLastName((String)objPath));
        atts.put("create_policy", new Integer(2));
        boolean isNew = true;
        if (!content.isExist(objPath)) {
            content.create(objPath, atts);
            isNew = true;
        } else {
            isNew = false;
        }
        BizContent_ReportEnv rptEnv = new BizContent_ReportEnv(content);
        rptEnv.setObjPath(objPath);
        rptDsg.setReportEnv((IReportEnv)rptEnv);
        rptDsg.design(isNew, args);
    }

    private String getFullPath(IReport report, String ext) {
        ReportProperty property = report.getReportProperty();
        return PathUtil.makeChildPath((String)"/EAS_Note.kdrs/", (String)(this.getTemplatePath(property) + "/" + this.getFileName(property, ext)));
    }

    private String getTemplatePath(ReportProperty property) {
        if (property.getRptSvrClassName().length() > 0) {
            return PathUtil.makeChildPath((String)"/report", (String)property.getRptSvrClassName().replace('.', '/'));
        }
        return PathUtil.makeChildPath((String)"/report", (String)property.getReportClassName().replace('.', '/'));
    }

    private String getFileName(ReportProperty property, String ext) {
        if (property.getRptSvrClassName().length() > 0) {
            return PathUtil.getLastName((String)property.getRptSvrClassName().replace('.', '/')) + ext;
        }
        return PathUtil.getLastName((String)property.getReportClassName().replace('.', '/')) + ext;
    }

    public void printPreview(IReport report, Component owner) {
        KDNoteHelper helper = new KDNoteHelper();
        helper.printPreview(this.getTemplatePath(report.getReportProperty()), (Object)new MyDataProvider(report), owner);
    }

    public void print(IReport report, Component owner) {
        KDNoteHelper helper = new KDNoteHelper();
        helper.print(this.getTemplatePath(report.getReportProperty()), (Object)new MyDataProvider(report), owner);
    }

    public void writeMetaClass(IReport report) throws KDRSException {
        ReportProperty property = report.getReportProperty();
        String metaFilePathText = this.getTemplatePath(property) + "/" + this.getFileName(property, ".bos-query");
        MetaClass mc = this.parseReportHeader(report);
        this.innerWriteMetaClass(mc, metaFilePathText, report.getReportProperty().getName());
        metaFilePathText = this.getTemplatePath(property) + "/" + this.getFileName(property, "_title.bos-query");
        mc = this.parseReportTitles(report);
        this.innerWriteMetaClass(mc, metaFilePathText, report.getReportProperty().getName() + "title");
    }

    protected void innerWriteMetaClass(MetaClass mc, String metaFilePathText, String metaFileAlias) throws KDRSException {
        String fullPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs/", (String)metaFilePathText);
        IBizContent content = KDNoteHelper.getBizContent();
        if (!content.isExist(fullPath)) {
            HashMap<String, Object> atts = new HashMap<String, Object>();
            atts.put("category", "bos-query");
            atts.put("name", PathUtil.getLastName((String)metaFilePathText));
            atts.put("alias", "#1");
            atts.put("alias.zh_CN", metaFileAlias);
            atts.put("create_policy", new Integer(2));
            content.create(fullPath, atts);
        }
        KDNoteHelper helper = new KDNoteHelper();
        helper.writeMetaClass(mc, metaFilePathText);
    }

    static {
        ReportHeaderDataTypeMap.put(new Integer(1), DataType.STRING);
        ReportHeaderDataTypeMap.put(new Integer(2), DataType.DECIMAL);
        ReportHeaderDataTypeMap.put(new Integer(3), DataType.INTEGER);
        ReportHeaderDataTypeMap.put(new Integer(4), DataType.DATETIME);
        ReportHeaderDataTypeMap.put(new Integer(5), DataType.DATETIME);
        ReportHeaderDataTypeMap.put(new Integer(6), DataType.DECIMAL);
    }

    class MyDataProvider
    extends AbstractPrintDataProvider {
        private IReport report;

        public MyDataProvider(IReport report) {
            this.report = report;
        }

        public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
            String id = dataSource.getId();
            if (id.endsWith("-title.bos-query") || id.endsWith("-\u62a5\u8868\u6807\u9898.bos-query")) {
                ReportTitles titles = this.report.getReportTitles();
                if (titles != null) {
                    String title;
                    int i;
                    DynamicRowSet rs = new DynamicRowSet(titles.getTitlesSize());
                    int j = 1;
                    for (i = 0; i < 12; ++i) {
                        title = titles.getTitle(i);
                        if (title == null) continue;
                        rs.setColInfo(j++, "title" + i, "\u5b57\u6bb5" + i, 1, null);
                    }
                    rs.moveToInsertRow();
                    j = 1;
                    for (i = 0; i < 12; ++i) {
                        title = titles.getTitle(i);
                        if (title == null) continue;
                        rs.updateString(j++, title);
                    }
                    rs.insertRow();
                    rs.beforeFirst();
                    return rs;
                }
                return null;
            }
            this.report.getData().beforeFirst();
            return this.report.getData();
        }
    }
}

