/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.formatcondition;

import com.kingdee.eas.base.report.ReportHeader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;
import javax.sql.RowSet;

public class ReportFromatCell {
    public static String getFormatString(ReportHeader header, Object cellValue, RowSet rsData) throws Exception {
        String sText;
        switch (header.getType()) {
            case 2: {
                sText = ReportFromatCell.getNumericFormatString(header, cellValue, rsData);
                break;
            }
            default: {
                sText = "";
            }
        }
        return sText;
    }

    private static String getNumericFormatString(ReportHeader header, Object cellValue, RowSet rsData) throws SQLException {
        String decimalField = header.getDecimalField();
        int fractionDigits = -1;
        fractionDigits = decimalField != null && !decimalField.trim().equals("") ? rsData.getInt(decimalField) : header.getDecimal();
        String temp = "";
        for (int i = 0; i < fractionDigits; ++i) {
            temp = temp + '0';
        }
        if (header.getFormatstring().toString().trim().length() > 0) {
            temp = temp != "" ? header.getFormatstring() + "." + temp : header.getFormatstring();
            temp = "%r{" + temp + "}f";
        } else if (fractionDigits >= 0) {
            temp = temp == "" ? "%r{#,##0}f" : "%r{#,##0." + temp + "}f";
        }
        return temp;
    }

    public static String getFormatValue(ReportHeader header, Object cellValue, RowSet rsData) throws Exception {
        if (cellValue == null) {
            return null;
        }
        String sText = null;
        switch (header.getType()) {
            case 2: {
                sText = ReportFromatCell.formatNumericTypeData(header, (BigDecimal)cellValue, rsData);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                sText = ReportFromatCell.formatLongDateTime(header, cellValue, rsData);
                break;
            }
            case 4: {
                sText = ReportFromatCell.formatShortDateTime(header, cellValue, rsData);
                break;
            }
            case 6: {
                break;
            }
            default: {
                sText = cellValue.toString();
            }
        }
        return sText;
    }

    private static String formatPercent(ReportHeader header, Object cellValue, RowSet rsData) throws Exception {
        Locale l = Locale.getDefault();
        Date dt = null;
        if (cellValue.toString().trim().length() > 0) {
            return DateFormat.getDateInstance(2, l).format(dt);
        }
        return cellValue.toString();
    }

    private static String formatShortDateTime(ReportHeader header, Object cellValue, RowSet rsData) throws Exception {
        DateFormat df = DateFormat.getDateInstance();
        Locale l = Locale.getDefault();
        Date dt = null;
        if (cellValue.toString().trim().length() > 0) {
            dt = df.parse(cellValue.toString());
            return DateFormat.getDateInstance(2, l).format(dt);
        }
        return cellValue.toString();
    }

    private static String formatLongDateTime(ReportHeader header, Object cellValue, RowSet rsData) throws Exception {
        DateFormat df = DateFormat.getDateInstance();
        Locale l = Locale.getDefault();
        Date dt = null;
        if (cellValue.toString().trim().length() > 0) {
            dt = df.parse(cellValue.toString());
            return DateFormat.getDateTimeInstance(2, 2, l).format(dt);
        }
        return cellValue.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String formatNumericTypeData(ReportHeader header, BigDecimal cellValue, RowSet rsData) throws Exception {
        String decimalField = header.getDecimalField();
        int fractionDigits = -1;
        if (decimalField != null && !decimalField.trim().equals("")) {
            Object decimalValue = rsData.getObject(decimalField);
            if (decimalValue instanceof Integer) {
                fractionDigits = (Integer)decimalValue;
            } else {
                if (!(decimalValue instanceof BigDecimal)) throw new Exception("\u7cbe\u5ea6\u5b57\u6bb5\u975e\u6574\u578b");
                fractionDigits = ((BigDecimal)decimalValue).intValue();
            }
        } else {
            fractionDigits = header.getDecimal();
        }
        if (header.getFormatstring().toString().trim().length() > 0) {
            String temp = "";
            for (int i = 0; i < fractionDigits; ++i) {
                temp = temp + '0';
            }
            temp = temp != "" ? header.getFormatstring() + "." + temp : header.getFormatstring();
            return ReportFromatCell.formatDecimal(cellValue, temp);
        }
        if (fractionDigits < 0) return cellValue.toString();
        return ReportFromatCell.formatDecimal(cellValue, fractionDigits);
    }

    private static String formatDecimal(BigDecimal data, int fractionDigits) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMaximumFractionDigits(fractionDigits);
        format.setMinimumFractionDigits(fractionDigits);
        return format.format(data);
    }

    private static String formatDecimal(BigDecimal data, String formatString) {
        if (formatString.toString().trim().length() > 0) {
            DecimalFormat percentFormat = new DecimalFormat(formatString);
            return percentFormat.format(data);
        }
        return data.toString();
    }
}

