/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.eas.base.security.BOTPSignConfigInfo;
import com.kingdee.eas.base.security.DynamicCardSupplierEnum;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardConfigInfo;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardServerConfigUtil;
import com.kingdee.eas.base.security.dynamiccard.strategy.DynamicCardStratrgy;
import com.kingdee.eas.base.security.dynamiccard.strategy.DynamicCardStratrgyManager;
import com.kingdee.eas.base.security.fingerprint.FingerprintClientConfigUtil;
import com.kingdee.eas.base.security.fingerprint.FingerprintConfigInfo;
import com.kingdee.eas.base.security.fingerprint.FingerprintConfigUtil;
import com.kingdee.eas.base.security.machinecode.MachineCodeConfigUtil;
import com.kingdee.eas.base.security.machinecode.MachineCodeDBUtil;
import com.kingdee.eas.base.security.usbkey.UsbkeyConfigInfo;
import com.kingdee.eas.base.security.util.PermissionParameterConfigUtil;
import com.kingdee.eas.base.security.util.PropertiesUtil;
import com.kingdee.eas.base.security.util.SecurityAuthConfigUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SecurityAuthParamManager
extends AbstractBOSObject
implements ISecurityAuthParamManager {
    private static Logger logger = Logger.getLogger(SecurityAuthParamManager.class);
    private static Properties permissionParameter = null;
    private static XMLConfiguration securityConfig = null;
    private static DynamicCardStratrgy dynamicCardStratrgy = null;
    private static BOTPSignConfigInfo botpSignConfigInfo;
    private static String enableEncrypt;
    private static String disableEncrypt;

    public SecurityAuthParamManager() {
        this.registerInterface(ISecurityAuthParamManager.class, this);
    }

    public SecurityAuthParamManager(Context ctx) {
        super(ctx);
        this.registerInterface(ISecurityAuthParamManager.class, this);
    }

    public final Properties getPermissionParameter() {
        if (permissionParameter == null) {
            try {
                permissionParameter = PermissionParameterConfigUtil.getPermissionParam();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return permissionParameter;
    }

    public final XMLConfiguration getSecurityConfiguration() {
        if (securityConfig == null) {
            securityConfig = SecurityAuthConfigUtil.loadConfigFile();
        }
        return securityConfig;
    }

    public final DynamicCardStratrgy getDynamicCardStratrgy(DynamicCardSupplierEnum supplierEnum) {
        dynamicCardStratrgy = DynamicCardStratrgyManager.getInstance().getStratrgy(supplierEnum);
        return dynamicCardStratrgy;
    }

    @Override
    public final DynamicCardConfigInfo getDynamicCardConfigInfo(DynamicCardSupplierEnum supplier) {
        DynamicCardConfigInfo configInfo;
        String dynamicCardSupplierClass = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.DYNAMIC_CARD_PWD_CHECK_CLASS);
        if (StringUtils.isEmpty((String)dynamicCardSupplierClass)) {
            dynamicCardSupplierClass = "com.kingdee.eas.base.permission.card.HaiYueCardPwdCheck";
        }
        if (supplier == null && (supplier = DynamicCardSupplierEnum.getEnum(dynamicCardSupplierClass)) == null) {
            supplier = DynamicCardSupplierEnum.CUSTOM;
        }
        try {
            configInfo = this.getDynamicCardStratrgy(supplier).getDynamicCardConfigInfo();
        }
        catch (IOException e) {
            logger.error((Object)e);
            configInfo = new DynamicCardConfigInfo();
        }
        configInfo.setDynamicCardSupplierClass(dynamicCardSupplierClass);
        String userNumberType = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.DYNAMIC_CARD_USER_NUMBER_TYPE);
        if (StringUtils.isEmpty((String)userNumberType)) {
            userNumberType = "1";
        }
        configInfo.setUserNumberType(userNumberType);
        return configInfo;
    }

    @Override
    public final void storeDynamicCardConfigInfo(DynamicCardConfigInfo configInfo) throws Exception {
        if (!StringUtils.isEmpty((String)configInfo.getDynamicCardSupplierClass())) {
            this.getPermissionParameter().setProperty(PermissionParameterConfigUtil.DYNAMIC_CARD_PWD_CHECK_CLASS, configInfo.getDynamicCardSupplierClass());
        }
        if (!StringUtils.isEmpty((String)configInfo.getUserNumberType())) {
            this.getPermissionParameter().setProperty(PermissionParameterConfigUtil.DYNAMIC_CARD_USER_NUMBER_TYPE, configInfo.getUserNumberType());
        }
        PermissionParameterConfigUtil.storePermissionParam(permissionParameter);
        dynamicCardStratrgy.storeDynamicCardConfigInfo(configInfo);
    }

    @Override
    public UsbkeyConfigInfo getUsbkeyConfigInfo() {
        UsbkeyConfigInfo configInfo = new UsbkeyConfigInfo();
        this.initUsbkeyEncryptInfo();
        String usbkeyUseable = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.USBKEY_USEABLE);
        if (StringUtils.isEmpty((String)usbkeyUseable)) {
            usbkeyUseable = "false";
        }
        usbkeyUseable = StringUtils.isEmpty((String)usbkeyUseable) || StringUtils.equalsIgnoreCase((String)usbkeyUseable, (String)disableEncrypt) ? "false" : (StringUtils.equalsIgnoreCase((String)usbkeyUseable, (String)enableEncrypt) ? "true" : "unknown");
        configInfo.setUsbkeyUseable(usbkeyUseable);
        String usbkeySupplierClass = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.USBKEYIMP);
        if (StringUtils.isEmpty((String)usbkeySupplierClass)) {
            usbkeySupplierClass = "com.kingdee.eas.base.permission.service.helper.ekey.EUsbKeyBaseOperatorImpl";
        }
        configInfo.setUsbkeySupplierClass(usbkeySupplierClass);
        String webComponent = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.WEB_COMPONENT);
        if (StringUtils.isEmpty((String)webComponent)) {
            webComponent = "";
        }
        configInfo.setWebComponent(webComponent);
        return configInfo;
    }

    @Override
    public void storeUsbkeyConfigInfo(UsbkeyConfigInfo configInfo) throws Exception {
        if (configInfo.getUsbkeyUseable() != null) {
            String result = CryptoUtil.encrypt((String)configInfo.getUsbkeyUseable());
            logger.error((Object)("usbkey_useable config changed:real:" + configInfo.getUsbkeyUseable() + ",encrypt:" + result));
            this.getPermissionParameter().setProperty(PermissionParameterConfigUtil.USBKEY_USEABLE, result);
        }
        if (configInfo.getUsbkeySupplierClass() != null) {
            this.getPermissionParameter().setProperty(PermissionParameterConfigUtil.USBKEYIMP, configInfo.getUsbkeySupplierClass());
        }
        if (configInfo.getWebComponent() != null) {
            this.getPermissionParameter().setProperty(PermissionParameterConfigUtil.WEB_COMPONENT, configInfo.getWebComponent());
        }
        PermissionParameterConfigUtil.storePermissionParam(permissionParameter);
    }

    @Override
    public FingerprintConfigInfo getFingerprintConfigInfo() {
        return FingerprintConfigUtil.getFingerprintConfigInfo(this.getSecurityConfiguration());
    }

    @Override
    public void storeFingerprintConfigInfo(FingerprintConfigInfo configInfo) throws Exception {
        FingerprintConfigUtil.storeFingerprintConfigInfo(this.getSecurityConfiguration(), configInfo);
        FingerprintClientConfigUtil.storeFingerprintConfigInfo(configInfo);
    }

    @Override
    public boolean getMachineCodeAuthState() {
        return MachineCodeDBUtil.getMachineCodeAuthState(this.getContext());
    }

    @Override
    public void storeMachineCodeAuthState(boolean isEnableAuth) {
        MachineCodeDBUtil.storeMachineCodeAuthState(this.getContext(), isEnableAuth);
        if (isEnableAuth) {
            MachineCodeConfigUtil.addMachineRegisterLoginListener();
        }
    }

    @Override
    public boolean isEnableUsbkeyAuth() {
        this.initUsbkeyEncryptInfo();
        String isEnableUsbkeyAuthStr = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.USBKEY_USEABLE);
        return isEnableUsbkeyAuthStr != null && isEnableUsbkeyAuthStr.equals(enableEncrypt);
    }

    @Override
    public boolean isEnableFingerprintAuth() {
        boolean isEnableFingerprintAuth = false;
        FingerprintConfigInfo configInfo = this.getFingerprintConfigInfo();
        if (configInfo != null && !StringUtils.isEmpty((String)configInfo.getEnableFingerprint())) {
            isEnableFingerprintAuth = Boolean.valueOf(configInfo.getEnableFingerprint());
        }
        return isEnableFingerprintAuth;
    }

    @Override
    public boolean isItrusProvider() {
        String implClass = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.USBKEYIMP);
        return implClass != null && "com.kingdee.eas.base.permission.service.helper.usbkeyimpl.MWkeyImp".equals(implClass.trim());
    }

    @Override
    public boolean isCustomizationProvider() {
        String implClass = this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.USBKEYIMP);
        return implClass != null && !"com.kingdee.eas.base.permission.service.helper.usbkeyimpl.MWkeyImp".equals(implClass.trim()) && !"com.kingdee.eas.base.permission.service.helper.ekey.EUsbKeyBaseOperatorImpl".equals(implClass.trim()) && this.isEnableUsbkeyAuth();
    }

    private boolean isNeedUsbKeyPerm() {
        return "true".equalsIgnoreCase(this.getPermissionParameter().getProperty(PermissionParameterConfigUtil.USBKEY_USEABLE));
    }

    @Override
    public File getDynamicCardServerConfigFile() throws IOException {
        return DynamicCardServerConfigUtil.getConifgFile();
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public boolean isVerifySignatureInServer() {
        boolean isVerifySignatureInServer = true;
        String isVerifySignatureInServerStr = this.getPermissionParameter().getProperty("verifySignatureInServer");
        if (!StringUtils.isEmpty((String)isVerifySignatureInServerStr)) {
            isVerifySignatureInServer = Boolean.valueOf(isVerifySignatureInServerStr);
        }
        return isVerifySignatureInServer;
    }

    @Override
    public boolean isGetCertFromRAServe() {
        boolean isGetCertFromRAServe = false;
        String isGetCertFromRAServeStr = this.getPermissionParameter().getProperty("getCertFromRAServe");
        if (!StringUtils.isEmpty((String)isGetCertFromRAServeStr)) {
            isGetCertFromRAServe = Boolean.valueOf(isGetCertFromRAServeStr);
        }
        return isGetCertFromRAServe;
    }

    @Override
    public boolean isEnableIDAuthorize() {
        boolean isEnableIDAuthorize = false;
        String isEnableIDAuthorizeStr = this.getPermissionParameter().getProperty("EnableIDAuthorize");
        if (!StringUtils.isEmpty((String)isEnableIDAuthorizeStr)) {
            isEnableIDAuthorize = Boolean.valueOf(isEnableIDAuthorizeStr);
        }
        return isEnableIDAuthorize;
    }

    @Override
    public boolean isUTF8CharSet() throws IOException {
        return PermissionParameterConfigUtil.getCharset().equalsIgnoreCase("utf-8");
    }

    @Override
    public boolean isItrusCertFromServePath() throws IOException {
        File file = PermissionParameterConfigUtil.getItrusConfigFile();
        if (file.exists()) {
            File fsigncertpath;
            Properties prop = PropertiesUtil.getProperties(file);
            String signcertpath = prop.getProperty("signcertpath");
            int temp = signcertpath.indexOf("${EAS_HOME}");
            if (temp == 0) {
                signcertpath = signcertpath.replace("${EAS_HOME}", System.getProperty("EAS_HOME"));
            }
            return (fsigncertpath = new File(signcertpath)).exists();
        }
        return false;
    }

    @Override
    public BOTPSignConfigInfo getBOTPSignConfigInfo() {
        if (botpSignConfigInfo == null) {
            try {
                botpSignConfigInfo = new BOTPSignConfigInfo();
                Properties signConfig = PermissionParameterConfigUtil.getBOTPSignConfig();
                if (signConfig != null) {
                    Object verifier;
                    Object secret;
                    Object signON = signConfig.get("botp.sign.on");
                    if (signON != null) {
                        botpSignConfigInfo.setOn(Boolean.parseBoolean(signON.toString()));
                    }
                    if ((secret = signConfig.get("botp.sign.secret")) != null) {
                        botpSignConfigInfo.setSecret(secret.toString());
                    } else {
                        logger.error((Object)"config 'botp.sign.secret' is not found, please specific it.");
                    }
                    Object bosTypes = signConfig.get("botp.sign.bostypes");
                    if (bosTypes != null) {
                        HashSet<String> types = new HashSet<String>();
                        if (bosTypes != null) {
                            types.addAll(Arrays.asList((Object[])bosTypes.toString().split(",")));
                        }
                        botpSignConfigInfo.setTypes(types);
                    }
                    if ((verifier = signConfig.get("botp.sign.verifier")) != null) {
                        botpSignConfigInfo.setVerifier(verifier.toString());
                    } else {
                        logger.error((Object)"config 'botp.sign.verifier' is not found, use default.");
                        botpSignConfigInfo.setVerifier("normal");
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return botpSignConfigInfo;
    }

    private void initUsbkeyEncryptInfo() {
        if (SecurityAuthParamManager.isUsbkeyEncryptInfoInited()) {
            return;
        }
        try {
            enableEncrypt = CryptoUtil.encrypt((String)"true");
            disableEncrypt = CryptoUtil.encrypt((String)"false");
        }
        catch (CryptException e) {
            e.printStackTrace();
            logger.error((Object)("\u52a0\u5bc6usbkey\u76f8\u5173\u4fe1\u606f\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage()));
        }
    }

    private static boolean isUsbkeyEncryptInfoInited() {
        return SecurityAuthParamManager.isNotNil(enableEncrypt) && SecurityAuthParamManager.isNotNil(disableEncrypt);
    }

    private static boolean isNotNil(String str) {
        return str != null && str.length() > 0;
    }
}

