/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.security.DynamicCardSupplierEnum;
import com.kingdee.eas.base.security.DynamicCardUserNumberTypeEnum;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.client.AbstractDynamicCardConfigUI;
import com.kingdee.eas.base.security.client.dyncardstrategy.DynamicCardUIStratrgy;
import com.kingdee.eas.base.security.client.dyncardstrategy.DynamicCardUIStratrgyManager;
import com.kingdee.eas.base.security.dynamiccard.DynamicCardConfigInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DynamicCardConfigUI
extends AbstractDynamicCardConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(DynamicCardConfigUI.class);
    public static final String SECURITY_RESOURCE = "com.kingdee.eas.base.security.SecurityResource";
    public static final String PARAM_PANEL_NAME = "paramPanel";
    public static final int WIDTH = 340;
    public static final int BLANK_UI_HEIGTH = 250;
    private ISecurityAuthParamManager manager = SecurityAuthParamManagerFactory.getRemoteInstance();
    private DynamicCardUIStratrgy paramPanel = null;
    private DynamicCardSupplierEnum preSelectedItem = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.userNumberTypeComboBox.addItems(DynamicCardUserNumberTypeEnum.getEnumList().toArray());
        this.dynCardSupplierComboBox.addItems(DynamicCardSupplierEnum.getEnumList().toArray());
        this.serverIPTextField.setDigit(true);
        this.serverIPTextField.setValidCharacters(".");
        this.serverPortTextField.setDigit(true);
    }

    private void initData() {
        DynamicCardConfigInfo configInfo = this.manager.getDynamicCardConfigInfo(null);
        this.initSupplierClass(configInfo.getDynamicCardSupplierClass());
    }

    private void initSupplierClass(String supplierClass) {
        if (!StringUtils.isEmpty((String)supplierClass)) {
            supplierClass = supplierClass.trim();
            Iterator iter = DynamicCardSupplierEnum.getEnumList().iterator();
            boolean isDefaultClass = false;
            while (iter.hasNext()) {
                DynamicCardSupplierEnum supplier = (DynamicCardSupplierEnum)((Object)iter.next());
                if (!supplierClass.equals(supplier.getValue())) continue;
                this.dynCardSupplierComboBox.setSelectedItem((Object)supplier);
                isDefaultClass = true;
                break;
            }
            if (!isDefaultClass) {
                this.dynCardSupplierComboBox.setSelectedItem((Object)DynamicCardSupplierEnum.CUSTOM);
                this.customImplClassTextField.setText(supplierClass);
            }
        }
    }

    protected void enableDynCardAuthCheckBox_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void saveBtn_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateData()) {
            this.saveData();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SECURITY_RESOURCE, (String)"saveSuccessMsg"));
            this.destroyWindow();
        }
    }

    private boolean validateData() {
        boolean result = this.validateCustomImplClass();
        return result;
    }

    private boolean validateCustomImplClass() {
        String customClass = this.customImplClassTextField.getText();
        if (DynamicCardSupplierEnum.CUSTOM.equals(this.dynCardSupplierComboBox.getSelectedItem()) && StringUtils.isEmpty((String)customClass)) {
            MsgBox.showWarning((String)EASResource.getString((String)SECURITY_RESOURCE, (String)"customClassIsEmptyMsg"));
            return false;
        }
        return true;
    }

    private void saveData() throws Exception {
        DynamicCardConfigInfo configInfo = this.paramPanel.getConfigInfoFromUI();
        if (DynamicCardSupplierEnum.CUSTOM.equals(this.dynCardSupplierComboBox.getSelectedItem())) {
            configInfo.setDynamicCardSupplierClass(this.customImplClassTextField.getText());
        } else {
            String supplierClass = ((DynamicCardSupplierEnum)((Object)this.dynCardSupplierComboBox.getSelectedItem())).getValue();
            configInfo.setDynamicCardSupplierClass(supplierClass);
        }
        configInfo.setUserNumberType(((DynamicCardUserNumberTypeEnum)((Object)this.userNumberTypeComboBox.getSelectedItem())).getValue());
        configInfo.setServerIP(this.serverIPTextField.getText());
        configInfo.setServerPort(this.serverPortTextField.getText());
        IObjectPK logPK = LogUtil.beginLog(null, (String)"storeDynamicCardConfigInfo", (BOSObjectType)new BOSObjectType("4735FD26"), null, (String)"\u64cd\u4f5c\u670d\u52a1\u5668\u8bbe\u7f6e", (String)"dynamicCard_server_setting");
        this.manager.storeDynamicCardConfigInfo(configInfo);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    @Override
    protected void cancelBtn_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void dynCardSupplierComboBox_actionPerformed(ActionEvent e) throws Exception {
        DynamicCardSupplierEnum selectSupplier = (DynamicCardSupplierEnum)((Object)this.dynCardSupplierComboBox.getSelectedItem());
        if (this.preSelectedItem == null || !this.preSelectedItem.equals((Object)selectSupplier)) {
            this.clearParamPanel();
            int height = this.addParamPanel(selectSupplier);
            this.invalidate();
            this.repaint();
            this.setWinSize(height);
            this.setImplClass(selectSupplier);
            DynamicCardConfigInfo configInfo = this.manager.getDynamicCardConfigInfo(selectSupplier);
            this.updateData(configInfo);
            this.preSelectedItem = selectSupplier;
        }
    }

    private void clearParamPanel() {
        int index = this.getComponentCount() - 1;
        if (PARAM_PANEL_NAME.equals(this.getComponent(index).getName())) {
            this.remove(index);
        }
    }

    private int addParamPanel(DynamicCardSupplierEnum selectSupplier) {
        this.paramPanel = DynamicCardUIStratrgyManager.getInstance().getUIStratrgy(selectSupplier);
        int height = 0;
        if (this.paramPanel.initPanel(PARAM_PANEL_NAME, 0, this.serverPortLabelCont.getY() + 30)) {
            height = ((KDPanel)this.paramPanel).getHeight();
            this.add((Component)((KDPanel)this.paramPanel));
        }
        return height;
    }

    private void setWinSize(int height) {
        this.setSize(this.getWidth(), this.getHeight() + height);
        Window win = UICommonUtils.getWindow((Component)((Object)this));
        if (win != null) {
            win.setSize(340, 250 + height);
            UICommonUtils.centerWindow((Window)win);
        }
    }

    private void setImplClass(DynamicCardSupplierEnum selectSupplier) {
        if (DynamicCardSupplierEnum.CUSTOM.equals((Object)selectSupplier)) {
            this.customImplClassTextField.setEnabled(true);
        } else {
            this.customImplClassTextField.setEnabled(false);
        }
    }

    private void updateData(DynamicCardConfigInfo configInfo) {
        this.updateUserNumberType(configInfo.getUserNumberType());
        if (configInfo.getServerIP() != null) {
            this.serverIPTextField.setText(configInfo.getServerIP());
        }
        if (configInfo.getServerPort() != null) {
            this.serverPortTextField.setText(configInfo.getServerPort());
        }
        this.paramPanel.setConfigInfoToUI(configInfo);
    }

    private void updateUserNumberType(String userNumberType) {
        if (!StringUtils.isEmpty((String)userNumberType)) {
            userNumberType = userNumberType.trim();
            for (DynamicCardUserNumberTypeEnum userNumberTypeEnum : DynamicCardUserNumberTypeEnum.getEnumList()) {
                if (!userNumberType.equals(userNumberTypeEnum.getValue())) continue;
                this.userNumberTypeComboBox.setSelectedItem((Object)userNumberTypeEnum);
                break;
            }
        }
    }

    protected void disposeUIWindow() {
        Window win = UICommonUtils.getWindow((Component)((Object)this));
        if (win != null) {
            win.dispose();
        }
    }
}

