/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.EASSignatureInfo;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.base.security.client.AbstractSignatureListUI;
import com.kingdee.eas.base.security.provider.IPKIServerExtProvider;
import com.kingdee.eas.base.security.provider.PKIServerAndClientExtFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SignatureListUI
extends AbstractSignatureListUI {
    private static final Logger logger = CoreUIObject.getLogger(SignatureListUI.class);
    private String bosType = null;
    private ArrayList listSelectId = null;
    EntityViewInfo viewInfoSave = null;
    private static String VIEWSIGNBILLMODEL = "VIEWSIGNBILLMODEL";
    private static String VIEWSIGNBILLMODEL_VALUE_CURRENT = "0";
    private static String VIEWSIGNBILLMODEL_VALUE_ALL = "1";
    private static String UTF8 = "UTF-8";

    public void onLoad() throws Exception {
        super.onLoad();
        this.viewInfoSave = (EntityViewInfo)this.mainQuery.clone();
        this.initContext();
        this.setBosTypeFilter();
        this.setObjectIdFilter();
        this.setUserIdFilter();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void initContext() {
        this.bosType = (String)this.getUIContext().get("bosType");
        if (this.bosType == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.security.CASecurityResource", (String)"bosTypeUnknow"));
            SysUtil.abort();
        }
        this.listSelectId = (ArrayList)this.getUIContext().get("listSelectId");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDetail.setIcon(this.btnAttachment.getIcon());
        this.btnVerifySign.setEnabled(true);
        this.btnVerifySign.setIcon(EASResource.getIcon((String)"imgTbtn_encryptview"));
        this.actionVerifySign.setEnabled(true);
        this.btnViewAll.setEnabled(true);
        this.btnViewAll.setIcon(EASResource.getIcon((String)"imgTbtn_cycattemper"));
        this.actionViewAll.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tableSortManagerConfig(this.tblMain);
    }

    protected String getEditUIName() {
        return null;
    }

    protected void execQuery() {
        this.setBosTypeFilter();
        this.setObjectIdFilter();
        this.setUserIdFilter();
        this.setSortByTime();
        super.execQuery();
    }

    private void setBosTypeFilter() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bosType", (Object)this.bosType));
        try {
            this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void setObjectIdFilter() {
        if (this.listSelectId != null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            if (this.mainQuery.getFilter() == null) {
                this.mainQuery.setFilter(new FilterInfo());
            }
            FilterInfo filterInfo = new FilterInfo();
            String idString = ToolUtils.aryToStr((List)this.listSelectId);
            filterInfo.getFilterItems().add(new FilterItemInfo("objectid", (Object)idString, CompareType.INNER));
            try {
                this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private void setUserIdFilter() {
        String strParam = null;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        try {
            strParam = StringUtils.cnulls((String)ParamManager.getParamValue(null, null, (String)VIEWSIGNBILLMODEL));
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        if (strParam.equalsIgnoreCase(VIEWSIGNBILLMODEL_VALUE_CURRENT)) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userInfo.getId().toString()));
            try {
                this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    public void tableSortManagerConfig(KDTable kdTable) {
        KDTSortManager sm = new KDTSortManager(kdTable);
        sm.setSortAuto(true);
        for (int index = 0; index < kdTable.getColumnCount(); ++index) {
            kdTable.getColumn(index).setSortable(true);
        }
    }

    private void setSortByTime() {
        try {
            this.setSortForQuery(new SorterItemInfo("createTime"), this.mainQuery.getSorter().get(0));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private String[] getSelectedPlainText() {
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String[] formatPlainTexts = new String[rowIndexs.length];
        for (int index = 0; index < rowIndexs.length; ++index) {
            Object formatPlainText = this.tblMain.getRow(rowIndexs[index]).getCell("formatPlainText").getValue();
            if (formatPlainText != null) {
                formatPlainTexts[index] = formatPlainText.toString();
                continue;
            }
            logger.error((Object)"\u6ca1\u6709\u53d6\u5230\u660e\u6587\u4fe1\u606f");
        }
        return formatPlainTexts;
    }

    private String[] getTestPlainText() {
        return new String[]{"number = 111__split__test = 444__split__test1 = 555__split__test2 = 666", "name = 222"};
    }

    private void showDetailUI() throws UIException {
        this.checkSelected();
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("Owner", (Object)this);
        String strBosType = this.bosType;
        String[] plainTexts = this.getSelectedPlainText();
        hm.put("bosType", strBosType);
        hm.put("formatPlainTexts", plainTexts);
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.security.client.SignatureDetailUI", hm, null, null);
        uiWindow.show();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"plainText", "user.number"};
        return locateNames;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.showDetailUI();
    }

    @Override
    public void actionVerifySign_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyId = this.getSelectedKeyValue();
        if (StringUtils.isEmpty((String)keyId)) {
            MsgBox.showError((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u6570\u636e");
        }
        logger.info((Object)("verify sign, keyId=" + keyId));
        IEASSignature iEASSignature = EASSignatureFactory.getRemoteInstance();
        EASSignatureInfo signInfo = (EASSignatureInfo)iEASSignature.getValue("select *,user.id,user.number where id='" + keyId + "'");
        IPKIServerExtProvider ipkiServerExtProvider = PKIServerAndClientExtFactory.getServerExtProviderRemote();
        int res = ipkiServerExtProvider.verify(null, signInfo.getPlainText().getBytes(UTF8), signInfo.getSignature().getBytes(UTF8), signInfo.getUser().getNumber());
        logger.info((Object)("verify sign, his plainText=" + signInfo.getPlainText()));
        byte[] hiBytes = signInfo.getPlainText().getBytes(UTF8);
        System.out.print("his plainText bytes begin:");
        for (int i = 0; i < hiBytes.length; ++i) {
            System.out.print(hiBytes[i]);
        }
        System.out.print("his plainText bytes end.");
        logger.info((Object)("verify sign, signInfo.getObjectid()=" + new String(signInfo.getObjectid())));
        logger.info((Object)("verify sign, signInfo.getUser().getNumber()=" + signInfo.getUser().getNumber()));
        logger.info((Object)("verify sign, signInfo.getUser().getId()=" + signInfo.getUser().getId().toString()));
        IFrameHelperFacade facade = FrameHelperFacadeFactory.getRemoteInstance();
        byte[] plainText = facade.getPlainText(BOSObjectType.create((String)signInfo.getBosType()), (IObjectPK)new ObjectStringPK(signInfo.getObjectid()));
        logger.info((Object)("verify sign, biz plainText=" + new String(plainText, UTF8)));
        System.out.print("plainText bytes begin:");
        for (int i = 0; i < plainText.length; ++i) {
            System.out.print(plainText[i]);
        }
        System.out.print("plainText bytes end.");
        int resOfBill = ipkiServerExtProvider.verify(null, plainText, signInfo.getSignature().getBytes(UTF8), signInfo.getUser().getNumber());
        if (res == 0) {
            if (resOfBill != 0) {
                logger.error((Object)("verify sign error! res=0, resOfBill=" + resOfBill));
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.security.CASecurityResource", (String)"signVerifyTrueBizNot"));
            } else {
                logger.error((Object)("verify sign error! res=0, resOfBill=" + resOfBill));
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.security.CASecurityResource", (String)"signVerifyTrue"));
            }
        } else if (resOfBill != 0) {
            logger.error((Object)("verify sign error! res=" + res + ", resOfBill=" + resOfBill));
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.security.CASecurityResource", (String)"signVerifyFalse"));
        } else {
            logger.error((Object)("verify sign error! res=" + res + ", resOfBill=" + resOfBill));
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.security.CASecurityResource", (String)"signVerifyFalseBizTrue"));
        }
    }

    @Override
    public void actionViewAll_actionPerformed(ActionEvent e) throws Exception {
        this.listSelectId = null;
        this.mainQuery = this.viewInfoSave;
        this.execQuery();
    }
}

