/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.UsbkeySupplierEnum;
import com.kingdee.eas.base.security.client.AbstractUsbkeyConfigUI;
import com.kingdee.eas.base.security.usbkey.UsbkeyConfigInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class UsbkeyConfigUI
extends AbstractUsbkeyConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(UsbkeyConfigUI.class);
    public static final String SECURITY_RESOURCE = "com.kingdee.eas.base.security.SecurityResource";
    private ISecurityAuthParamManager manager = SecurityAuthParamManagerFactory.getRemoteInstance();
    private boolean isUsbkeyUseable = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.usbkeySupplierComboBox.addItems(UsbkeySupplierEnum.getEnumList().toArray());
        this.enableUsbkeyAuthCheckBox.setSelected(false);
    }

    private void initData() {
        UsbkeyConfigInfo configInfo = this.manager.getUsbkeyConfigInfo();
        if (!StringUtils.isEmpty((String)configInfo.getUsbkeyUseable())) {
            if (StringUtils.equalsIgnoreCase((String)configInfo.getUsbkeyUseable(), (String)"unknown")) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u914d\u7f6e\u9879USBKEY_USEABLE\u88ab\u6539\u52a8\uff01");
                this.isUsbkeyUseable = false;
            }
            this.isUsbkeyUseable = Boolean.valueOf(configInfo.getUsbkeyUseable());
            this.enableUsbkeyAuthCheckBox.setSelected(this.isUsbkeyUseable);
        }
        this.initSupplierClass(configInfo.getUsbkeySupplierClass());
        this.initWebComponent(configInfo.getWebComponent());
    }

    private void initSupplierClass(String supplierClass) {
        if (!StringUtils.isEmpty((String)supplierClass)) {
            supplierClass = supplierClass.trim();
            Iterator iter = UsbkeySupplierEnum.getEnumList().iterator();
            boolean isDefaultClass = false;
            while (iter.hasNext()) {
                UsbkeySupplierEnum supplier = (UsbkeySupplierEnum)((Object)iter.next());
                if (!supplierClass.equals(supplier.getValue())) continue;
                this.usbkeySupplierComboBox.setSelectedItem((Object)supplier);
                isDefaultClass = true;
                break;
            }
            if (!isDefaultClass) {
                this.usbkeySupplierComboBox.setSelectedItem((Object)UsbkeySupplierEnum.CUSTOM);
                this.customImplClassTextField.setText(supplierClass);
            }
        }
    }

    private void initWebComponent(String webComponent) {
        this.webComponentTextField.setText(webComponent);
    }

    @Override
    protected void enableUsbkeyAuthCheckBox_actionPerformed(ActionEvent e) throws Exception {
        super.enableUsbkeyAuthCheckBox_actionPerformed(e);
    }

    @Override
    protected void saveBtn_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateData()) {
            this.saveData();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SECURITY_RESOURCE, (String)"saveSuccessMsg"));
            this.destroyWindow();
        }
    }

    private boolean validateData() {
        boolean result = this.validateCustomImplClass();
        result = result && this.validateEnableUsbkey();
        return result;
    }

    private boolean validateCustomImplClass() {
        String customClass = this.customImplClassTextField.getText();
        if (UsbkeySupplierEnum.CUSTOM.equals(this.usbkeySupplierComboBox.getSelectedItem()) && StringUtils.isEmpty((String)customClass)) {
            MsgBox.showWarning((String)EASResource.getString((String)SECURITY_RESOURCE, (String)"customClassIsEmptyMsg"));
            return false;
        }
        return true;
    }

    private boolean validateEnableUsbkey() {
        if (this.enableUsbkeyAuthCheckBox.isSelected() == this.isUsbkeyUseable) {
            return true;
        }
        String message = null;
        message = this.isUsbkeyUseable ? "forbidUsbkeyMsg" : "enableUsbkeyMsg";
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)SECURITY_RESOURCE, (String)message)));
    }

    private void saveData() throws Exception {
        UsbkeyConfigInfo configInfo = new UsbkeyConfigInfo();
        String usbkeyUseable = "false";
        if (this.enableUsbkeyAuthCheckBox.isSelected()) {
            usbkeyUseable = "true";
        }
        configInfo.setUsbkeyUseable(usbkeyUseable);
        if (UsbkeySupplierEnum.CUSTOM.equals(this.usbkeySupplierComboBox.getSelectedItem())) {
            configInfo.setUsbkeySupplierClass(this.customImplClassTextField.getText());
        } else {
            String supplierClass = ((UsbkeySupplierEnum)((Object)this.usbkeySupplierComboBox.getSelectedItem())).getValue();
            configInfo.setUsbkeySupplierClass(supplierClass);
        }
        configInfo.setWebComponent(this.webComponentTextField.getText());
        this.manager.storeUsbkeyConfigInfo(configInfo);
    }

    @Override
    protected void cancelBtn_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void usbkeySupplierComboBox_actionPerformed(ActionEvent e) throws Exception {
        if (UsbkeySupplierEnum.CUSTOM.equals(this.usbkeySupplierComboBox.getSelectedItem())) {
            this.customImplClassTextField.setEnabled(true);
        } else {
            this.customImplClassTextField.setEnabled(false);
        }
    }
}

