/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromFile(String fileName) throws IOException {
        FileInputStream fileInputStream = null;
        byte[] buffer = new byte[]{};
        try {
            fileInputStream = new FileInputStream(fileName);
            int total = fileInputStream.available();
            buffer = new byte[total];
            fileInputStream.read(buffer);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return buffer;
    }

    public static void saveBytesToFile(byte[] buffer, String fileName) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(fileName);
            fileOutputStream.write(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File sourceFile, File destFile) throws IOException {
        if (sourceFile != null && destFile != null && sourceFile.exists()) {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                input = new FileInputStream(sourceFile);
                output = new FileOutputStream(destFile);
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = input.read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
                output.flush();
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Close file stream exception: " + e.getMessage()), (Throwable)e);
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Close file stream exception: " + e.getMessage()), (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }
}

