/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.util;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class SecurityAuthConfigUtil {
    private static Logger logger = Logger.getLogger(SecurityAuthConfigUtil.class);
    private static final String DEFAULT_FILE_NAME = "securityAuthConfig.xml";

    public static final XMLConfiguration loadConfigFile() {
        File file = new File(SecurityAuthConfigUtil.getConfigFileFullPath());
        if (!file.exists()) {
            return SecurityAuthConfigUtil.createConfigFile();
        }
        return SecurityAuthConfigUtil.loadConfigFile(file);
    }

    public static final XMLConfiguration loadConfigFile(File file) {
        XMLConfiguration config = null;
        if (file != null && file.exists()) {
            config = XMLConfiguration.getInstance((File)file);
        }
        return config;
    }

    public static final ConfigurationItem getConfigItem(String name) {
        XMLConfiguration config = SecurityAuthConfigUtil.loadConfigFile();
        ConfigurationItem configItem = null;
        if (config != null) {
            configItem = config.getConfigItem(name);
        }
        return configItem;
    }

    protected static XMLConfiguration createConfigFile() {
        File file = SecurityAuthConfigUtil.createConfigFile(SecurityAuthConfigUtil.getConfigFileFullPath());
        return SecurityAuthConfigUtil.loadConfigFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createConfigFile(String pathName) {
        File file = new File(pathName);
        OutputStreamWriter writer = null;
        try {
            Element element = new Element("config");
            Document document = new Document(element);
            XMLOutputter XMLOut = new XMLOutputter();
            writer = new FileWriter(file);
            XMLOut.output(document, (Writer)writer);
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    logger.info((Object)e);
                }
            }
        }
        return file;
    }

    private static String getConfigFileFullPath() {
        String path = System.getProperty("eas.deploy");
        StringBuffer buffer = new StringBuffer(path.trim());
        buffer.append("/");
        buffer.append(DEFAULT_FILE_NAME);
        return buffer.toString();
    }
}

