/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.provider.client.imp;

import com.itrus.pki.rsa.iTrusUsbKey;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.security.provider.PKIException;
import com.kingdee.eas.base.security.provider.client.IPKIClientExt2Provider;
import com.kingdee.util.Base64Encoder;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ItrusPKIClientProvider
implements IPKIClientExt2Provider {
    private static Logger logger = Logger.getLogger(ItrusPKIClientProvider.class);
    private iTrusUsbKey usbkey = null;
    private long checkTime = System.currentTimeMillis();
    private static long t1 = 0L;
    private static long t2 = 0L;
    private int i = 1;

    public ItrusPKIClientProvider() throws UsbKeyException {
        this.initITrusUsbKey();
    }

    private iTrusUsbKey initITrusUsbKey() throws UsbKeyException {
        if (this.usbkey != null) {
            return this.usbkey;
        }
        try {
            this.usbkey = this.createItrusUsbKey();
        }
        catch (Exception e) {
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR, (Throwable)e);
        }
        if (this.usbkey.isUsbKeyExistent() == null) {
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        return this.usbkey;
    }

    @Override
    public boolean checkPasswd(byte[] passwd) {
        return this.usbkey.checkPasswd(passwd);
    }

    @Override
    public byte[] exportCertificate() {
        logger.debug((Object)"\u4eceusbKey\u4e2d\u5bfc\u51fa\u8bc1\u4e66");
        byte[] certificate = this.usbkey.exportCertificate();
        if (certificate == null || certificate.length == 0) {
            logger.debug((Object)"usbkey\u4e2d\u6ca1\u6709\u8bc1\u4e66\uff0c\u6216\u5bfc\u51fa\u8bc1\u4e66\u5931\u8d25");
        } else {
            logger.debug((Object)"\u8bc1\u4e66\u4eceusbkey\u4e2d\u6210\u529f\u5bfc\u51fa");
        }
        return certificate;
    }

    @Override
    public String getKeyID() {
        return this.usbkey.GetKeyID();
    }

    @Override
    public byte[] getUserID() {
        return this.usbkey.getUserID();
    }

    @Override
    public String isUsbKeyExistent() {
        return this.usbkey.isUsbKeyExistent();
    }

    @Override
    public boolean isKeyLogin() throws UsbKeyException {
        iTrusUsbKey usbkey = this.initITrusUsbKey();
        return usbkey.hasLoginOn();
    }

    @Override
    public byte[] sign(byte[] plaintext, String userNumber, byte[] pwd) throws Exception {
        if (this.usbkey.isUsbKeyExistent() == null) {
            logger.error((Object)"usbkey\u672a\u63d2\u4e0a\uff01");
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        if (!Arrays.equals(userNumber.getBytes("utf-8"), this.usbkey.getUserID())) {
            String keyUser = new String(this.usbkey.getUserID(), "utf-8");
            logger.error((Object)("\u7b7e\u540d\uff08key\uff09\u7528\u6237\u4e0e\u767b\u5f55\u7528\u6237\u4e0d\u4e00\u81f4,\u767b\u5f55\u7528\u6237\uff1a" + userNumber + "\u7b7e\u540d\u7528\u6237\uff1a" + keyUser));
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        if (!"finger".equals(this.usbkey.isUsbKeyExistent()) && !this.checkPasswd(pwd)) {
            logger.error((Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!");
            throw new UsbKeyException(UsbKeyException.USB_PWD_ERROR);
        }
        logger.info((Object)("\u6570\u5b57\u7b7e\u540d\u660e\u6587\u4e3a\uff1a" + plaintext));
        byte[] sign = this.usbkey.sign(plaintext);
        logger.info((Object)("\u6570\u5b57\u7b7e\u540d\u5bc6\u6587\u4e3a\uff1a" + sign));
        if (sign == null) {
            throw new PKIException();
        }
        return Base64Encoder.byteArrayToBase64((byte[])sign).getBytes();
    }

    @Override
    public byte[] batchSign(byte[] plaintext, String userNumber, byte[] pwd) throws Exception {
        logger.info((Object)("\u6570\u5b57\u7b7e\u540d\u660e\u6587\u4e3a\uff1a" + new String(plaintext, "utf-8")));
        byte[] sign = this.usbkey.sign(plaintext);
        logger.info((Object)("\u6570\u5b57\u7b7e\u540d\u5bc6\u6587\u4e3a\uff1a" + new String(sign, "utf-8")));
        if (sign == null) {
            throw new PKIException();
        }
        return Base64Encoder.byteArrayToBase64((byte[])sign).getBytes();
    }

    @Override
    public int verify(byte[] plaintext, byte[] signature) throws Exception {
        byte[] signInfo = Base64Encoder.base64ToByteArray((String)new String(signature));
        return this.usbkey.verify(plaintext, signInfo);
    }

    private iTrusUsbKey createItrusUsbKey() throws Exception {
        logger.info((Object)"iTrusUsbKey construction start...");
        String easHome = System.getProperty("easclient.root");
        if (easHome == null || "".equals(easHome)) {
            logger.error((Object)"[CA configPath] EAS_HOME property is null.");
        }
        String configPath = easHome + "/config";
        logger.info((Object)("[CA configPath] configPath is:" + configPath));
        try {
            Constructor con = iTrusUsbKey.class.getConstructor(String.class);
            return (iTrusUsbKey)con.newInstance(configPath);
        }
        catch (NoSuchMethodException e) {
            logger.info((Object)"iTrusUsbKey newInstance() start.");
            try {
                return (iTrusUsbKey)iTrusUsbKey.class.newInstance();
            }
            catch (Exception e1) {
                logger.error((Object)"iTrusUsbKey newInstance() error:", (Throwable)e);
                throw e1;
            }
        }
        catch (Exception e) {
            logger.error((Object)"iTrusUsbKey newInstance(configPath) error:", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void checkUSBKeyState(String userNumber, byte[] pwd) throws Exception {
        if (this.usbkey.isUsbKeyExistent() == null) {
            logger.error((Object)"usbkey\u672a\u63d2\u4e0a\uff01");
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        if (!Arrays.equals(userNumber.getBytes("utf-8"), this.usbkey.getUserID())) {
            String keyUser = new String(this.usbkey.getUserID(), "utf-8");
            logger.error((Object)("\u7b7e\u540d\uff08key\uff09\u7528\u6237\u4e0e\u767b\u5f55\u7528\u6237\u4e0d\u4e00\u81f4,\u767b\u5f55\u7528\u6237\uff1a" + userNumber + "\u7b7e\u540d\u7528\u6237\uff1a" + keyUser));
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        if (!this.checkPasswd(pwd)) {
            logger.error((Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!");
            throw new UsbKeyException(UsbKeyException.USB_PWD_ERROR);
        }
    }
}

