/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BillTypeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.OrgFactory;
import com.kingdee.eas.base.ssc.RoleBussattrFactory;
import com.kingdee.eas.base.ssc.RoleBussattrInfo;
import com.kingdee.eas.base.ssc.RoleCollection;
import com.kingdee.eas.base.ssc.RoleFactory;
import com.kingdee.eas.base.ssc.RoleInfo;
import com.kingdee.eas.base.ssc.RoleOrgFactory;
import com.kingdee.eas.base.ssc.RoleOrgInfo;
import com.kingdee.eas.base.ssc.RoleTypeInfo;
import com.kingdee.eas.base.ssc.RoleUserFactory;
import com.kingdee.eas.base.ssc.RoleUserInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SscRoleImportInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.app.RoleTypeEnum;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SscRoleImport
extends BlockDataTransmission {
    private static final Logger logger = Logger.getLogger(SscRoleImport.class);
    private Map<String, RoleInfo> roleCache = new HashMap<String, RoleInfo>();
    private Map<String, String> roleIdCache = new HashMap<String, String>();
    private Map<String, String> userIdCache = new HashMap<String, String>();
    private Map<String, String> bussIdCache = new HashMap<String, String>();
    private Map<String, String> billIdCache = new HashMap<String, String>();
    private Map<String, String> orgIdCache = new HashMap<String, String>();
    private Map<String, List<String>> roleSystem = new HashMap<String, List<String>>();
    private static Map<String, RoleTypeInfo> roleTypeCache = new HashMap<String, RoleTypeInfo>();
    private HashMap<String, Map<String, Boolean>> isFirstDeleta = null;
    private String shareCenterId = "";
    private String shareCenterName = "";
    private Set<String> roleNumberCache = new HashSet<String>();
    private HashMap<String, Set<String>> roleUserCache = new HashMap();
    private HashMap<String, Set<String>> roleBussCache = new HashMap();
    private HashMap<String, Set<String>> roleBillCache = new HashMap();
    private HashMap<String, Set<String>> roleOrgCache = new HashMap();

    private Map initIsFirstMap() {
        HashMap<String, Boolean> isFirstMap = new HashMap<String, Boolean>();
        isFirstMap.put("roleUser", true);
        isFirstMap.put("roleBuss", true);
        isFirstMap.put("roleOrg", true);
        return isFirstMap;
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.ORMAPPING;
    }

    public String getMainField() {
        return "number";
    }

    private void getExistAndNotColl(Context ctx, Object map, Map<String, String> number2IdMap, IDataBase iDataBase, String key, CoreBaseCollection verifyColl, CoreBaseCollection existColl, CoreBaseCollection notExistColl) {
        try {
            HashSet numberSet = new HashSet();
            if (key.equals("number")) {
                numberSet.addAll((Set)map);
            } else {
                Map temp = (Map)map;
                for (Set number : temp.values()) {
                    numberSet.addAll(number);
                }
            }
            for (String number : number2IdMap.values()) {
                numberSet.remove(number);
            }
            if (numberSet.isEmpty()) {
                return;
            }
            EntityViewInfo existUserView = new EntityViewInfo();
            FilterInfo existFilter = new FilterInfo();
            existFilter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            if (key.equals("number") || key.equals("userNumber")) {
                existFilter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)this.shareCenterId, CompareType.EQUALS));
            }
            existUserView.setFilter(existFilter);
            existColl = iDataBase.getCollection(existUserView);
            for (String number : numberSet) {
                boolean exist = false;
                for (int j = 0; j < existColl.size(); ++j) {
                    CoreBaseInfo coreBaseInfo = existColl.get(j);
                    if (!coreBaseInfo.get("number").toString().equals(number.toString())) continue;
                    exist = true;
                    number2IdMap.put(coreBaseInfo.get("number").toString(), coreBaseInfo.getId().toString());
                    if (!key.equals("number") || !this.isSltImportUpdate()) continue;
                    this.isFirstDeleta.put(coreBaseInfo.getId().toString(), this.initIsFirstMap());
                }
                if (exist) continue;
                for (int i = 0; i < verifyColl.size(); ++i) {
                    SscRoleImportInfo sscRoleImportInfo = (SscRoleImportInfo)verifyColl.get(i);
                    if (null == sscRoleImportInfo.get(key) || !number.equals(sscRoleImportInfo.get(key).toString())) continue;
                    notExistColl.add((CoreBaseInfo)sscRoleImportInfo);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void getExistAndNotCollForAddNew(Context ctx, CoreBaseCollection existColl, CoreBaseCollection notExistColl) throws BOSException {
        HashSet<String> numberSet = new HashSet<String>(this.roleNumberCache);
        for (String number : this.roleIdCache.values()) {
            numberSet.remove(number);
        }
        if (numberSet.isEmpty()) {
            return;
        }
        EntityViewInfo existUserView = new EntityViewInfo();
        FilterInfo existFilter = new FilterInfo();
        existFilter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        existFilter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)this.shareCenterId, CompareType.EQUALS));
        existUserView.setFilter(existFilter);
        existColl = RoleFactory.getLocalInstance(ctx).getCollection(existUserView);
        for (String number : numberSet) {
            boolean exist = false;
            for (int j = 0; j < existColl.size(); ++j) {
                CoreBaseInfo coreBaseInfo = existColl.get(j);
                if (!coreBaseInfo.get("number").toString().equals(number)) continue;
                exist = true;
                this.roleIdCache.put(coreBaseInfo.get("number").toString(), coreBaseInfo.getId().toString());
                if (!this.isSltImportUpdate()) continue;
                this.isFirstDeleta.put(coreBaseInfo.getId().toString(), this.initIsFirstMap());
            }
            if (exist) continue;
            notExistColl.add((CoreBaseInfo)this.roleCache.get(number));
        }
    }

    protected void verifyCoreBaseCollection(Context ctx, CoreBaseCollection coll) throws TaskExternalException {
        CoreBaseCollection existRoleColl = new CoreBaseCollection();
        CoreBaseCollection existUserColl = new CoreBaseCollection();
        CoreBaseCollection existBussColl = new CoreBaseCollection();
        CoreBaseCollection existBillColl = new CoreBaseCollection();
        CoreBaseCollection existOrgColl = new CoreBaseCollection();
        CoreBaseCollection notExistRoleColl = new CoreBaseCollection();
        CoreBaseCollection notExistUserColl = new CoreBaseCollection();
        CoreBaseCollection notExistBussColl = new CoreBaseCollection();
        CoreBaseCollection notExistBillColl = new CoreBaseCollection();
        CoreBaseCollection notExistOrgColl = new CoreBaseCollection();
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        try {
            this.getExistAndNotColl(ctx, this.roleUserCache, this.userIdCache, UserFactory.getLocalInstance(ctx), "userNumber", coll, existUserColl, notExistUserColl);
            this.getExistAndNotColl(ctx, this.roleBussCache, this.bussIdCache, BussinessAttributeFactory.getLocalInstance(ctx), "bussNumber", coll, existBussColl, notExistBussColl);
            this.getExistAndNotColl(ctx, this.roleBillCache, this.billIdCache, BillTypeFactory.getLocalInstance(ctx), "billNumber", coll, existBillColl, notExistBillColl);
            this.getExistAndNotColl(ctx, this.roleOrgCache, this.orgIdCache, (IDataBase)OrgFactory.getLocalInstance(ctx), "orgNumber", coll, existOrgColl, notExistOrgColl);
            if (this.isSltImportUpdate()) {
                this.getExistAndNotColl(ctx, this.roleNumberCache, this.roleIdCache, RoleFactory.getLocalInstance(ctx), "number", coll, existRoleColl, notExistRoleColl);
                for (int i = 0; i < notExistRoleColl.size(); ++i) {
                    SscRoleImportInfo sscRoleImportInfo = (SscRoleImportInfo)notExistRoleColl.get(i);
                    Integer row = sscRoleImportInfo.getRow();
                    String errMsg = "\u89d2\u8272" + sscRoleImportInfo.getNumber() + "\u4e0d\u5b58\u5728";
                    errorMap.put(row, errMsg);
                }
            } else if (!this.roleNumberCache.isEmpty()) {
                this.getExistAndNotCollForAddNew(ctx, existRoleColl, notExistRoleColl);
                if (notExistRoleColl.size() > 0) {
                    IObjectPK[] pks = RoleFactory.getLocalInstance(ctx).addnewBatchData(notExistRoleColl);
                    RoleCollection roleColls = RoleFactory.getLocalInstance(ctx).getRoleCollection("where id in " + FormatUtils.IObjectPK2Sql(pks));
                    for (int i = 0; i < roleColls.size(); ++i) {
                        RoleInfo roleInfo = roleColls.get(i);
                        this.roleIdCache.put(roleInfo.getNumber(), roleInfo.getId().toString());
                    }
                }
            }
            this.getErrorMsg(errorMap, notExistUserColl, "\u7528\u6237\u5728\u5171\u4eab\u4e2d\u5fc3" + this.shareCenterName, "userNumber");
            this.getErrorMsg(errorMap, notExistBussColl, "\u4efb\u52a1\u7c7b\u578b", "bussNumber");
            this.getErrorMsg(errorMap, notExistBillColl, "\u5355\u636e\u7c7b\u578b", "billNumber");
            this.getErrorMsg(errorMap, notExistOrgColl, "\u7ec4\u7ec7", "orgNumber");
            for (String roleNumber : this.roleOrgCache.keySet()) {
                String roleId = this.roleIdCache.get(roleNumber);
                List<String> systemIdList = this.roleSystem.get(roleId);
                if (null == systemIdList) {
                    systemIdList = this.getSystemIdList(ctx, roleId);
                    this.roleSystem.put(roleId, systemIdList);
                }
                List<Object> orgIdList = new ArrayList();
                if (!systemIdList.isEmpty()) {
                    orgIdList = this.getOrgidList(ctx, systemIdList);
                }
                for (int i = 0; i < existOrgColl.size(); ++i) {
                    SscRoleImportInfo sscRoleImportInfo = (SscRoleImportInfo)existOrgColl.get(i);
                    String orgNumber = sscRoleImportInfo.getOrgNumber();
                    if (!roleNumber.equals(sscRoleImportInfo.getNumber()) || orgIdList.contains(orgNumber)) continue;
                    String errorMsg = (String)errorMap.get(sscRoleImportInfo.getRow());
                    errorMsg = StringUtils.isNotBlank((CharSequence)errorMsg) ? errorMsg + "\uff0c\u7ec4\u7ec7" + orgNumber + "\u6ca1\u5206\u914d\u5168\u90e8\u4e1a\u52a1\u57df\u804c\u8d23" : errorMsg + "\u7ec4\u7ec7" + orgNumber + "\u6ca1\u5206\u914d\u5168\u90e8\u4e1a\u52a1\u57df\u804c\u8d23";
                    this.roleOrgCache.get(roleNumber).remove(orgNumber);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (Map.Entry entry : errorMap.entrySet()) {
            this.writeLog((Integer)entry.getKey(), (Exception)new TaskExternalException((String)entry.getValue()));
        }
    }

    private List<String> getOrgidList(Context ctx, List<String> systemIdList) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select org.fid from t_ssc_org org");
        for (int i = 0; i < systemIdList.size(); ++i) {
            sb.append(" inner join t_ssc_sysAttrOrgSCMap map" + i);
            sb.append(" on org.fid = map" + i + ".FORGID");
            sb.append(" and map" + i + ".FSYSTEMATTRIBUTEID = '" + systemIdList.get(i) + "'");
            sb.append(" and map" + i + ".fsharecenterid = '" + this.shareCenterId + "'");
        }
        ArrayList<String> orgIdList = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                orgIdList.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return orgIdList;
    }

    private List<String> getSystemIdList(Context ctx, String roleId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select bt.FSYSATTRID from t_ssc_billtype bt");
        sb.append(" left join T_ssc_bussinessattribute ba on bt.fid = ba.FBILLTYPEID ");
        sb.append(" left join T_ssc_rolebussattr rb on ba.fid = rb.FBUSSNAMEID ");
        sb.append(" where rb.FPARENTID = ?");
        ArrayList<String> systemIdList = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{roleId});
            while (rs.next()) {
                systemIdList.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return systemIdList;
    }

    private void getErrorMsg(Map<Integer, String> errorMap, CoreBaseCollection notExistOrgColl, String msg, String key) {
        for (int i = 0; i < notExistOrgColl.size(); ++i) {
            SscRoleImportInfo sscRoleImportInfo = (SscRoleImportInfo)notExistOrgColl.get(i);
            Integer row = sscRoleImportInfo.getRow();
            String errMsg = errorMap.get(row);
            errMsg = StringUtils.isBlank((CharSequence)errMsg) ? msg + sscRoleImportInfo.get(key) + "\u4e0d\u5b58\u5728" : errMsg + "\uff0c" + msg + sscRoleImportInfo.get(key) + "\u4e0d\u5b58\u5728";
            errorMap.put(row, errMsg);
        }
    }

    protected Result submitCoreBaseCollection(Context ctx, CoreBaseCollection coll) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                for (String roleNumber : this.roleNumberCache) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("description"));
                    sic.add(new SelectorItemInfo("roleTypeID"));
                    RoleFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)this.roleCache.get(roleNumber), sic);
                    String roleId = this.roleIdCache.get(roleNumber);
                    if (this.isFirstDeleta.get(roleId).get("roleUser").booleanValue()) {
                        RoleUserFactory.getLocalInstance(ctx).delete("where roleID = '" + roleId + "'");
                    }
                    if (this.isFirstDeleta.get(roleId).get("roleBuss").booleanValue()) {
                        RoleBussattrFactory.getLocalInstance(ctx).delete("where parent = '" + roleId + "'");
                    }
                    if (!this.isFirstDeleta.get(roleId).get("roleOrg").booleanValue()) continue;
                    RoleOrgFactory.getLocalInstance(ctx).delete("where roleID = '" + roleId + "'");
                }
            }
            this.addRoleUser(ctx);
            this.addRoleOrg(ctx);
            this.addRoleBill(ctx);
            this.addRoleBuss(ctx);
            this.roleNumberCache = new HashSet<String>();
            this.roleBussCache = new HashMap();
            this.roleBillCache = new HashMap();
            this.roleOrgCache = new HashMap();
            this.roleUserCache = new HashMap();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void addRoleUser(Context ctx) throws EASBizException, BOSException {
        if (this.roleIdCache.isEmpty() || this.userIdCache.isEmpty() || this.roleUserCache.isEmpty()) {
            return;
        }
        CoreBaseCollection roleUserColl = new CoreBaseCollection();
        for (String roleNumber : this.roleUserCache.keySet()) {
            Set<String> userNumbers = this.roleUserCache.get(roleNumber);
            for (String userNumber : userNumbers) {
                String userId = this.userIdCache.get(userNumber);
                if (!StringUtils.isNotBlank((CharSequence)userId)) continue;
                RoleUserInfo info = new RoleUserInfo(this.roleIdCache.get(roleNumber), userId);
                roleUserColl.add((CoreBaseInfo)info);
            }
        }
        if (roleUserColl.isEmpty()) {
            return;
        }
        try {
            RoleUserInfo info;
            StringBuffer sb = new StringBuffer("SELECT FROLEIDID,FUSERIDID FROM T_ssc_roleuser where ");
            for (int i = 0; i < roleUserColl.size(); ++i) {
                info = (RoleUserInfo)roleUserColl.get(i);
                sb.append("(FROLEIDID ='" + info.getRoleID().getId().toString() + "' and FUSERIDID ='" + info.getUserID().getId().toString() + "') or ");
            }
            sb.delete(sb.length() - " or ".length(), sb.length());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                info = new RoleUserInfo(rs.getString("FROLEIDID"), rs.getString("FUSERIDID"));
                roleUserColl.remove((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!roleUserColl.isEmpty()) {
            RoleUserFactory.getLocalInstance(ctx).addnew(roleUserColl);
        }
    }

    private void addRoleOrg(Context ctx) throws EASBizException, BOSException {
        if (this.roleIdCache.isEmpty() || this.roleOrgCache.isEmpty() || this.orgIdCache.isEmpty()) {
            return;
        }
        CoreBaseCollection roleOrgColl = new CoreBaseCollection();
        for (String roleNumber : this.roleOrgCache.keySet()) {
            Set<String> orgNumbers = this.roleOrgCache.get(roleNumber);
            for (String orgNumber : orgNumbers) {
                String orgId = this.orgIdCache.get(orgNumber);
                if (!StringUtils.isNotBlank((CharSequence)orgId)) continue;
                RoleOrgInfo info = new RoleOrgInfo(this.roleIdCache.get(roleNumber), orgId);
                roleOrgColl.add((CoreBaseInfo)info);
            }
        }
        if (roleOrgColl.isEmpty()) {
            return;
        }
        try {
            RoleOrgInfo info;
            StringBuffer sb = new StringBuffer("SELECT FROLEIDID,FORGIDID FROM T_ssc_roleorg where ");
            for (int i = 0; i < roleOrgColl.size(); ++i) {
                info = (RoleOrgInfo)roleOrgColl.get(i);
                sb.append("(FROLEIDID ='" + info.getRoleID().getId().toString() + "' and FORGIDID ='" + info.getOrgID().getId().toString() + "') or ");
            }
            sb.delete(sb.length() - " or ".length(), sb.length());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                info = new RoleOrgInfo(rs.getString("FROLEIDID"), rs.getString("FORGIDID"));
                roleOrgColl.remove((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!roleOrgColl.isEmpty()) {
            RoleOrgFactory.getLocalInstance(ctx).addnew(roleOrgColl);
        }
    }

    private void addRoleBill(Context ctx) throws EASBizException, BOSException {
        if (this.roleIdCache.isEmpty() || this.roleBillCache.isEmpty() || this.billIdCache.isEmpty()) {
            return;
        }
        CoreBaseCollection roleBillColl = new CoreBaseCollection();
        for (String roleNumber : this.roleBillCache.keySet()) {
            Set<String> billNumbers = this.roleBillCache.get(roleNumber);
            for (String billNumber : billNumbers) {
                String billId = this.billIdCache.get(billNumber);
                if (!StringUtils.isNotBlank((CharSequence)billId)) continue;
                RoleBussattrInfo info = new RoleBussattrInfo(this.roleIdCache.get(roleNumber), null, billId);
                roleBillColl.add((CoreBaseInfo)info);
            }
        }
        if (roleBillColl.isEmpty()) {
            return;
        }
        try {
            RoleBussattrInfo info;
            StringBuffer sb = new StringBuffer("SELECT FPARENTID,FBILLNAMEID FROM T_ssc_rolebussattr where ");
            for (int i = 0; i < roleBillColl.size(); ++i) {
                info = (RoleBussattrInfo)roleBillColl.get(i);
                sb.append("(FPARENTID ='" + info.getParent().getId().toString() + "' and FBILLNAMEID ='" + info.getBillName().getId().toString() + "') or ");
            }
            sb.delete(sb.length() - " or ".length(), sb.length());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                info = new RoleBussattrInfo(rs.getString("FPARENTID"), null, rs.getString("FBILLNAMEID"));
                roleBillColl.remove((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!roleBillColl.isEmpty()) {
            RoleBussattrFactory.getLocalInstance(ctx).addnew(roleBillColl);
        }
    }

    private void addRoleBuss(Context ctx) throws EASBizException, BOSException {
        if (this.roleIdCache.isEmpty() || this.roleBussCache.isEmpty() || this.bussIdCache.isEmpty()) {
            return;
        }
        CoreBaseCollection roleBussColl = new CoreBaseCollection();
        for (String roleNumber : this.roleBussCache.keySet()) {
            Set<String> bussNumbers = this.roleBussCache.get(roleNumber);
            for (String bussNumber : bussNumbers) {
                String bussId = this.bussIdCache.get(bussNumber);
                if (!StringUtils.isNotBlank((CharSequence)bussId)) continue;
                RoleBussattrInfo info = new RoleBussattrInfo(this.roleIdCache.get(roleNumber), bussId, null);
                roleBussColl.add((CoreBaseInfo)info);
            }
        }
        if (roleBussColl.isEmpty()) {
            return;
        }
        try {
            RoleBussattrInfo info;
            StringBuffer sb = new StringBuffer("SELECT FPARENTID,FBUSSNAMEID FROM T_ssc_rolebussattr where ");
            for (int i = 0; i < roleBussColl.size(); ++i) {
                info = (RoleBussattrInfo)roleBussColl.get(i);
                sb.append("(FPARENTID ='" + info.getParent().getId().toString() + "' and FBUSSNAMEID ='" + info.getBussName().getId().toString() + "') or ");
            }
            sb.delete(sb.length() - " or ".length(), sb.length());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                info = new RoleBussattrInfo(rs.getString("FPARENTID"), rs.getString("FBUSSNAMEID"), null);
                roleBussColl.remove((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!roleBussColl.isEmpty()) {
            RoleBussattrFactory.getLocalInstance(ctx).addnew(roleBussColl);
        }
    }

    private String getData(IRecord rec, String key) {
        return rec.get((String)key).data.toString();
    }

    private SscRoleImportInfo getSscRoleImportInfo(IRecord rec) throws TaskExternalException {
        int row = rec.getRowNum();
        String number = this.getData(rec, "number");
        String name = this.getData(rec, "name");
        String roleTypeName = this.getData(rec, "roleTypeName");
        String description = this.getData(rec, "description");
        String bussOrBillNumber = this.getData(rec, "bussNumber");
        String orgNumber = this.getData(rec, "orgNumber");
        String userNumber = this.getData(rec, "userNumber");
        SscRoleImportInfo sscRoleImportInfo = new SscRoleImportInfo();
        sscRoleImportInfo.setRow(row);
        sscRoleImportInfo.setNumber(number);
        sscRoleImportInfo.setName(name);
        sscRoleImportInfo.setDescription(description);
        sscRoleImportInfo.setRoleTypeName(roleTypeName);
        if (this.isBussType(roleTypeName)) {
            sscRoleImportInfo.setBussNumber(bussOrBillNumber);
        } else if (this.isBillType(roleTypeName)) {
            sscRoleImportInfo.setBillNumber(bussOrBillNumber);
        } else if (StringUtils.isNotBlank((CharSequence)bussOrBillNumber)) {
            if (this.isSltImportUpdate()) {
                throw new TaskExternalException("\u89d2\u8272\u7c7b\u578b\u9519\u8bef\uff0c\u65e0\u6cd5\u66f4\u65b0\u4efb\u52a1/\u5355\u636e\u7c7b\u578b");
            }
            throw new TaskExternalException("\u89d2\u8272\u7c7b\u578b\u9519\u8bef\uff0c\u65e0\u6cd5\u65b0\u589e\u4efb\u52a1/\u5355\u636e\u7c7b\u578b");
        }
        sscRoleImportInfo.setOrgNumber(orgNumber);
        sscRoleImportInfo.setUserNumber(userNumber);
        return sscRoleImportInfo;
    }

    protected CoreBaseInfo toCoreBaseInfo(Context ctx, IRecord rec) throws TaskExternalException {
        RoleInfo temp;
        try {
            if (StringUtils.isBlank((CharSequence)this.shareCenterId)) {
                this.shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            }
            if (StringUtils.isBlank((CharSequence)this.shareCenterName)) {
                this.shareCenterName = ShareCenterUtils.getShareCenterNameByCtx(ctx);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SSCException e) {
            logger.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.verifyCoreBaseInfo(ctx, rec);
        SscRoleImportInfo sscRoleImportInfo = this.getSscRoleImportInfo(rec);
        String number = sscRoleImportInfo.getNumber();
        String name = sscRoleImportInfo.getName();
        String description = sscRoleImportInfo.getDescription();
        String roleTypeName = sscRoleImportInfo.getRoleTypeName();
        String bussNumber = sscRoleImportInfo.getBussNumber();
        String billNumber = sscRoleImportInfo.getBillNumber();
        String orgNumber = sscRoleImportInfo.getOrgNumber();
        String userNumber = sscRoleImportInfo.getUserNumber();
        RoleInfo info = new RoleInfo();
        info.setNumber(number);
        info.setName(name);
        info.setDescription(description);
        info.setRoleTypeID(roleTypeCache.get(roleTypeName));
        info.setShareCenterID(this.shareCenterId);
        FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)info);
        if (this.isSltImportUpdate()) {
            this.roleNumberCache.add(number);
        }
        if (null == (temp = this.roleCache.get(number))) {
            this.roleCache.put(number, info);
            this.roleNumberCache.add(number);
        } else {
            if (!temp.getName().equals(info.getName())) {
                throw new TaskExternalException("\u7f16\u7801\u4e3a" + number + "\u7684\u89d2\u8272\u5df2\u5b58\u5728\uff0c\u4e14\u540d\u79f0\u4e0d\u4e3a" + name);
            }
            if (!temp.getRoleTypeID().getId().toString().equals(info.getRoleTypeID().getId().toString())) {
                throw new TaskExternalException("\u7f16\u7801\u4e3a" + number + "\u7684\u89d2\u8272\u5df2\u5b58\u5728\uff0c\u4e14\u89d2\u8272\u7c7b\u578b\u4e0d\u4e3a" + roleTypeName);
            }
            if (!temp.getDescription().equals(info.getDescription())) {
                throw new TaskExternalException("\u7f16\u7801\u4e3a" + number + "\u7684\u89d2\u8272\u5df2\u5b58\u5728\uff0c\u4e14\u63cf\u8ff0\u4e0d\u4e3a" + description);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bussNumber)) {
            Set<String> bussSet = this.roleBussCache.get(number);
            if (null == bussSet) {
                bussSet = new HashSet<String>();
            }
            bussSet.add(bussNumber);
            this.roleBussCache.put(number, bussSet);
        } else if (StringUtils.isNotBlank((CharSequence)billNumber)) {
            Set<String> billSet = this.roleBillCache.get(number);
            if (null == billSet) {
                billSet = new HashSet<String>();
            }
            billSet.add(billNumber);
            this.roleBillCache.put(number, billSet);
        }
        if (StringUtils.isNotBlank((CharSequence)orgNumber)) {
            Set<String> orgSet = this.roleOrgCache.get(number);
            if (null == orgSet) {
                orgSet = new HashSet<String>();
            }
            orgSet.add(orgNumber);
            this.roleOrgCache.put(number, orgSet);
        }
        if (StringUtils.isNotBlank((CharSequence)userNumber)) {
            Set<String> userSet = this.roleUserCache.get(number);
            if (null == userSet) {
                userSet = new HashSet<String>();
            }
            userSet.add(userNumber);
            this.roleUserCache.put(number, userSet);
        }
        return sscRoleImportInfo;
    }

    private void verifyCoreBaseInfo(Context ctx, IRecord rec) throws TaskExternalException {
        if (StringUtils.isEmpty((CharSequence)rec.get((String)"number").data.toString())) {
            throw new TaskExternalException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)rec.get((String)"name").data.toString())) {
            throw new TaskExternalException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)rec.get((String)"roleTypeName").data.toString())) {
            throw new TaskExternalException("\u89d2\u8272\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean isBussType(String roleTypeName) {
        return RoleTypeEnum.ROLE_BIZ.getAlias().equals(roleTypeName) || RoleTypeEnum.ROLE_BIZADMIN.getAlias().equals(roleTypeName);
    }

    private boolean isBillType(String roleTypeName) {
        return RoleTypeEnum.ROLE_QUALITY.getAlias().equals(roleTypeName) || RoleTypeEnum.ROLE_LATER.getAlias().equals(roleTypeName) || RoleTypeEnum.ROLE_AUDIT.getAlias().equals(roleTypeName) || RoleTypeEnum.ROLE_RECHECKADMIN.getAlias().equals(roleTypeName);
    }

    static {
        List roleTypeList = RoleTypeEnum.getEnumList();
        for (RoleTypeEnum roleType : roleTypeList) {
            RoleTypeInfo info = new RoleTypeInfo();
            info.setId(BOSUuid.read((String)roleType.getValue()));
            roleTypeCache.put(roleType.getAlias(), info);
        }
    }
}

