/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.analysis.ThreadPoll;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.BillAnalysisFactory;
import com.kingdee.eas.base.ssc.BillAnalysisInfo;
import com.kingdee.eas.base.ssc.JobExtFactory;
import com.kingdee.eas.base.ssc.JobExtInfo;
import com.kingdee.eas.base.ssc.JobHisExtFactory;
import com.kingdee.eas.base.ssc.JobHisExtInfo;
import com.kingdee.eas.base.ssc.analysis.factory.AnalysisFactory;
import com.kingdee.eas.base.ssc.analysis.util.AnalysisData;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.common.EASBizException;
import java.util.Map;
import org.apache.log4j.Logger;

public class Analysis
implements Runnable {
    public static final String JOB = "job";
    public static final String BILL = "bill";
    public Logger logger = Logger.getLogger(Analysis.class);
    private String name;
    private String uuid;
    private AnalysisData analysisData;
    private Context ctx = null;

    public Analysis(AnalysisData analysisData, Context ctx) {
        this.name = analysisData.getAnalysisType();
        this.analysisData = analysisData;
        this.uuid = analysisData.getUuid();
        this.ctx = ctx;
    }

    @Override
    public void run() {
        try {
            this.analysisData.setData(AnalysisFactory.getAnalysisInstance(this.ctx, this.analysisData.getOperateType()).execute(this.uuid, null));
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return;
        }
        if (this.name.equals(JOB)) {
            this.executeJob(this.analysisData);
        } else if (this.name.equals(BILL)) {
            this.executeBill(this.analysisData);
        }
    }

    private Boolean executeJob(AnalysisData analysisData) {
        if (analysisData == null || null == analysisData.getData()) {
            this.logger.error((Object)("\u6267\u884c\u4efb\u52a1\u76d1\u63a7\u6570\u636e\u4e3a\u7a7a\uff01id\u4e3a:" + analysisData.getUuid()));
            return false;
        }
        this.prepareData(analysisData.getData());
        return true;
    }

    private Boolean executeBill(AnalysisData analysisData) {
        if (analysisData == null || null == analysisData.getData()) {
            this.logger.error((Object)("\u6267\u884c\u4efb\u52a1\u76d1\u63a7\u6570\u636e\u4e3a\u7a7a\uff01id\u4e3a:" + analysisData.getUuid()));
            return false;
        }
        this.prepareData(analysisData.getData());
        return true;
    }

    private void prepareData(Map<String, Object> map) {
        BillAnalysisInfo billAnalysisInfo = null;
        JobExtInfo jobExtInfo = null;
        JobHisExtInfo jobHisExtInfo = null;
        for (String key : map.keySet()) {
            if (key.equals(BILL)) {
                billAnalysisInfo = (BillAnalysisInfo)map.get(key);
                continue;
            }
            if (key.equals(JOB)) {
                jobExtInfo = (JobExtInfo)map.get(key);
                continue;
            }
            if (!key.equals("jobhis")) continue;
            jobHisExtInfo = (JobHisExtInfo)map.get(key);
        }
        try {
            this.updateBillData(billAnalysisInfo);
            this.updateJobData(jobExtInfo);
            this.updateJobHisData(jobHisExtInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void updateBillData(BillAnalysisInfo billAnalysisInfo) throws BOSException, EASBizException {
        if (null == billAnalysisInfo) {
            return;
        }
        if (BillAnalysisFactory.getLocalInstance(this.ctx).exists("where billid = '" + billAnalysisInfo.getBillId() + "' ")) {
            BillAnalysisFactory.getLocalInstance(this.ctx).update(H.PK(billAnalysisInfo.getId().toString()), billAnalysisInfo);
        } else {
            BillAnalysisFactory.getLocalInstance(this.ctx).addnew(billAnalysisInfo);
        }
    }

    private void updateJobData(JobExtInfo jobExtInfo) throws BOSException, EASBizException {
        if (null == jobExtInfo) {
            return;
        }
        if (JobExtFactory.getLocalInstance(this.ctx).exists("where job = '" + jobExtInfo.getJob().getId().toString() + "' ")) {
            JobExtFactory.getLocalInstance(this.ctx).update(H.PK(jobExtInfo.getJob().getId().toString()), jobExtInfo);
        } else {
            JobExtFactory.getLocalInstance(this.ctx).addnew(jobExtInfo);
        }
    }

    private void updateJobHisData(JobHisExtInfo jobHisExtInfo) throws BOSException, EASBizException {
        if (null == jobHisExtInfo) {
            return;
        }
        if (JobHisExtFactory.getLocalInstance(this.ctx).exists("where job = '" + jobHisExtInfo.getJob().getId().toString() + "' ")) {
            JobHisExtFactory.getLocalInstance(this.ctx).update(H.PK(jobHisExtInfo.getJob().getId().toString()), jobHisExtInfo);
        } else {
            JobHisExtFactory.getLocalInstance(this.ctx).addnew(jobHisExtInfo);
        }
    }
}

